/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.inv.IAdvInventory;
import com.denfop.invslot.InvSlot;
import com.denfop.items.resource.ItemCraftingElements;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InvSlotScheduleReactor
extends InvSlot {
    private final int type;
    private final int level;
    private final int x;
    private final int y;
    Map<Integer, ItemStack> accepts = new HashMap<Integer, ItemStack>();

    public InvSlotScheduleReactor(IAdvInventory<?> base, int type, int level, int x, int y) {
        super(base, InvSlot.TypeItemSlot.INPUT_OUTPUT, 1);
        this.type = type;
        this.level = level;
        this.x = x;
        this.y = y;
    }

    public Map<Integer, ItemStack> getAccepts() {
        return this.accepts;
    }

    @Override
    public int getStackSizeLimit() {
        return 1;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemCraftingElements) {
            if (stack.func_77952_i() == 143) {
                NBTTagCompound nbt = ModUtils.nbt(stack);
                return this.type == nbt.func_74762_e("type") && this.level == nbt.func_74762_e("level");
            }
            return false;
        }
        return false;
    }

    @Override
    public void update() {
        this.accepts.clear();
        if (!this.get().func_190926_b()) {
            NBTTagCompound nbt = ModUtils.nbt(this.get());
            NBTTagList nbtTagList = nbt.func_150295_c("Items", 10);
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound contentTag = nbtTagList.func_150305_b(i);
                ItemStack stack = new ItemStack(contentTag);
                stackList.add(stack);
            }
            for (int y = 0; y < this.y; ++y) {
                for (int x = 0; x < this.x; ++x) {
                    NBTTagCompound tag = nbt.func_74775_l(String.valueOf(y * this.x + x));
                    if (tag.func_74767_n("empty")) {
                        this.accepts.put(y * this.x + x, ItemStack.field_190927_a);
                        continue;
                    }
                    int indexItem = tag.func_74762_e("index");
                    this.accepts.put(y * this.x + x, (ItemStack)stackList.get(indexItem));
                }
            }
        }
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        this.accepts = new HashMap<Integer, ItemStack>();
        if (!content.func_190926_b()) {
            NBTTagCompound nbt = ModUtils.nbt(content);
            NBTTagList nbtTagList = nbt.func_150295_c("Items", 10);
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            for (int i = 0; i < nbtTagList.func_74745_c(); ++i) {
                NBTTagCompound contentTag = nbtTagList.func_150305_b(i);
                ItemStack stack = new ItemStack(contentTag);
                stackList.add(stack);
            }
            for (int y = 0; y < this.y; ++y) {
                for (int x = 0; x < this.x; ++x) {
                    NBTTagCompound tag = nbt.func_74775_l(String.valueOf(y * this.x + x));
                    if (tag.func_74767_n("empty")) {
                        this.accepts.put(y * this.x + x, ItemStack.field_190927_a);
                        continue;
                    }
                    int indexItem = tag.func_74762_e("index");
                    this.accepts.put(y * this.x + x, (ItemStack)stackList.get(indexItem));
                }
            }
        }
    }
}

