/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.invslot.InvSlot;
import com.denfop.items.modules.EnumSpawnerModules;
import com.denfop.items.modules.EnumSpawnerType;
import com.denfop.items.modules.ItemSpawnerModules;
import com.denfop.tiles.base.TileAutoSpawner;
import net.minecraft.item.ItemStack;

public class InvSlotUpgradeModule
extends InvSlot {
    private final TileAutoSpawner tile;
    private int stackSizeLimit;

    public InvSlotUpgradeModule(TileAutoSpawner base1) {
        super(base1, InvSlot.TypeItemSlot.INPUT, 4);
        this.tile = base1;
        this.stackSizeLimit = 1;
    }

    @Override
    public void update() {
        int spawn = 1;
        int chance = 0;
        int speed = 0;
        int experience = 0;
        this.tile.costenergy = this.tile.defaultconsume;
        int fireAspect = 0;
        block7: for (int i = 0; i < this.size(); ++i) {
            this.tile.lootContext[i] = null;
            if (this.get(i).func_190926_b()) continue;
            EnumSpawnerModules module = EnumSpawnerModules.getFromID(this.get(i).func_77952_i());
            EnumSpawnerType type = module.type;
            switch (type) {
                case SPAWN: {
                    if ((spawn += module.percent) > 4) continue block7;
                    this.tile.costenergy *= module.percent;
                    continue block7;
                }
                case LUCKY: {
                    if ((chance += module.percent) > 3) continue block7;
                    this.tile.costenergy = (int)((double)this.tile.costenergy + (double)(module.percent * this.tile.costenergy) * 0.2);
                    continue block7;
                }
                case SPEED: {
                    if ((speed += module.percent) > 80) continue block7;
                    this.tile.costenergy += module.percent * this.tile.costenergy / 100;
                    continue block7;
                }
                case EXPERIENCE: {
                    if ((experience += module.percent) > 100) continue block7;
                    this.tile.costenergy += module.percent * this.tile.costenergy / 100;
                    continue block7;
                }
                case FIRE: {
                    ++fireAspect;
                    this.tile.costenergy += module.percent * this.tile.costenergy / 100;
                }
            }
        }
        this.tile.chance = Math.min(3, chance);
        this.tile.spawn = Math.min(4, spawn);
        this.tile.speed = Math.min(80, speed);
        this.tile.experience = Math.min(100, experience);
        this.tile.fireAspect = Math.min(1, fireAspect);
    }

    @Override
    public void put(int index, ItemStack content) {
        super.put(index, content);
        int spawn = 1;
        int chance = 0;
        int speed = 0;
        int experience = 0;
        this.tile.costenergy = this.tile.defaultconsume;
        int fireAspect = 0;
        block7: for (int i = 0; i < this.size(); ++i) {
            this.tile.lootContext[i] = null;
            if (this.get(i).func_190926_b()) continue;
            EnumSpawnerModules module = EnumSpawnerModules.getFromID(this.get(i).func_77952_i());
            EnumSpawnerType type = module.type;
            switch (type) {
                case SPAWN: {
                    if ((spawn += module.percent) > 4) continue block7;
                    this.tile.costenergy *= module.percent;
                    continue block7;
                }
                case LUCKY: {
                    if ((chance += module.percent) > 3) continue block7;
                    this.tile.costenergy = (int)((double)this.tile.costenergy + (double)(module.percent * this.tile.costenergy) * 0.2);
                    continue block7;
                }
                case SPEED: {
                    if ((speed += module.percent) > 80) continue block7;
                    this.tile.costenergy += module.percent * this.tile.costenergy / 100;
                    continue block7;
                }
                case EXPERIENCE: {
                    if ((experience += module.percent) > 100) continue block7;
                    this.tile.costenergy += module.percent * this.tile.costenergy / 100;
                    continue block7;
                }
                case FIRE: {
                    ++fireAspect;
                    this.tile.costenergy += module.percent * this.tile.costenergy / 100;
                }
            }
        }
        this.tile.chance = Math.min(3, chance);
        this.tile.spawn = Math.min(4, spawn);
        this.tile.speed = Math.min(80, speed);
        this.tile.experience = Math.min(100, experience);
        this.tile.fireAspect = Math.min(1, fireAspect);
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        return itemStack.func_77973_b() instanceof ItemSpawnerModules;
    }

    @Override
    public int getStackSizeLimit() {
        return this.stackSizeLimit;
    }

    @Override
    public void setStackSizeLimit(int stackSizeLimit) {
        this.stackSizeLimit = stackSizeLimit;
    }
}

