/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.api.gui.EnumTypeSlot;
import com.denfop.api.gui.ITypeSlot;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemWaterRod;
import com.denfop.items.ItemWaterRotor;
import com.denfop.tiles.mechanism.water.TileBaseWaterGenerator;
import net.minecraft.item.ItemStack;

public class InvSlotWaterRotorBlades
extends InvSlot
implements ITypeSlot {
    private final TileBaseWaterGenerator windGenerator;

    public InvSlotWaterRotorBlades(TileBaseWaterGenerator windGenerator) {
        super(windGenerator, InvSlot.TypeItemSlot.INPUT, 1);
        this.setStackSizeLimit(64);
        this.windGenerator = windGenerator;
    }

    @Override
    public EnumTypeSlot getTypeSlot(int slotid) {
        return EnumTypeSlot.WATER_ROD_PART;
    }

    @Override
    public boolean accepts(ItemStack stack, int index) {
        if (this.windGenerator.getRotor() == null) {
            return false;
        }
        if (this.windGenerator.getRotor() != null && stack.func_77973_b() instanceof ItemWaterRod) {
            return ((ItemWaterRod)stack.func_77973_b()).getLevel(this.windGenerator.getRotor().getLevel(), stack.func_77952_i());
        }
        return false;
    }

    public void consume(int amount) {
        this.consume(amount, false);
    }

    public void work() {
        if (this.get().func_190926_b()) {
            return;
        }
        ItemStack stack = this.windGenerator.slot.get();
        if (this.windGenerator.getRotor() != null && this.get().func_77973_b() instanceof ItemWaterRod && ((ItemWaterRod)this.get().func_77973_b()).getLevel(this.windGenerator.getRotor().getLevel(), this.get().func_77952_i()) && (double)((ItemWaterRotor)stack.func_77973_b()).getCustomDamage(stack) <= (double)((ItemWaterRotor)stack.func_77973_b()).getMaxCustomDamage(stack) * 0.75) {
            this.windGenerator.slot.damage((int)((double)(-1 * ((ItemWaterRotor)stack.func_77973_b()).getMaxCustomDamage(stack)) * 0.25), 0.0);
            this.get().func_190918_g(1);
        }
    }

    public void consume(int amount, boolean simulate) {
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (stack.func_190926_b() || amount <= 0) continue;
            int currentAmount = Math.min(amount, stack.func_190916_E());
            if (!simulate) {
                stack.func_190918_g(currentAmount);
            }
            if ((amount -= currentAmount) == 0) break;
        }
    }
}

