/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.brewage.EnumBeerVariety;
import com.denfop.api.brewage.EnumTimeVariety;
import com.denfop.api.brewage.EnumWaterVariety;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class ItemBooze
extends Item
implements IModelRegister {
    private final String name;
    private final String path;
    public int[] baseDuration = new int[]{300, 900, 1200, 1600, 2000, 2400};
    public float[] baseIntensity = new float[]{0.4f, 0.75f, 1.0f, 1.5f, 2.0f};

    public ItemBooze(String name) {
        this.func_77637_a(IUCore.CropsTab);
        this.func_77625_d(1);
        this.name = name;
        this.path = "";
        this.func_77655_b(name);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return ModUtils.nbt(stack).func_74764_b("beer") ? EnumAction.DRINK : EnumAction.NONE;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            for (EnumWaterVariety enumWaterVariety : EnumWaterVariety.values()) {
                for (EnumTimeVariety enumTimeVariety : EnumTimeVariety.values()) {
                    for (EnumBeerVariety enumBeerVariety : EnumBeerVariety.values()) {
                        ItemStack stack = new ItemStack((Item)this);
                        NBTTagCompound nbtTagCompound = ModUtils.nbt(stack);
                        nbtTagCompound.func_74757_a("beer", true);
                        nbtTagCompound.func_74774_a("waterVariety", (byte)enumWaterVariety.ordinal());
                        nbtTagCompound.func_74774_a("timeVariety", (byte)enumTimeVariety.ordinal());
                        nbtTagCompound.func_74774_a("beerVariety", (byte)enumBeerVariety.ordinal());
                        nbtTagCompound.func_74774_a("amount", (byte)5);
                        subItems.add((Object)stack);
                    }
                }
            }
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase living) {
        NBTTagCompound nbtTagCompound = ModUtils.nbt(stack);
        if (!nbtTagCompound.func_74764_b("beer")) {
            return new ItemStack((Item)this);
        }
        EnumWaterVariety waterVariety = EnumWaterVariety.values()[nbtTagCompound.func_74771_c("waterVariety")];
        EnumTimeVariety timeVariety = EnumTimeVariety.values()[nbtTagCompound.func_74771_c("timeVariety")];
        EnumBeerVariety beerVariety = EnumBeerVariety.values()[nbtTagCompound.func_74771_c("beerVariety")];
        if (timeVariety == EnumTimeVariety.BLACK_STUFF || waterVariety == EnumWaterVariety.BLACK_STUFF || beerVariety == EnumBeerVariety.BLACKSTUFF) {
            return this.drinkBlackStuff(living);
        }
        int solidRatio = waterVariety.ordinal();
        int level = beerVariety.ordinal();
        int duration = this.baseDuration[solidRatio];
        float intensity = this.baseIntensity[timeVariety.ordinal()];
        if (living instanceof EntityPlayer) {
            ((EntityPlayer)living).func_71024_bL().func_75122_a(5 - level, (float)solidRatio * 0.15f);
        }
        int max = (int)(intensity * (float)level * 0.5f);
        PotionEffect slow = living.func_70660_b(MobEffects.field_76419_f);
        level = -1;
        if (slow != null) {
            level = slow.func_76458_c();
        }
        nbtTagCompound.func_74774_a("amount", (byte)(nbtTagCompound.func_74771_c("amount") - 1));
        this.amplifyEffect(living, MobEffects.field_76419_f, max, intensity, duration);
        if (level > -1) {
            this.amplifyEffect(living, MobEffects.field_76420_g, max, intensity, duration);
            if (level > 0) {
                this.amplifyEffect(living, MobEffects.field_76421_d, max / 2, intensity, duration);
                if (level > 1) {
                    this.amplifyEffect(living, MobEffects.field_76429_m, max - 1, intensity, duration);
                    if (level > 2) {
                        this.amplifyEffect(living, MobEffects.field_76431_k, 0, intensity, duration);
                        if (level > 3) {
                            living.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 1, living.func_130014_f_().field_73012_v.nextInt(3)));
                        }
                    }
                }
            }
        }
        return nbtTagCompound.func_74771_c("amount") > 0 ? stack : new ItemStack((Item)this);
    }

    public void amplifyEffect(EntityLivingBase living, Potion potion, int max, float intensity, int duration) {
        PotionEffect eff = living.func_70660_b(potion);
        if (eff == null) {
            living.func_70690_d(new PotionEffect(potion, duration, 0));
        } else {
            int currentDuration = eff.func_76459_b();
            int maxnewdur = (int)((float)duration * (1.0f + intensity * 2.0f) - (float)currentDuration) / 2;
            if (maxnewdur < 0) {
                maxnewdur = 0;
            }
            if (maxnewdur < duration) {
                duration = maxnewdur;
            }
            currentDuration += duration;
            int newamp = eff.func_76458_c();
            if (newamp < max) {
                ++newamp;
            }
            living.func_70690_d(new PotionEffect(potion, currentDuration, newamp));
        }
    }

    public ItemStack drinkBlackStuff(EntityLivingBase living) {
        switch (living.func_130014_f_().field_73012_v.nextInt(6)) {
            case 1: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 1200, 0));
                break;
            }
            case 2: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 2400, 0));
                break;
            }
            case 3: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 2400, 0));
                break;
            }
            case 4: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 2));
                break;
            }
            case 5: {
                living.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 1, living.func_130014_f_().field_73012_v.nextInt(4)));
            }
        }
        return new ItemStack((Item)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound nbtTagCompound = ModUtils.nbt(stack);
        if (nbtTagCompound.func_74764_b("beer")) {
            EnumWaterVariety waterVariety = EnumWaterVariety.values()[nbtTagCompound.func_74771_c("waterVariety")];
            EnumTimeVariety timeVariety = EnumTimeVariety.values()[nbtTagCompound.func_74771_c("timeVariety")];
            EnumBeerVariety beerVariety = EnumBeerVariety.values()[nbtTagCompound.func_74771_c("beerVariety")];
            tooltip.add(Localization.translate("iu.beer.recipe.info"));
            tooltip.add(Localization.translate("iu.beer.recipe"));
            tooltip.add(Localization.translate("iu.beer.recipe1") + " " + beerVariety.getRatioOfComponents().get(0).func_76340_b());
            tooltip.add(Localization.translate("iu.beer.recipe2") + " " + beerVariety.getRatioOfComponents().get(0).func_76341_a());
            tooltip.add(Localization.translate("iu.beer.recipe3") + " " + waterVariety.getAmount().get(0));
            tooltip.add(Localization.translate("iu.beer.recipe4") + " " + new Timer((int)(timeVariety.getTime() * 60.0 * 60.0)).getDisplay());
            tooltip.add(Localization.translate("iu.beer.recipe5") + " " + waterVariety.name() + " " + beerVariety.name() + " " + timeVariety.name());
        }
    }

    public String func_77658_a() {
        return super.func_77658_a() + ".name";
    }

    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbtTagCompound = ModUtils.nbt(stack);
        if (!nbtTagCompound.func_74764_b("beer")) {
            return Localization.translate(this.func_77667_c(stack).replace("item.", "iu.") + ".name");
        }
        EnumWaterVariety waterVariety = EnumWaterVariety.values()[nbtTagCompound.func_74771_c("waterVariety")];
        EnumTimeVariety timeVariety = EnumTimeVariety.values()[nbtTagCompound.func_74771_c("timeVariety")];
        EnumBeerVariety beerVariety = EnumBeerVariety.values()[nbtTagCompound.func_74771_c("beerVariety")];
        return waterVariety.name() + " " + beerVariety.name() + " " + timeVariety.name();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            boolean hasKey = nbt.func_74764_b("beer");
            if (!hasKey) {
                return new ModelResourceLocation("industrialupgrade:" + this.path + this.name, null);
            }
            EnumTimeVariety timeVariety = EnumTimeVariety.values()[nbt.func_74771_c("timeVariety")];
            return new ModelResourceLocation("industrialupgrade:" + this.path + this.name + "_" + timeVariety.name().toLowerCase(), null);
        });
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("industrialupgrade:" + this.path + this.name, null)});
        for (EnumTimeVariety timeVariety : EnumTimeVariety.values()) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("industrialupgrade:" + this.path + this.name + "_" + timeVariety.name().toLowerCase(), null)});
        }
    }
}

