/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUItem;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.ItemFluidContainer;
import com.denfop.utils.ModUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.DispenseFluidContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemFluidCell
extends ItemFluidContainer {
    public ItemFluidCell() {
        super("fluid_cell", 1000);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DispenseFluidContainer.getInstance());
    }

    public String func_77667_c(ItemStack itemStack) {
        return "iu." + super.func_77658_a().substring(5);
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:itemcell/itemcell", null));
    }

    @Override
    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityFluidHandlerItem(stack, this.capacity){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidCell.this.canfill(fluid.getFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidCell.this.canfill(fluid.getFluid()) && fluid.amount >= 1000;
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (resource == null || resource.amount < 1000) {
                    return 0;
                }
                return super.fill(resource, doFill);
            }

            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (maxDrain < 1000) {
                    return null;
                }
                return super.drain(maxDrain, doDrain);
            }

            public FluidStack drain(FluidStack resource, boolean doDrain) {
                if (resource == null || resource.amount < 1000) {
                    return null;
                }
                return super.drain(resource, doDrain);
            }

            @NotNull
            public ItemStack getContainer() {
                return this.getFluid() == null ? new ItemStack((Item)IUItem.fluidCell) : this.container;
            }
        };
    }

    public boolean tryPlaceContainedLiquid(FluidStack fs, @Nullable EntityPlayer player, World worldIn, BlockPos posIn) {
        Object containedBlock = fs.getFluid() == FluidRegistry.WATER ? Blocks.field_150358_i : (fs.getFluid() == FluidRegistry.LAVA ? Blocks.field_150356_k : fs.getFluid().getBlock());
        if (containedBlock == Blocks.field_150350_a) {
            return false;
        }
        IBlockState iblockstate = worldIn.func_180495_p(posIn);
        Material material = iblockstate.func_185904_a();
        boolean flag = !material.func_76220_a();
        boolean flag1 = iblockstate.func_177230_c().func_176200_f((IBlockAccess)worldIn, posIn);
        if (!(worldIn.func_175623_d(posIn) || flag || flag1)) {
            return false;
        }
        if (worldIn.field_73011_w.func_177500_n() && containedBlock == Blocks.field_150358_i) {
            int l = posIn.func_177958_n();
            int i = posIn.func_177956_o();
            int j = posIn.func_177952_p();
            worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!worldIn.field_72995_K && (flag || flag1) && !material.func_76224_d()) {
                worldIn.func_175655_b(posIn, true);
            }
            SoundEvent soundevent = containedBlock == Blocks.field_150356_k ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
            worldIn.func_184133_a(player, posIn, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_180501_a(posIn, containedBlock.func_176223_P(), 11);
        }
        fs.amount -= 1000;
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        RayTraceResult position = this.func_77621_a(world, player, true);
        if (position == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        boolean action = ForgeHooks.onRightClickBlock((EntityPlayer)player, (EnumHand)hand, (BlockPos)position.func_178782_a(), (EnumFacing)position.field_178784_b, (Vec3d)position.field_72307_f).isCanceled();
        if (action) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        if (position.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = position.func_178782_a();
            ItemStack stack = player.func_184586_b(hand);
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluidStack != null) {
                BlockPos blockpos1;
                boolean flag1 = world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
                BlockPos blockPos = blockpos1 = flag1 && position.field_178784_b == EnumFacing.UP ? pos : pos.func_177972_a(position.field_178784_b);
                if (fluidStack.amount >= 1000 && this.tryPlaceContainedLiquid(fluidStack, player, world, blockpos1)) {
                    player.func_184586_b(hand).func_190918_g(1);
                    if (!ModUtils.storeInventoryItem(new ItemStack((Item)IUItem.fluidCell, 1), player, false)) {
                        ModUtils.dropAsEntity(world, pos, new ItemStack((Item)IUItem.fluidCell, 1));
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                }
            } else {
                if (!world.canMineBlockBody(player, pos)) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
                }
                if (!player.func_175151_a(pos, position.field_178784_b, player.func_184586_b(hand))) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
                }
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (block instanceof IFluidBlock && ((IFluidBlock)block).canDrain(world, pos)) {
                    if (!world.field_72995_K) {
                        ItemStack stack1 = new ItemStack((Item)this);
                        IFluidHandlerItem fluidDestination = FluidUtil.getFluidHandler((ItemStack)stack1);
                        Fluid liquid = ((IFluidBlock)block).getFluid();
                        FluidStack drainable = new FluidStack(liquid, 1000);
                        fluidDestination.fill(drainable, true);
                        world.func_175698_g(pos);
                        stack.func_190918_g(1);
                        if (!player.field_71071_by.func_70441_a(stack1)) {
                            ModUtils.dropAsEntity(world, pos, stack1);
                        }
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                }
                if (state.func_185904_a().func_76224_d()) {
                    if (!world.field_72995_K) {
                        FluidStack drainable = new FluidStack(FluidRegistry.getFluid((String)block.func_149739_a().substring(5)), 1000);
                        ItemStack stack1 = new ItemStack((Item)this);
                        IFluidHandlerItem fluidDestination = FluidUtil.getFluidHandler((ItemStack)stack1);
                        fluidDestination.fill(drainable, true);
                        world.func_175698_g(pos);
                        stack.func_190918_g(1);
                        if (!player.field_71071_by.func_70441_a(stack1)) {
                            ModUtils.dropAsEntity(world, pos, stack1);
                        }
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            ItemStack emptyStack = new ItemStack((Item)this);
            subItems.add((Object)emptyStack);
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                ItemStack stack;
                if (fluid == null || fluid.getBlock() == null || (stack = this.getItemStack(fluid)) == null) continue;
                subItems.add((Object)stack);
            }
        }
    }
}

