/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.FluidName;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.block.ISubItem;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public abstract class ItemFluidContainer
extends Item
implements ISubItem<FluidName>,
IModelRegister {
    protected final int capacity;

    public ItemFluidContainer(String name, int capacity) {
        this.capacity = capacity;
        this.func_77627_a(true);
        this.func_77637_a(IUCore.ItemTab);
        this.func_77655_b(name);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new CapabilityFluidHandlerItem(stack, this.capacity){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidContainer.this.canfill(fluid.getFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return fluid != null && ItemFluidContainer.this.canfill(fluid.getFluid()) && ItemFluidContainer.this.canDrain(fluid);
            }
        };
    }

    public boolean canDrain(FluidStack fluid) {
        return true;
    }

    @Override
    public ItemStack getItemStack(FluidName type) {
        return this.getItemStack(type.getInstance());
    }

    @Override
    public ItemStack getItemStack(Fluid fluid) {
        ItemStack ret = new ItemStack((Item)this);
        if (fluid == null) {
            return ret;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
        if (handler == null) {
            return null;
        }
        return handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), true) > 0 ? handler.getContainer() : null;
    }

    public ItemStack getItemStack(ItemStack ret, Fluid fluid) {
        if (fluid == null) {
            return ret;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
        if (handler == null) {
            return null;
        }
        return handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), true) > 0 ? handler.getContainer() : null;
    }

    @Override
    public ItemStack getItemStack(String variant) {
        if (variant != null && !variant.isEmpty()) {
            Fluid fluid = FluidRegistry.getFluid((String)variant);
            return fluid == null ? null : this.getItemStack(fluid);
        }
        return new ItemStack((Item)this);
    }

    public String getVariant(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null stack");
        }
        if (stack.func_77973_b() != this) {
            throw new IllegalArgumentException("The stack " + stack + " doesn't match " + this);
        }
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        return fs != null && fs.getFluid() != null ? fs.getFluid().getName() : null;
    }

    public Set<FluidName> getAllTypes() {
        return EnumSet.allOf(FluidName.class);
    }

    public Set<ItemStack> getAllStacks() {
        HashSet<ItemStack> ret = new HashSet<ItemStack>();
        ret.add(new ItemStack((Item)this));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ItemStack add = this.getItemStack(fluid);
            if (add == null) continue;
            ret.add(add);
        }
        return ret;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (!this.hasContainerItem(stack)) {
            return super.getContainerItem(stack);
        }
        ItemStack ret = ModUtils.setSize(stack, 1);
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)ret);
        handler.drain(Integer.MAX_VALUE, true);
        return handler.getContainer();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)stack);
        if (fs != null) {
            tooltip.add("< " + fs.getLocalizedName() + ", " + fs.amount + " mB >");
        } else {
            tooltip.add(Localization.translate("iu.item.FluidContainer.Empty"));
        }
    }

    public abstract boolean canfill(Fluid var1);
}

