/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.register.Register;
import com.denfop.tiles.bee.FrameAttributeLevel;
import com.denfop.tiles.bee.IFrameItem;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class ItemFrame
extends ItemSubTypes<Types>
implements IModelRegister,
IFrameItem {
    protected static final String NAME = "frame";

    public ItemFrame() {
        super(Types.class);
        this.func_77637_a(IUCore.ItemTab);
        this.func_77625_d(1);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(Localization.translate("iu.reactoritem.durability") + " " + (this.getMaxCustomDamage(stack) - this.getCustomDamage(stack)) + "/" + this.getMaxCustomDamage(stack));
    }

    public String func_77658_a() {
        return "iu." + super.func_77658_a().substring(3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:frame/" + Types.getFromID(meta).func_176610_l(), null));
    }

    @Override
    public FrameAttributeLevel getAttribute(int meta) {
        return FrameAttributeLevel.values()[meta];
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        assert (stack.func_77978_p() != null);
        return stack.func_77978_p().func_74762_e("damage");
    }

    @Override
    public int getMaxCustomDamage(ItemStack var1) {
        return 72000;
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (damage > this.getMaxCustomDamage(stack)) {
            damage = this.getMaxCustomDamage(stack);
        }
        nbt.func_74768_a("damage", damage);
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        int damage1 = this.getCustomDamage(stack) - damage;
        if (damage1 <= 0) {
            damage1 = 0;
        }
        this.setCustomDamage(stack, damage1);
        return this.getMaxCustomDamage(stack) - damage1 == 0;
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return (double)this.getCustomDamage(stack) / (double)this.getMaxCustomDamage(stack);
    }

    public static enum Types implements ISubEnum
    {
        slow_aging_1,
        slow_aging_2,
        slow_aging_3,
        producing_1,
        producing_2,
        producing_3,
        speed_crop_1,
        speed_crop_2,
        speed_crop_3,
        speed_birth_rate_1,
        speed_birth_rate_2,
        speed_birth_rate_3,
        chance_crossing_1,
        chance_crossing_2,
        chance_crossing_3,
        storage_jelly_1,
        storage_jelly_2,
        storage_jelly_3,
        storage_food_1,
        storage_food_2,
        storage_food_3,
        chance_healing_1,
        chance_healing_2,
        chance_healing_3;

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        private Types() {
            this.ID = this.ordinal();
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

