/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.register.Register;
import com.denfop.tiles.base.TileEntityTeleporter;
import com.denfop.utils.ModUtils;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemFrequencyTransmitter
extends Item
implements IModelRegister {
    private final String name;

    public ItemFrequencyTransmitter() {
        this.func_77625_d(1);
        this.name = "frequency_transmitter";
        this.func_77637_a(IUCore.ItemTab);
        IUCore.proxy.addIModelRegister(this);
        Register.registerItem(this, IUCore.getIdentifier(this.name)).func_77655_b(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:tools/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemFrequencyTransmitter.getModelLocation(name));
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (IUCore.proxy.isSimulating()) {
            NBTTagCompound nbtData = ModUtils.nbt(stack);
            boolean hadJustSet = nbtData.func_74767_n("targetJustSet");
            if (nbtData.func_74767_n("targetSet") && !hadJustSet) {
                nbtData.func_74757_a("targetSet", false);
                IUCore.proxy.messagePlayer(player, "Frequency Transmitter unlinked", new Object[0]);
            }
            if (hadJustSet) {
                nbtData.func_74757_a("targetJustSet", false);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @NotNull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityTeleporter)) {
            return EnumActionResult.PASS;
        }
        TileEntityTeleporter tp = (TileEntityTeleporter)te;
        NBTTagCompound nbtData = ModUtils.nbt(ModUtils.get(player, hand));
        boolean targetSet = nbtData.func_74767_n("targetSet");
        boolean justSetTarget = true;
        BlockPos target = new BlockPos(nbtData.func_74762_e("targetX"), nbtData.func_74762_e("targetY"), nbtData.func_74762_e("targetZ"));
        if (!targetSet) {
            targetSet = true;
            target = tp.func_174877_v();
            IUCore.proxy.messagePlayer(player, "Frequency Transmitter linked to Teleporter.", new Object[0]);
        } else if (tp.func_174877_v().equals((Object)target)) {
            IUCore.proxy.messagePlayer(player, "Can't link Teleporter to itself.", new Object[0]);
        } else if (tp.hasTarget() && tp.getTarget().equals((Object)target)) {
            IUCore.proxy.messagePlayer(player, "Teleportation link unchanged.", new Object[0]);
        } else {
            TileEntity targetTe = world.func_175625_s(target);
            if (targetTe instanceof TileEntityTeleporter) {
                tp.setTarget(target);
                ((TileEntityTeleporter)targetTe).setTarget(pos);
                IUCore.proxy.messagePlayer(player, "Teleportation link established.", new Object[0]);
            } else {
                justSetTarget = false;
                targetSet = false;
            }
        }
        nbtData.func_74757_a("targetSet", targetSet);
        nbtData.func_74757_a("targetJustSet", justSetTarget);
        nbtData.func_74768_a("targetX", target.func_177958_n());
        nbtData.func_74768_a("targetY", target.func_177956_o());
        nbtData.func_74768_a("targetZ", target.func_177952_p());
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        if (nbtData.func_74767_n("targetSet")) {
            tooltip.add(Localization.translate("frequency_transmitter.tooltip.target", nbtData.func_74762_e("targetX"), nbtData.func_74762_e("targetY"), nbtData.func_74762_e("targetZ")));
        } else {
            tooltip.add(Localization.translate("frequency_transmitter.tooltip.blank"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name, String extraName) {
        ItemFrequencyTransmitter.registerModel(this, meta, name);
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }
}

