/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.FluidName;
import com.denfop.register.Register;
import com.denfop.world.GenData;
import com.denfop.world.WorldGenGas;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGasSensor
extends Item
implements IModelRegister {
    private final String name;

    public ItemGasSensor() {
        this.func_77625_d(1);
        this.canRepair = false;
        this.name = "gas_sensor";
        this.func_77637_a(IUCore.ItemTab);
        Register.registerItem(this, IUCore.getIdentifier(this.name)).func_77655_b(this.name);
        IUCore.proxy.addIModelRegister(this);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:tools/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemGasSensor.getModelLocation(name));
    }

    public String func_77667_c(ItemStack stack) {
        return "iu." + super.func_77658_a().substring(5);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand p_77659_3_) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(p_77659_3_));
        }
        ChunkPos chunkPos = new ChunkPos((int)player.field_70165_t >> 4, (int)player.field_70161_v >> 4);
        boolean empty = true;
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                ChunkPos chunkPos1 = new ChunkPos(chunkPos.field_77276_a + i, chunkPos.field_77275_b + j);
                GenData typeGas = WorldGenGas.gasMap.get(chunkPos1);
                if (typeGas == null) continue;
                empty = false;
                String text = "";
                switch (typeGas.getTypeGas()) {
                    case GAS: {
                        text = I18n.func_74838_a((String)FluidName.fluidgas.getInstance().getUnlocalizedName());
                        break;
                    }
                    case IODINE: {
                        text = I18n.func_74838_a((String)FluidName.fluidiodine.getInstance().getUnlocalizedName());
                        break;
                    }
                    case BROMIDE: {
                        text = I18n.func_74838_a((String)FluidName.fluidbromine.getInstance().getUnlocalizedName());
                        break;
                    }
                    case CHLORINE: {
                        text = I18n.func_74838_a((String)FluidName.fluidchlorum.getInstance().getUnlocalizedName());
                        break;
                    }
                    case FLUORINE: {
                        text = I18n.func_74838_a((String)FluidName.fluidfluor.getInstance().getUnlocalizedName());
                    }
                }
                if (typeGas.getX() == 0 && typeGas.getZ() == 0) {
                    IUCore.proxy.messagePlayer(player, "X: " + (chunkPos1.func_180334_c() + 16) + ", Y:" + typeGas.getY() + ", Z: " + (chunkPos1.func_180333_d() + 16) + " " + text, new Object[0]);
                    continue;
                }
                IUCore.proxy.messagePlayer(player, "X: " + typeGas.getX() + ", Y: " + typeGas.getY() + ", Z: " + typeGas.getZ() + " --> " + text, new Object[0]);
            }
        }
        if (empty) {
            IUCore.proxy.messagePlayer(player, Localization.translate("iu.empty"), new Object[0]);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(p_77659_3_));
    }

    @Override
    public void registerModels() {
        ItemGasSensor.registerModel(this, 0, this.name);
    }
}

