/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.pollution.ChunkLevel;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.pollution.PollutionManager;
import com.denfop.register.Register;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemPollutionDevice
extends Item
implements IModelRegister {
    private final String name;

    public ItemPollutionDevice() {
        this.func_77625_d(1);
        this.canRepair = false;
        this.name = "pollution_device";
        this.func_77637_a(IUCore.EnergyTab);
        Register.registerItem(this, IUCore.getIdentifier(this.name)).func_77655_b(this.name);
        IUCore.proxy.addIModelRegister(this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            ChunkPos playerChunk = new ChunkPos(player.func_180425_c());
            ChunkLevel airChunkLevel = PollutionManager.pollutionManager.getChunkLevelAir(playerChunk);
            ChunkLevel soilChunkLevel = PollutionManager.pollutionManager.getChunkLevelSoil(playerChunk);
            if (airChunkLevel != null) {
                this.sendPollutionMessage(player, airChunkLevel.getLevelPollution(), "message.pollution.air");
            }
            if (soilChunkLevel != null) {
                this.sendPollutionMessage(player, soilChunkLevel.getLevelPollution(), "message.pollution.soil");
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    private void sendPollutionMessage(EntityPlayer player, LevelPollution level, String messageKey) {
        switch (level) {
            case LOW: 
            case VERY_LOW: 
            case MEDIUM: 
            case HIGH: 
            case VERY_HIGH: {
                IUCore.proxy.messagePlayer(player, Localization.translate(messageKey + "." + level.name().toLowerCase()), new Object[0]);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("item.", "iu."));
    }

    public String getItemStackDisplayName() {
        return I18n.func_74838_a((String)this.func_77658_a().replace("item.", "iu."));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, @NotNull ITooltipFlag advanced) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:" + this.name, null));
    }
}

