/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.IUCore;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IVolcanoArmor;
import com.denfop.items.armour.ItemArmorUtility;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorVolcanoHazmat
extends ItemArmorUtility
implements IVolcanoArmor,
IModelRegister {
    public ItemArmorVolcanoHazmat(String name, EntityEquipmentSlot type) {
        super(name, type);
        this.func_77656_e(64);
        if (this.field_77881_a == EntityEquipmentSlot.FEET) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        this.armorName = name;
        this.func_77655_b(this.armorName);
        this.func_77637_a(IUCore.EnergyTab);
        Register.registerItem(this, IUCore.getIdentifier(this.armorName)).func_77655_b(this.armorName);
        IUCore.proxy.addIModelRegister(this);
    }

    public static boolean hasCompleteHazmat(EntityLivingBase living) {
        ItemStack stack;
        EntityEquipmentSlot slot2;
        IVolcanoArmor hazmat;
        Iterator var1 = Arrays.stream(EntityEquipmentSlot.values()).filter(slot -> slot != EntityEquipmentSlot.MAINHAND && slot != EntityEquipmentSlot.OFFHAND).iterator();
        do {
            if (!var1.hasNext()) {
                return true;
            }
            slot2 = (EntityEquipmentSlot)var1.next();
            stack = living.func_184582_a(slot2);
            if (!(stack.func_77973_b() instanceof IVolcanoArmor)) {
                return false;
            }
            hazmat = (IVolcanoArmor)stack.func_77973_b();
            if (hazmat.addsProtection(living, slot2, stack)) continue;
            return false;
        } while (!hazmat.fullyProtects(living, slot2, stack));
        return true;
    }

    public static boolean hazmatAbsorbs(DamageSource source) {
        return source == DamageSource.field_76372_a || source == DamageSource.field_76368_d || source == DamageSource.field_76371_c || source == DamageSource.field_190095_e || source == DamageSource.field_76370_b;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.armorName);
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        int suffix1 = this.field_77881_a == EntityEquipmentSlot.LEGS ? 2 : 1;
        return "industrialupgrade:textures/armor/volcano_hazmat_" + suffix1 + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            String mode = nbt.func_74779_i("mode");
            if (nbt.func_74779_i("mode").equals("")) {
                return ItemArmorVolcanoHazmat.getModelLocation1(name, "");
            }
            return ItemArmorVolcanoHazmat.getModelLocation1("armor", "_" + this.field_77881_a.ordinal() + "_" + mode);
        });
        for (String s : mode = new String[]{""}) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemArmorVolcanoHazmat.getModelLocation1(name, s)});
        }
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.field_77881_a == EntityEquipmentSlot.HEAD && ItemArmorVolcanoHazmat.hazmatAbsorbs(source) && ItemArmorVolcanoHazmat.hasCompleteHazmat(player)) {
            if (source == DamageSource.field_76372_a || source == DamageSource.field_76371_c || source == DamageSource.field_190095_e) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 60, 1));
            }
            return new ISpecialArmor.ArmorProperties(10, 1.0, Integer.MAX_VALUE);
        }
        return this.field_77881_a == EntityEquipmentSlot.FEET && source == DamageSource.field_76379_h ? new ISpecialArmor.ArmorProperties(10, damage < 8.0 ? 1.0 : 0.875, (armor.func_77958_k() - armor.func_77952_i() + 2) * 2 * 25) : new ISpecialArmor.ArmorProperties(0, 0.05, (armor.func_77958_k() - armor.func_77952_i() + 2) / 2 * 25);
    }

    @Override
    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!ItemArmorVolcanoHazmat.hazmatAbsorbs(source) || !ItemArmorVolcanoHazmat.hasCompleteHazmat(entity)) {
            int damageTotal = damage * 2;
            if (this.field_77881_a == EntityEquipmentSlot.FEET && source == DamageSource.field_76379_h) {
                damageTotal = (damage + 1) / 2;
            }
            stack.func_77972_a(damageTotal, entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityLivingFallEvent(LivingFallEvent event) {
        if (IUCore.proxy.isSimulating() && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            ItemStack armor = (ItemStack)player.field_71071_by.field_70460_b.get(0);
            if (armor.func_77973_b() == this) {
                int fallDamage = (int)event.getDistance() - 3;
                if (fallDamage >= 8) {
                    return;
                }
                int armorDamage = (fallDamage + 1) / 2;
                if (armorDamage <= armor.func_77958_k() - armor.func_77952_i() && armorDamage >= 0) {
                    armor.func_77972_a(armorDamage, (EntityLivingBase)player);
                    event.setCanceled(true);
                }
            }
        }
    }

    public boolean isRepairable() {
        return true;
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 1;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && this.field_77881_a == EntityEquipmentSlot.HEAD && player.func_70027_ad() && ItemArmorVolcanoHazmat.hasCompleteHazmat((EntityLivingBase)player)) {
            if (this.isInLava(player)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 20, 0, true, true));
            }
            player.func_70066_B();
        }
    }

    public boolean isInLava(EntityPlayer player) {
        int x = (int)Math.floor(player.field_70165_t);
        int y = (int)Math.floor(player.field_70163_u + 0.02);
        int z = (int)Math.floor(player.field_70161_v);
        IBlockState state = player.func_130014_f_().func_180495_p(new BlockPos(x, y, z));
        if (state.func_177230_c() instanceof BlockLiquid && (state.func_185904_a() == Material.field_151587_i || state.func_185904_a() == Material.field_151581_o)) {
            float height = (float)(y + 1) - BlockLiquid.func_149801_b((int)((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b)));
            return player.field_70163_u < (double)height;
        }
        return false;
    }

    @Override
    public boolean addsProtection(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return false;
    }
}

