/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.armour.ItemArmorEnergy;
import com.denfop.proxy.CommonProxy;
import com.denfop.register.Register;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemLappack
extends ItemArmorEnergy
implements IEnergyItem,
IModelRegister,
ISpecialArmor,
IUpgradeItem {
    private final double maxCharge;
    private final double transferLimit;
    private final int tier;
    private final String name;

    public ItemLappack(String name, double MaxCharge, int Tier, double TransferLimit) {
        super("", EntityEquipmentSlot.CHEST, MaxCharge, TransferLimit, Tier);
        this.maxCharge = MaxCharge;
        this.transferLimit = TransferLimit;
        this.func_77637_a(IUCore.EnergyTab);
        this.func_77655_b(name);
        this.func_77656_e(0);
        this.name = name;
        this.tier = Tier;
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
        UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.LAPPACK.list);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name, String extraName) {
        String loc = "industrialupgrade:armour/" + name + extraName;
        return new ModelResourceLocation(loc, null);
    }

    public static int readToolMode(ItemStack itemstack) {
        NBTTagCompound nbttagcompound = ModUtils.nbt(itemstack);
        int toolMode = nbttagcompound.func_74762_e("toolMode");
        if (toolMode < 0 || toolMode > 1) {
            toolMode = 0;
        }
        return toolMode;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.LAPPACK.list;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (!UpgradeSystem.system.hasInMap(stack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(worldIn, this, stack));
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int prev = this.getDamage(stack);
    }

    @Override
    public String func_77658_a() {
        return "item." + super.func_77658_a().substring(3) + ".name";
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.4;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            return ItemLappack.getModelLocation1(name, nbt.func_74779_i("mode"));
        });
        for (String s : mode = new String[]{"", "Demon", "Dark", "Cold", "Ender"}) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemLappack.getModelLocation1(name, s)});
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        if (!nbtData.func_74779_i("mode").isEmpty()) {
            return "industrialupgrade:textures/armor/" + this.name + "_" + nbtData.func_74779_i("mode") + ".png";
        }
        return "industrialupgrade:textures/armor/" + this.name + ".png";
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / ((double)energyPerDamage - (double)(energyPerDamage * protect) * 0.2) : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    @Override
    public int getEnergyPerDamage() {
        return (int)(this.getMaxEnergy(null) * 0.05);
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public int func_77619_b() {
        return 0;
    }

    @Override
    public void func_150895_a(CreativeTabs p_150895_1_, NonNullList<ItemStack> var3) {
        if (this.func_194125_a(p_150895_1_)) {
            ItemStack var4 = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            var3.add((Object)var4);
            var3.add((Object)new ItemStack((Item)this, 1));
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void saveToolMode(ItemStack itemstack, Integer toolMode) {
        NBTTagCompound nbttagcompound = ModUtils.nbt(itemstack);
        nbttagcompound.func_74768_a("toolMode", toolMode.intValue());
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            int toolMode = ItemLappack.readToolMode(itemStack);
            if (++toolMode > 1) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                CommonProxy.sendPlayerMessage(player, TextFormatting.GOLD + Localization.translate("iu.message.text.powerSupply") + " " + TextFormatting.RED + Localization.translate("iu.message.text.disabled"));
            }
            if (toolMode == 1) {
                CommonProxy.sendPlayerMessage(player, TextFormatting.GOLD + Localization.translate("iu.message.text.powerSupply") + " " + TextFormatting.GREEN + Localization.translate("iu.message.text.enabled"));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public void func_77624_a(@Nonnull ItemStack par1ItemStack, @Nullable World p_77624_2_, @Nonnull List<String> par3List, @Nonnull ITooltipFlag p_77624_4_) {
        int toolMode = ItemLappack.readToolMode(par1ItemStack);
        if (toolMode == 0) {
            par3List.add(TextFormatting.GOLD + Localization.translate("iu.message.text.powerSupply") + ": " + TextFormatting.RED + Localization.translate("iu.message.text.disabled"));
        }
        if (toolMode == 1) {
            par3List.add(TextFormatting.GOLD + Localization.translate("iu.message.text.powerSupply") + ": " + TextFormatting.GREEN + Localization.translate("iu.message.text.enabled"));
        }
        if (!Keyboard.isKeyDown((int)42)) {
            par3List.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            par3List.add(Localization.translate("iu.changemode_key") + Keyboard.getKeyName((int)KeyboardClient.changemode.func_151463_i()) + " + " + Localization.translate("iu.changemode_rcm1"));
        }
    }

    public void onArmorTick(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull ItemStack itemStack) {
        int toolMode;
        NBTTagCompound nbtData = ModUtils.nbt(itemStack);
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (IUCore.keyboard.isChangeKeyDown(player) && toggleTimer == 0) {
            toggleTimer = 10;
            toolMode = ItemLappack.readToolMode(itemStack);
            if (++toolMode > 1) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            if (toolMode == 0) {
                CommonProxy.sendPlayerMessage(player, TextFormatting.GOLD + Localization.translate("iu.message.text.powerSupply") + " " + TextFormatting.RED + Localization.translate("iu.message.text.disabled"));
            }
            if (toolMode == 1) {
                CommonProxy.sendPlayerMessage(player, TextFormatting.GOLD + Localization.translate("iu.message.text.powerSupply") + " " + TextFormatting.GREEN + Localization.translate("iu.message.text.enabled"));
            }
        }
        if (IUCore.proxy.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        toolMode = ItemLappack.readToolMode(itemStack);
        boolean ret = false;
        double energy3 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.LAPPACK_ENERGY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.LAPPACK_ENERGY, (ItemStack)itemStack).number : 0;
        if (energy3 != 0.0) {
            energy3 *= 0.005;
        }
        if (toolMode == 1) {
            int resistance;
            double sentPacket;
            for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                if (((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() || !(((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b() instanceof IEnergyItem) || !(ElectricItem.manager.getCharge(itemStack) > 0.0) || itemStack.func_77969_a((ItemStack)player.field_71071_by.field_70460_b.get(i)) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.field_71071_by.field_70460_b.get(i), ElectricItem.manager.getCharge(itemStack), Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                ElectricItem.manager.discharge(itemStack, sentPacket, Integer.MAX_VALUE, true, false, false);
                ElectricItem.manager.charge(itemStack, sentPacket * energy3, Integer.MAX_VALUE, true, false);
                ret = true;
            }
            for (int j = 0; j < player.field_71071_by.field_70462_a.size(); ++j) {
                if (((ItemStack)player.field_71071_by.field_70462_a.get(j)).func_190926_b() || !(((ItemStack)player.field_71071_by.field_70462_a.get(j)).func_77973_b() instanceof IEnergyItem) || !(ElectricItem.manager.getCharge(itemStack) > 0.0) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.field_71071_by.field_70462_a.get(j), ElectricItem.manager.getCharge(itemStack), Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                ElectricItem.manager.discharge(itemStack, sentPacket, Integer.MAX_VALUE, true, false, false);
                ElectricItem.manager.charge(itemStack, sentPacket * energy3, Integer.MAX_VALUE, true, false);
                ret = true;
            }
            boolean fireResistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FIRE_PROTECTION, itemStack);
            if (fireResistance) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 300));
            }
            int n = resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
            if (resistance != 0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, resistance));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 300));
            }
            if (ret) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }
}

