/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.Config;
import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUPotion;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.armour.ItemArmorEnergy;
import com.denfop.register.Register;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemSolarPanelHelmet
extends ItemArmorEnergy
implements IEnergyItem,
IModelRegister,
ISpecialArmor,
IUpgradeItem {
    protected static final Map<Potion, Integer> potionRemovalCost = new HashMap<Potion, Integer>();
    private final int solarType;
    private final String name;
    private double maxCharge;
    private double transferLimit;
    private int tier;
    private double genDay;
    private double genNight;
    private int energyPerDamage;
    private double damageAbsorptionRatio;
    private boolean sunIsUp;
    private boolean skyIsVisible;
    private boolean ret = false;
    private double storage;
    private double maxStorage;

    public ItemSolarPanelHelmet(int type, String name) {
        super("", EntityEquipmentSlot.HEAD, type == 1 ? 1000000.0 : (type == 2 ? 1.0E7 : (type == 3 ? 10000.0 : (double)Config.Storagequantumsuit)), type == 1 ? 3000.0 : (type == 2 ? 10000.0 : (type == 3 ? 10000.0 : 38000.0)), type == 1 ? 1 : (type == 2 ? 2 : (type == 3 ? 3 : (type == 4 ? 5 : 7))));
        this.solarType = type;
        this.name = name;
        this.transferLimit = 3000.0;
        this.tier = 1;
        if (this.solarType == 1) {
            this.genDay = Config.advGenDay;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1000000.0;
            this.energyPerDamage = 800;
            this.damageAbsorptionRatio = 0.9;
            this.storage = 0.0;
            this.maxStorage = Config.advStorage / 2.0;
        }
        if (this.solarType == 2) {
            this.genDay = Config.hGenDay;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 2;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = Config.hStorage / 2.0;
        }
        if (this.solarType == 3) {
            this.genDay = Config.uhGenDay;
            this.genNight = this.genDay / 2.0;
            this.maxCharge = 1.0E7;
            this.transferLimit = 10000.0;
            this.tier = 3;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = Config.uhStorage / 2.0;
        }
        if (this.solarType == 4) {
            this.genDay = Config.spectralpanelGenDay;
            this.genNight = this.genDay / 2.0;
            this.transferLimit = 38000.0;
            this.maxCharge = Config.Storagequantumsuit;
            this.tier = 5;
            this.energyPerDamage = 800;
            this.damageAbsorptionRatio = 0.9;
            this.storage = 0.0;
            this.maxStorage = Config.spectralpanelstorage / 2.0;
        }
        if (this.solarType == 5) {
            this.genDay = Config.singularpanelGenDay;
            this.genNight = this.genDay / 2.0;
            this.transferLimit = 100000.0;
            this.maxCharge = Config.Storagequantumsuit;
            this.tier = 7;
            this.energyPerDamage = 2000;
            this.damageAbsorptionRatio = 1.0;
            this.storage = 0.0;
            this.maxStorage = Config.singularpanelstorage / 2.0;
        }
        this.func_77637_a(IUCore.EnergyTab);
        potionRemovalCost.put(MobEffects.field_76436_u, 100);
        potionRemovalCost.put(IUPotion.radiation, 20);
        potionRemovalCost.put(MobEffects.field_82731_v, 100);
        potionRemovalCost.put(MobEffects.field_76438_s, 200);
        this.func_77656_e(0);
        this.func_77655_b(name);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
        UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SOLAR_HELMET.list);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name, String extraName) {
        String loc = "industrialupgrade:armour/" + name + extraName;
        return new ModelResourceLocation(loc, null);
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.SOLAR_HELMET.list;
    }

    public void setDamage(ItemStack stack, int damage) {
        int prev = this.getDamage(stack);
    }

    @Override
    public String func_77658_a() {
        return "item." + super.func_77658_a().substring(3) + ".name";
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            return ItemSolarPanelHelmet.getModelLocation1(name, nbt.func_74779_i("mode").equals("") ? "" : "_" + nbt.func_74779_i("mode"));
        });
        for (String s : mode = new String[]{"", "_Zelen", "_Demon", "_Dark", "_Cold", "_Ender", "_Ukraine", "_Fire", "_Snow", "_Taiga", "_Desert", "_Emerald"}) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemSolarPanelHelmet.getModelLocation1(name, s)});
        }
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        if (!nbtData.func_74779_i("mode").isEmpty()) {
            return "industrialupgrade:textures/armor/" + this.name + "_" + nbtData.func_74779_i("mode") + ".png";
        }
        return "industrialupgrade:textures/armor/" + this.name + ".png";
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private double experimental_generating(World world) {
        double k = 0.0;
        float angle = world.func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
        float celestialAngle = (world.func_72826_c(1.0f) + angle) * 360.0f;
        celestialAngle %= 360.0f;
        if ((celestialAngle += 12.0f) <= 90.0f) {
            k = celestialAngle / 90.0f;
        } else if (celestialAngle > 90.0f && celestialAngle < 180.0f) {
            k = 1.0f - (celestialAngle -= 90.0f) / 90.0f;
        } else if (celestialAngle > 180.0f && celestialAngle < 270.0f) {
            k = (celestialAngle -= 180.0f) / 90.0f;
        } else if (celestialAngle > 270.0f && celestialAngle < 360.0f) {
            k = 1.0f - (celestialAngle -= 270.0f) / 90.0f;
        }
        return k;
    }

    public void onArmorTick(World worldObj, @Nonnull EntityPlayer player, @Nonnull ItemStack itemStack) {
        int repaired;
        if (worldObj.field_72995_K) {
            return;
        }
        this.gainFuel(player);
        NBTTagCompound nbtData = ModUtils.nbt(itemStack);
        int resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
        int n = repaired = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.REPAIRED, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.REPAIRED, (ItemStack)itemStack).number : 0;
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 300));
        }
        boolean NightvisioModule = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack);
        boolean Nightvision = nbtData.func_74767_n("Nightvision");
        byte toggleTimer = nbtData.func_74771_c("toggleTimer");
        if (IUCore.keyboard.isArmorKey(player) && toggleTimer == 0) {
            toggleTimer = 10;
            boolean bl = Nightvision = !Nightvision;
            if (IUCore.proxy.isSimulating()) {
                nbtData.func_74757_a("Nightvision", Nightvision);
                if (Nightvision) {
                    IUCore.proxy.messagePlayer(player, "Nightvision enabled.", new Object[0]);
                } else {
                    IUCore.proxy.messagePlayer(player, "Nightvision disabled.", new Object[0]);
                }
            }
        }
        if (IUCore.proxy.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbtData.func_74774_a("toggleTimer", toggleTimer);
        }
        if (!NightvisioModule) {
            if (Nightvision && IUCore.proxy.isSimulating() && ElectricItem.manager.use(itemStack, 1.0, (EntityLivingBase)player)) {
                boolean without;
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                int y = MathHelper.func_76128_c((double)player.field_70163_u);
                int skylight = player.func_130014_f_().func_175671_l(new BlockPos(x, y, z));
                boolean with = this.solarType == 1;
                boolean bl = without = this.solarType == 2 || this.solarType == 3;
                if (without || with) {
                    if (skylight > 8) {
                        IUCore.proxy.removePotion((EntityLivingBase)player, MobEffects.field_76439_r);
                        if (with) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 100, 0, true, true));
                        }
                    } else {
                        if (with) {
                            IUCore.proxy.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
                        }
                        player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0));
                    }
                } else {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0));
                }
                this.ret = true;
            }
        } else {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300, 0));
        }
        if (repaired != 0 && worldObj.field_73011_w.getWorldTime() % 80L == 0L) {
            ElectricItem.manager.charge(itemStack, this.getMaxEnergy(itemStack) * 1.0E-5 * (double)repaired, Integer.MAX_VALUE, true, false);
        }
        if (resistance != 0) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300, resistance));
        }
        int genday = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENDAY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.GENDAY, (ItemStack)itemStack).number : 0;
        int gennight = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENNIGHT, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.GENNIGHT, (ItemStack)itemStack).number : 0;
        int storage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.STORAGE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.STORAGE, (ItemStack)itemStack).number : 0;
        double k = this.experimental_generating(worldObj);
        if (this.sunIsUp && this.skyIsVisible) {
            this.storage = nbtData.func_74769_h("storage");
            this.storage += (this.genDay + this.genDay * 0.05 * (double)genday) * k;
            nbtData.func_74780_a("storage", this.storage);
        }
        if (this.skyIsVisible) {
            this.storage = nbtData.func_74769_h("storage");
            this.storage += (this.genNight + this.genNight * 0.05 * (double)gennight) * k;
            nbtData.func_74780_a("storage", this.storage);
        }
        if (nbtData.func_74769_h("storage") >= this.maxStorage + this.maxStorage * 0.05 * (double)storage) {
            nbtData.func_74780_a("storage", this.maxStorage + this.maxStorage * 0.05 * (double)storage);
        }
        if (nbtData.func_74769_h("storage") < 0.0) {
            nbtData.func_74780_a("storage", 0.0);
        }
        for (PotionEffect effect : new LinkedList(player.func_70651_bq())) {
            Integer cost = potionRemovalCost.get(effect.func_188419_a());
            if (cost == null || !ElectricItem.manager.canUse(itemStack, (cost = Integer.valueOf(cost * (effect.func_76458_c() + 1))).intValue())) continue;
            ElectricItem.manager.use(itemStack, cost.intValue(), null);
            IUCore.proxy.removePotion((EntityLivingBase)player, effect.func_188419_a());
            this.ret = true;
        }
        double tempstorage = nbtData.func_74769_h("storage");
        if (tempstorage > 0.0) {
            double sentPacket;
            double energyLeft = tempstorage;
            for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                if (energyLeft > 0.0) {
                    if (((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() || !(((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b() instanceof IEnergyItem) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.field_71071_by.field_70460_b.get(i), energyLeft, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                    nbtData.func_74780_a("storage", energyLeft -= sentPacket);
                    this.ret = true;
                    continue;
                }
                return;
            }
            for (int j = 0; j < player.field_71071_by.field_70462_a.size(); ++j) {
                if (energyLeft > 0.0) {
                    if (((ItemStack)player.field_71071_by.field_70462_a.get(j)).func_190926_b() || !(((ItemStack)player.field_71071_by.field_70462_a.get(j)).func_77973_b() instanceof IEnergyItem) || !((sentPacket = ElectricItem.manager.charge((ItemStack)player.field_71071_by.field_70462_a.get(j), energyLeft, Integer.MAX_VALUE, true, false)) > 0.0)) continue;
                    nbtData.func_74780_a("storage", energyLeft -= sentPacket);
                    this.ret = true;
                    continue;
                }
                return;
            }
        }
        if (this.ret) {
            player.field_71070_bA.func_75142_b();
        }
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.NIGTHVISION, itemStack)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 300));
        }
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WATER, itemStack)) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76427_o, 300));
        }
    }

    public void gainFuel(EntityPlayer player) {
        if (player.func_130014_f_().field_73011_w.getWorldTime() % 128L == 0L) {
            this.updateVisibility(player);
        }
    }

    public List<String> getHudInfo(ItemStack stack, boolean advanced) {
        ArrayList<String> info = new ArrayList<String>();
        info.add(ElectricItem.manager.getToolTip(stack));
        return info;
    }

    public void updateVisibility(EntityPlayer player) {
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        boolean wetBiome = player.field_70170_p.func_180494_b(pos).func_76727_i() > 0.0f;
        boolean noSunWorld = player.field_70170_p.field_73011_w.func_177495_o();
        boolean rainWeather = wetBiome && (player.field_70170_p.func_72896_J() || player.field_70170_p.func_72911_I());
        this.sunIsUp = player.func_130014_f_().func_72935_r() && !rainWeather;
        this.skyIsVisible = player.field_70170_p.func_175710_j(pos.func_177984_a()) && player.field_70170_p.func_180495_p(pos).func_185904_a().func_151565_r() == MapColor.field_151660_b && !noSunWorld;
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, armor) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)armor).number : 0;
        int energyPerDamage = (int)((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect);
        int damageLimit = (int)(energyPerDamage > 0 ? 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    @Override
    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage()) {
            return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio());
        }
        return 0;
    }

    @Override
    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        int protect = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PROTECTION, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION, (ItemStack)stack).number : 0;
        ElectricItem.manager.discharge(stack, (double)damage * ((double)this.getEnergyPerDamage() - (double)this.getEnergyPerDamage() * 0.2 * (double)protect), Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public int getEnergyPerDamage() {
        return this.energyPerDamage;
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return this.damageAbsorptionRatio;
    }

    @Override
    public void func_150895_a(CreativeTabs subs, NonNullList<ItemStack> items) {
        if (this.func_194125_a(subs)) {
            ItemStack stack = new ItemStack((Item)this, 1);
            NBTTagCompound nbt = ModUtils.nbt(stack);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            nbt.func_74768_a("ID_Item", Integer.MAX_VALUE);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((Item)this, 1, 27);
            nbt = ModUtils.nbt(itemstack);
            nbt.func_74768_a("ID_Item", Integer.MAX_VALUE);
            items.add((Object)itemstack);
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World p_77624_2_, List<String> info, @Nonnull ITooltipFlag p_77624_4_) {
        boolean auto;
        NBTTagCompound nbtData1 = ModUtils.nbt(itemStack);
        info.add(Localization.translate("iu.storage.helmet") + " " + ModUtils.getString(nbtData1.func_74769_h("storage")) + " EF");
        ModUtils.mode(itemStack, info);
        boolean with = this.solarType == 1;
        boolean without = this.solarType == 2 || this.solarType == 3;
        boolean bl = auto = this.solarType > 3;
        if (with || without || auto) {
            info.add(Localization.translate("iu.special_armor_nightvision") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.armormode.func_151463_i())));
            if (with) {
                info.add(Localization.translate("iu.special_armor_nightvision_1"));
            }
            if (without) {
                info.add(Localization.translate("iu.special_armor_nightvision_2"));
            }
            if (auto) {
                info.add(Localization.translate("iu.special_armor_nightvision_3"));
            }
        }
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean par5) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
    }
}

