/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bee;

import com.denfop.IUCore;
import com.denfop.api.IModelRegister;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.container.ContainerBeeAnalyzer;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.bee.ItemStackBeeAnalyzer;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBeeAnalyzer
extends Item
implements IItemStackInventory,
IModelRegister {
    private final String internalName;

    public ItemBeeAnalyzer(String internalName) {
        this.func_77637_a(IUCore.EnergyTab);
        this.func_77625_d(1);
        this.internalName = internalName;
        IUCore.proxy.addIModelRegister(this);
        Register.registerItem(this, IUCore.getIdentifier(internalName)).func_77655_b(internalName);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name) {
        String loc = "industrialupgrade:tools/" + name;
        return new ModelResourceLocation(loc, null);
    }

    public void save(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74757_a("open", true);
        nbt.func_74768_a("slot_inventory", player.field_71071_by.field_70461_c);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, EntityPlayer player) {
        ItemStackBeeAnalyzer toolbox;
        if (!player.func_130014_f_().field_72995_K && !ModUtils.isEmpty(stack) && player.field_71070_bA instanceof ContainerBeeAnalyzer && (toolbox = (ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)player.field_71070_bA).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.func_71053_j();
        }
        return true;
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull Entity entityIn, int itemSlot, boolean isSelected) {
        ItemStackBeeAnalyzer toolbox;
        int slot_id;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!(entityIn instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityIn;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (nbt.func_74767_n("open") && (slot_id = nbt.func_74762_e("slot_inventory")) != itemSlot && !player.func_130014_f_().field_72995_K && !ModUtils.isEmpty(stack) && player.field_71070_bA instanceof ContainerBeeAnalyzer && (toolbox = (ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)player.field_71070_bA).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.func_71053_j();
            nbt.func_74757_a("open", false);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (IUCore.proxy.isSimulating() && !player.func_70093_af()) {
            this.save(stack, player);
            player.openGui((Object)IUCore.instance, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Override
    public IAdvInventory getInventory(EntityPlayer player, ItemStack stack) {
        return new ItemStackBeeAnalyzer(player, stack, 1);
    }

    @Nonnull
    public String func_77658_a() {
        return "item." + this.internalName + ".name";
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> ItemBeeAnalyzer.getModelLocation1(name));
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemBeeAnalyzer.getModelLocation1(name)});
    }

    @Override
    public void registerModels() {
        this.registerModels(this.internalName);
    }

    public void func_150895_a(@Nonnull CreativeTabs p_150895_1_, @Nonnull NonNullList<ItemStack> var3) {
        if (this.func_194125_a(p_150895_1_)) {
            ItemStack var4 = new ItemStack((Item)this, 1);
            var3.add((Object)var4);
        }
    }
}

