/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bee;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.bee.BeeNetwork;
import com.denfop.api.bee.IBee;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class ItemJarBees
extends ItemSubTypes<Types>
implements IModelRegister {
    protected static final String NAME = "jar_bee";

    public ItemJarBees() {
        super(Types.class);
        this.func_77637_a(IUCore.BeesTab);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    public static IBee getBee(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        IBee bee = BeeNetwork.instance.getBee(nbt.func_74762_e("bee_id"));
        if (bee == null) {
            return null;
        }
        return bee.copy();
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World p_77663_2_, @Nonnull Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!(p_77663_3_ instanceof EntityPlayer)) {
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<String> p_77624_3_, ITooltipFlag p_77624_4_) {
        p_77624_3_.add(Localization.translate("iu.use_bee_analyzer") + Localization.translate(IUItem.bee_analyzer.func_77658_a()));
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        p_77624_3_.add(Localization.translate("iu.bee_negative"));
        IBee bee = ItemJarBees.getBee(p_77624_1_);
        if (bee != null) {
            List<IBee> unCompatibleBees = bee.getUnCompatibleBees();
            for (IBee bee1 : unCompatibleBees) {
                p_77624_3_.add(Localization.translate("bee_" + bee1.getName()));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            int mode = nbt.func_74762_e("bee_id");
            switch (mode) {
                case 1: {
                    return new ModelResourceLocation("industrialupgrade:jar_bee/winter_bee", null);
                }
                case 2: {
                    return new ModelResourceLocation("industrialupgrade:jar_bee/forest_bee", null);
                }
                case 3: {
                    return new ModelResourceLocation("industrialupgrade:jar_bee/tropical_bee", null);
                }
                case 4: {
                    return new ModelResourceLocation("industrialupgrade:jar_bee/plains_bee", null);
                }
                case 5: {
                    return new ModelResourceLocation("industrialupgrade:jar_bee/swamp_bee", null);
                }
            }
            return new ModelResourceLocation("industrialupgrade:jar_bee/forest_bee", null);
        });
        for (String s : mode = new String[]{"winter_bee", "forest_bee", "tropical_bee", "plains_bee", "swamp_bee"}) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("industrialupgrade:jar_bee/" + s, null)});
        }
    }

    public ItemStack getStackFromId(int id) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74768_a("bee_id", id);
        return stack;
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        IBee crop = BeeNetwork.instance.getBee(nbt.func_74762_e("bee_id"));
        if (nbt.func_74764_b("bee_id")) {
            return super.func_77653_i(stack) + ": " + Localization.translate("bee_" + crop.getName());
        }
        return super.func_77653_i(stack);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            BeeNetwork.instance.getBeeMap().forEach((id, crop) -> {
                ItemStack stack = new ItemStack((Item)this);
                NBTTagCompound nbt = ModUtils.nbt(stack);
                nbt.func_74768_a("bee_id", id.intValue());
                subItems.add((Object)stack);
            });
        }
    }

    public static enum Types implements ISubEnum
    {
        bees;

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID = this.ordinal();

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

