/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bee;

import com.denfop.api.bee.IBee;
import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.container.ContainerBeeAnalyzer;
import com.denfop.gui.GuiBeeAnalyzer;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStackBeeAnalyzer
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    public Genome genome;
    public IBee crop;
    public int weatherGenome = 0;
    public double pestGenome = 1.0;
    public double birthRateGenome = 1.0;
    public double radiusGenome = 1.0;
    public double populationGenome = 1.0;
    public double foodGenome = 1.0;
    public double jellyGenome = 1.0;
    public double productGenome = 1.0;
    public double hardeningGenome = 1.0;
    public double swarmGenome = 1.0;
    public double mortalityGenome = 1.0;
    public boolean sunGenome = false;
    public boolean nightGenome = false;
    public int genomeResistance = 0;
    public int genomeAdaptive = 0;
    public LevelPollution airPollution = LevelPollution.LOW;
    public LevelPollution soilPollution = LevelPollution.LOW;
    public EnumLevelRadiation radiationPollution = EnumLevelRadiation.LOW;

    public ItemStackBeeAnalyzer(EntityPlayer player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        this.inventorySize = inventorySize;
        this.itemStack1 = stack;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof ItemJarBees;
    }

    public void set() {
        this.reset();
        if (this.genome == null) {
            return;
        }
        if (this.genome.hasGenome(EnumGenetic.WEATHER)) {
            this.weatherGenome = this.genome.getLevelGenome(EnumGenetic.WEATHER, Integer.class);
        }
        if (this.genome.hasGenome(EnumGenetic.PEST)) {
            this.pestGenome = this.genome.getLevelGenome(EnumGenetic.PEST, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.BIRTH)) {
            this.birthRateGenome = this.genome.getLevelGenome(EnumGenetic.BIRTH, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.RADIUS)) {
            this.radiusGenome = this.genome.getLevelGenome(EnumGenetic.RADIUS, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.POPULATION)) {
            this.populationGenome = this.genome.getLevelGenome(EnumGenetic.POPULATION, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.FOOD)) {
            this.foodGenome = this.genome.getLevelGenome(EnumGenetic.FOOD, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.JELLY)) {
            this.jellyGenome = this.genome.getLevelGenome(EnumGenetic.JELLY, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.PRODUCT)) {
            this.productGenome = this.genome.getLevelGenome(EnumGenetic.PRODUCT, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.HARDENING)) {
            this.hardeningGenome = this.genome.getLevelGenome(EnumGenetic.HARDENING, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SWARM)) {
            this.swarmGenome = this.genome.getLevelGenome(EnumGenetic.SWARM, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.MORTALITY_RATE)) {
            this.mortalityGenome = this.genome.getLevelGenome(EnumGenetic.MORTALITY_RATE, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SUN)) {
            this.sunGenome = this.genome.getLevelGenome(EnumGenetic.SUN, Boolean.class);
        }
        if (this.genome.hasGenome(EnumGenetic.NIGHT)) {
            this.nightGenome = this.genome.getLevelGenome(EnumGenetic.NIGHT, Boolean.class);
        }
        if (this.genome.hasGenome(EnumGenetic.AIR)) {
            this.airPollution = this.genome.getLevelGenome(EnumGenetic.AIR, LevelPollution.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SOIL)) {
            this.soilPollution = this.genome.getLevelGenome(EnumGenetic.SOIL, LevelPollution.class);
        }
        if (this.genome.hasGenome(EnumGenetic.RADIATION)) {
            this.radiationPollution = this.genome.getLevelGenome(EnumGenetic.RADIATION, EnumLevelRadiation.class);
        }
        if (this.genome.hasGenome(EnumGenetic.GENOME_RESISTANCE)) {
            this.genomeResistance = this.genome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class);
        }
        if (this.genome.hasGenome(EnumGenetic.GENOME_ADAPTIVE)) {
            this.genomeAdaptive = this.genome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class);
        }
    }

    public void reset() {
        this.weatherGenome = 0;
        this.pestGenome = 1.0;
        this.swarmGenome = 1.0;
        this.mortalityGenome = 1.0;
        this.birthRateGenome = 1.0;
        this.radiusGenome = 1.0;
        this.populationGenome = 1.0;
        this.foodGenome = 1.0;
        this.jellyGenome = 1.0;
        this.productGenome = 1.0;
        this.hardeningGenome = 1.0;
        this.sunGenome = false;
        this.nightGenome = false;
        this.genomeResistance = 0;
        this.genomeAdaptive = 0;
        this.airPollution = LevelPollution.LOW;
        this.soilPollution = LevelPollution.LOW;
        this.radiationPollution = EnumLevelRadiation.LOW;
    }

    @Override
    public void save() {
        super.save();
    }

    public void saveAndThrow(ItemStack stack) {
        NBTTagList contentList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (ModUtils.isEmpty(this.inventory[i])) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbt);
            contentList.func_74742_a((NBTBase)nbt);
        }
        ModUtils.nbt(stack).func_74782_a("Items", (NBTBase)contentList);
        this.func_174888_l();
    }

    public ContainerBeeAnalyzer getGuiContainer(EntityPlayer player) {
        return new ContainerBeeAnalyzer(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiBeeAnalyzer getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiBeeAnalyzer(this.getGuiContainer(player), this.itemStack1);
    }

    public TileEntityInventory getParent() {
        return null;
    }

    @Override
    public void addInventorySlot(InvSlot var1) {
    }

    @Override
    public int getBaseIndex(InvSlot var1) {
        return 0;
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    protected void restore(ItemStack[] backup) {
        if (backup.length != this.inventory.length) {
            throw new IllegalArgumentException("invalid array size");
        }
        System.arraycopy(backup, 0, this.inventory, 0, this.inventory.length);
    }

    @Nonnull
    public String func_70005_c_() {
        return "toolbox";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int add(Collection<ItemStack> stacks) {
        return this.add(stacks, false);
    }

    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public boolean canAdd(Collection<ItemStack> stacks) {
        return this.add(stacks, true) == 0;
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    protected ItemStack[] backup() {
        ItemStack[] ret = new ItemStack[this.inventory.length];
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack content = this.inventory[i];
            ret[i] = ModUtils.isEmpty(content) ? ModUtils.emptyStack : content.func_77946_l();
        }
        return ret;
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
        this.save();
    }

    public int getStackSizeLimit() {
        return 64;
    }

    private boolean add(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.get(i) == null || this.get(i).func_190926_b()) {
                        if (!simulate) {
                            this.put(i, stack.func_77946_l());
                        }
                        return true;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                        }
                        return true;
                    }
                    if (stack.func_77978_p() == null || !stack.func_77978_p().equals((Object)this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private int add(Collection<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            ItemStack[] backup = simulate ? this.backup() : null;
            int totalAmount = 0;
            Iterator<ItemStack> var5 = stacks.iterator();
            while (true) {
                if (!var5.hasNext()) {
                    if (simulate) {
                        this.restore(backup);
                    }
                    return totalAmount;
                }
                ItemStack stack = var5.next();
                int amount = ModUtils.getSize(stack);
                if (amount <= 0) continue;
                block1: for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < this.inventorySize; ++i) {
                        ItemStack existingStack = this.get(i);
                        int space = this.getStackSizeLimit();
                        if (!ModUtils.isEmpty(existingStack)) {
                            space = Math.min(space, existingStack.func_77976_d()) - ModUtils.getSize(existingStack);
                        }
                        if (space <= 0) continue;
                        if (pass == 0 && !ModUtils.isEmpty(existingStack) && ModUtils.checkItemEqualityStrict(stack, existingStack)) {
                            if (space >= amount) {
                                existingStack.func_190917_f(amount);
                                this.put(i, existingStack);
                                amount = 0;
                                break block1;
                            }
                            existingStack.func_190917_f(space);
                            this.put(i, existingStack);
                            amount -= space;
                            continue;
                        }
                        if (pass != 1 || !ModUtils.isEmpty(existingStack)) continue;
                        if (space >= amount) {
                            this.put(i, ModUtils.setSize(stack, amount));
                            amount = 0;
                            break block1;
                        }
                        this.put(i, ModUtils.setSize(stack, space));
                        amount -= space;
                    }
                }
                totalAmount += amount;
            }
        }
        return 0;
    }
}

