/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.block;

import com.denfop.IUItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.items.block.ItemBlockIU;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.tiles.base.TileEntityBlock;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTileEntity
extends ItemBlockIU {
    public final ResourceLocation identifier;

    public ItemBlockTileEntity(Block block, ResourceLocation identifier) {
        super(block);
        this.func_77627_a(true);
        this.identifier = identifier;
    }

    public static boolean placeTeBlock(ItemStack stack, EntityLivingBase placer, World world, BlockPos pos, EnumFacing side, TileEntityBlock te) {
        IBlockState oldState = world.func_180495_p(pos);
        IBlockState newState = IUItem.invalid.func_176223_P();
        if (te.canPlace(te, pos, world)) {
            if (!world.func_180501_a(pos, newState, 0)) {
                return false;
            }
            world.func_175690_a(pos, (TileEntity)te);
            te.onPlaced(stack, placer, side);
            world.markAndNotifyBlock(pos, world.func_175726_f(pos), oldState, te.getBlockState(), 3);
            if (!world.field_72995_K) {
                new PacketUpdateTile(te);
            }
            return true;
        }
        return false;
    }

    public Block func_179223_d() {
        return super.func_179223_d();
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!(itemstack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, itemstack) && worldIn.func_190527_a(this.field_150939_a, pos, false, facing, (Entity)player) && (tile == null || player.func_70093_af() || tile != null && tile instanceof TileEntityBlock && !((TileEntityBlock)tile).onActivated(player, hand, facing, hitX, hitY, hitZ))) {
            int i = this.func_77647_b(itemstack.func_77960_j());
            IBlockState iblockstate1 = this.field_150939_a.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(itemstack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                iblockstate1 = worldIn.func_180495_p(pos);
                SoundType soundtype = iblockstate1.func_177230_c().getSoundType(iblockstate1, worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        IMultiTileBlock teBlock = this.getTeBlock(stack);
        String name = teBlock == null ? "invalid" : teBlock.func_176610_l();
        return super.func_77658_a() + "." + name;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        this.field_150939_a.func_149666_a(tab, items);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        IMultiTileBlock block = this.getTeBlock(stack);
        if (block != null && block.getDummyTe() != null) {
            block.getDummyTe().addInformation(stack, tooltip);
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        assert (newState.func_177230_c() == this.field_150939_a);
        if (!((BlockTileEntity)this.field_150939_a).canReplace(world, pos, side, stack)) {
            return false;
        }
        IMultiTileBlock teBlock = this.getTeBlock(stack);
        if (teBlock == null) {
            return false;
        }
        Class<? extends TileEntityBlock> teClass = teBlock.getTeClass();
        if (teClass == null) {
            return false;
        }
        TileEntityBlock te = TileEntityBlock.instantiate(teClass);
        return ItemBlockTileEntity.placeTeBlock(stack, (EntityLivingBase)player, world, pos, side, te);
    }

    public IMultiTileBlock getTeBlock(ItemStack stack) {
        return stack == null ? null : (!((BlockTileEntity)this.field_150939_a).teInfo.getIdMap().isEmpty() ? ((BlockTileEntity)this.field_150939_a).teInfo.getIdMap().get(stack.func_77952_i()) : null);
    }
}

