/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.book;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.ItemImage;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.guidebook.GuideTab;
import com.denfop.api.guidebook.Lines;
import com.denfop.api.guidebook.Quest;
import com.denfop.api.guidebook.Shape;
import com.denfop.gui.GuiIU;
import com.denfop.items.book.ContainerBook;
import com.denfop.items.book.GuideQuest;
import com.denfop.items.book.ItemStackBook;
import com.google.common.base.Supplier;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIBook
extends GuiIU<ContainerBook> {
    public static final ResourceLocation background = new ResourceLocation("industrialupgrade", "textures/gui/guidebook.png");
    public static final ResourceLocation sprites = new ResourceLocation("industrialupgrade", "textures/gui/sprites.png");
    public static final ResourceLocation sprites_lines = new ResourceLocation("industrialupgrade", "textures/gui/slider_guide.png");
    public static final ResourceLocation background1 = new ResourceLocation("industrialupgrade", "textures/gui/guidebook1.png");
    private final EntityPlayer player;
    int tab = 0;
    List<Quest> questList = new ArrayList<Quest>();
    LinkedList<GuideQuest> guideQuests = new LinkedList();
    private Map<String, List<String>> map;
    private boolean hoverDiscord = false;
    private boolean hoverGithub = false;
    private boolean hoverPU = false;
    private boolean hoverQG = false;
    private boolean hoverSQ = false;
    boolean reset = false;
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean isDragging = false;
    private boolean isDragging1 = false;
    private int lastMouseX;
    private int lastMouseY;

    public GUIBook(EntityPlayer player, ItemStack itemStack1, ContainerBook containerBook) {
        super(containerBook);
        this.player = player;
        this.field_146999_f = 345;
        this.field_147000_g = 195;
        this.questList = GuideBookCore.instance.getQuests(0);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.map = GuideBookCore.uuidGuideMap.get(this.player.func_110124_au());
        if (this.reset) {
            this.questList = GuideBookCore.instance.getQuests(this.tab);
            this.offsetX = 0;
            this.offsetY = 0;
            this.lastMouseX = 0;
            this.lastMouseY = 0;
            this.reset = false;
            this.guideQuests.clear();
        }
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin + 45;
        int y = j - yMin;
        int y1 = 5;
        for (GuideQuest guideQuest2 : new ArrayList<GuideQuest>(this.guideQuests)) {
            if (!guideQuest2.is(x, y)) continue;
            if (guideQuest2.isRemove(x, y)) {
                this.guideQuests.remove(guideQuest2);
            } else if (guideQuest2.isComplete(this.player, this.tab)) {
                guideQuest2.complete(this.player, this.tab);
            }
            return;
        }
        List<GuideTab> guideTabs = GuideBookCore.instance.getGuideTabs();
        for (int index = 0; index < guideTabs.size(); ++index) {
            if (index != this.tab) {
                GuideTab guideTab = guideTabs.get(index);
                int dx = -28;
                int u = 5;
                int v = 28;
                int w = 28;
                if (x >= dx && y >= y1 && x <= w + dx && y <= y1 + 27) {
                    this.tab = index;
                    this.reset = true;
                    return;
                }
            }
            y1 += 27;
        }
        if (this.hoverDiscord) {
            try {
                Desktop.getDesktop().browse(new URI("https://discord.com/invite/fqQPH6HKJV"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverGithub) {
            try {
                Desktop.getDesktop().browse(new URI("https://github.com/ZelGimi/industrialupgrade"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverPU) {
            try {
                Desktop.getDesktop().browse(new URI("https://www.curseforge.com/minecraft/mc-mods/power-utilities-iu"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverSQ) {
            try {
                Desktop.getDesktop().browse(new URI("https://www.curseforge.com/minecraft/mc-mods/simply-quarries"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.hoverQG) {
            try {
                Desktop.getDesktop().browse(new URI("https://www.curseforge.com/minecraft/mc-mods//quantum-generators"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.map == null) {
            return;
        }
        GuideTab guideTab = guideTabs.get(this.tab);
        List<String> quests = this.map.get(guideTab.unLocalized);
        for (Quest quest : GuideBookCore.instance.getQuests(this.tab)) {
            boolean isUnlocked;
            int texW;
            int centerX = 116 + this.offsetX;
            int centerY = 73 + this.offsetY;
            int xOffset = centerX + quest.x + (quest.shape == Shape.EPIC ? 2 : 3);
            int yOffset = centerY + quest.y + (quest.shape == Shape.EPIC ? 2 : 3);
            int texH = texW = quest.shape == Shape.EPIC ? 26 : 24;
            boolean hasPrev = quest.hasPrev;
            boolean bl = isUnlocked = hasPrev ? quests.contains(quest.prevName) : false;
            if (x < xOffset || x > xOffset + texW || y < yOffset || y > yOffset + texH) continue;
            if (this.guideQuests.contains(new GuideQuest(quest))) {
                this.guideQuests.removeIf(guideQuest -> guideQuest.getQuest().equals(quest));
                continue;
            }
            if (this.guideQuests.size() > 1) continue;
            this.guideQuests.add(new GuideQuest(quest, ((ItemStackBook)((ContainerBook)this.container).base).player, isUnlocked));
        }
    }

    @Override
    public void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        for (GuideQuest guideQuest : this.guideQuests) {
            if (!guideQuest.is(par1, par2)) continue;
            guideQuest.drawForegroundLayer(this, par1, par2);
            return;
        }
        List<GuideTab> guideTabs = GuideBookCore.instance.getGuideTabs();
        int y = 5;
        for (int index = 0; index < guideTabs.size(); ++index) {
            boolean isSelectedTab;
            GuideTab guideTab = guideTabs.get(index);
            int dx = -28;
            int w = 28;
            boolean bl = isSelectedTab = index == this.tab;
            if (isSelectedTab) {
                ((Area)new Area(this, -33, y, 33, 27).withTooltip(guideTab.name)).drawForeground(par1, par2);
            } else {
                ((Area)new Area(this, dx, y, w, 27).withTooltip(guideTab.name)).drawForeground(par1, par2);
            }
            y += 27;
        }
        this.hoverDiscord = false;
        this.hoverGithub = false;
        this.hoverPU = false;
        this.hoverQG = false;
        this.hoverSQ = false;
        if (par1 >= 10 && par1 <= 37 && par2 >= -15 && par2 <= 2) {
            this.hoverDiscord = true;
        }
        if (par1 >= 50 && par1 <= 77 && par2 >= -15 && par2 <= 2) {
            this.hoverGithub = true;
        }
        if (par1 >= 150 && par1 <= 177 && par2 >= -15 && par2 <= 2) {
            this.hoverPU = true;
        }
        if (par1 >= 180 && par1 <= 207 && par2 >= -15 && par2 <= 2) {
            this.hoverQG = true;
        }
        if (par1 >= 210 && par1 <= 237 && par2 >= -15 && par2 <= 2) {
            this.hoverSQ = true;
        }
        int centerX = 116 + this.offsetX;
        int centerY = 73 + this.offsetY;
        GuideTab guideTab = guideTabs.get(this.tab);
        if (this.map != null) {
            List<String> quests = this.map.get(guideTab.unLocalized);
            if (par1 >= 8 && par2 >= 9 && par1 <= 247 && par2 <= 185) {
                for (Quest quest : GuideBookCore.instance.getQuests(this.tab)) {
                    this.field_146297_k.func_110434_K().func_110577_a(sprites);
                    int texW = quest.shape == Shape.EPIC ? 26 : 24;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ((Area)new Area(this, centerX + quest.x, centerY + quest.y, texW, texW).withTooltip(quest.localizedName)).drawForeground(par1, par2);
                }
            }
        }
    }

    private void draw(int mouseX, int mouseY, int x, int x1, String text) {
        if (mouseX >= x && mouseX < x1 && mouseY >= 180 && mouseY < 190) {
            this.drawTooltip(mouseX, mouseY, Collections.singletonList(Localization.translate(text)));
        }
    }

    public void renderLines(Quest current, Lines lines) {
        boolean firstHorizontal;
        int centerX = 116;
        int centerY = 73;
        int x = current.x + 3;
        int y = current.y + 3;
        int prevX = current.prevX + 3;
        int prevY = current.prevY + 3;
        Shape shape = current.shape;
        Shape prevShape = current.prevShape;
        int startPosRender = 24;
        int endPosRender = 24;
        switch (prevShape) {
            case DEFAULT: 
            case UNIQUE: {
                startPosRender = 24;
                break;
            }
            case EPIC: {
                startPosRender = 26;
            }
        }
        switch (shape) {
            case DEFAULT: 
            case UNIQUE: {
                endPosRender = 24;
                break;
            }
            case EPIC: {
                endPosRender = 26;
            }
        }
        int dx = Math.abs(prevX - x);
        int dy = Math.abs(prevY - y);
        if (prevY < 0 && y < 0) {
            dy = Math.abs(-prevY + y);
        }
        if (firstHorizontal = dx < dy) {
            if (prevX < x) {
                if (y > prevY) {
                    this.drawHorizontalLine(prevX + startPosRender, prevY + startPosRender / 2 - 1, x + startPosRender / 2 + 1, prevY, lines);
                } else {
                    this.drawHorizontalLine(prevX + startPosRender, prevY + startPosRender / 2 - 1, x + startPosRender / 2 + 1, prevY, lines);
                }
                if (y - 1 > 0) {
                    this.drawVerticalLine(x + startPosRender / 2 - 1, prevY + startPosRender / 2, x, y, lines);
                } else {
                    this.drawVerticalLine(x + startPosRender / 2 - 1, y + startPosRender, x, prevY + startPosRender / 2, lines);
                }
            } else {
                this.drawHorizontalLine(x + startPosRender, prevY + startPosRender / 2 - 1, prevX + startPosRender / 2 + 1, prevY, lines);
                if (y - 1 > 0) {
                    this.drawVerticalLine(x + startPosRender / 2 - 1, prevY + startPosRender / 2, x, y, lines);
                } else {
                    this.drawVerticalLine(x + startPosRender / 2 - 1, y + startPosRender, x, prevY + startPosRender / 2, lines);
                }
            }
        } else if (y - 1 > 0) {
            if (y > prevY) {
                this.drawVerticalLine(prevX + startPosRender / 2 - 1, prevY + startPosRender, prevX + startPosRender, y + startPosRender / 2 + 1, lines);
                if (prevX < x) {
                    this.drawHorizontalLine(prevX + startPosRender / 2, y + startPosRender / 2 - 1, x, y, lines);
                } else {
                    this.drawHorizontalLine(x + startPosRender, y + startPosRender / 2 - 1, prevX + startPosRender / 2, y, lines);
                }
            } else {
                this.drawVerticalLine(prevX + startPosRender / 2 - 1, y + startPosRender / 2 - 1, prevX + startPosRender, prevY, lines);
                if (prevX < x) {
                    this.drawHorizontalLine(prevX + startPosRender, y + startPosRender / 2 - 1, x, y, lines);
                } else if (y == prevY) {
                    this.drawHorizontalLine(x + startPosRender, y + startPosRender / 2 - 1, prevX, y, lines);
                } else {
                    this.drawHorizontalLine(x + startPosRender, y + startPosRender / 2 - 1, prevX + startPosRender / 2, y, lines);
                }
            }
        } else if (prevY > 0 && y < 0 || prevY < 0 && y > 0) {
            this.drawVerticalLine(prevX + startPosRender / 2 - 1, y + startPosRender / 2 - 1, prevX + startPosRender, prevY, lines);
            if (prevX < x) {
                this.drawHorizontalLine(prevX + startPosRender / 2, y + startPosRender / 2 - 1, x, y, lines);
            } else {
                this.drawHorizontalLine(x + startPosRender / 2, y + startPosRender / 2 - 1, prevX, y, lines);
            }
        } else {
            this.drawVerticalLine(prevX + startPosRender / 2 - 1, prevY + startPosRender, prevX + startPosRender, y + startPosRender, lines);
            if (prevX < x) {
                this.drawHorizontalLine(prevX + startPosRender, y + startPosRender / 2 - 1, x, y, lines);
            } else {
                this.drawHorizontalLine(x + startPosRender, y + startPosRender / 2 - 1, prevX, y, lines);
            }
        }
    }

    public void drawHorizontalLine(int startX, int startY, int endX, int endY, Lines line) {
        int centerX = 116 + this.offsetX;
        int centerY = 73 + this.offsetY;
        this.field_146297_k.func_110434_K().func_110577_a(sprites_lines);
        this.func_73729_b(this.field_147003_i + centerX + startX, this.field_147009_r + centerY + startY, line.getHX(), line.getHY(), endX - startX, 2);
    }

    public void drawVerticalLine(int startX, int startY, int endX, int endY, Lines line) {
        int centerX = 116 + this.offsetX;
        int centerY = 73 + this.offsetY;
        this.field_146297_k.func_110434_K().func_110577_a(sprites_lines);
        this.func_73729_b(this.field_147003_i + centerX + startX, this.field_147009_r + centerY + startY, line.getVX(), line.getVY(), 2, endY - startY);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.field_147003_i;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.field_147009_r;
        int scrollDelta = Mouse.getEventDWheel();
        ScrollDirection direction = scrollDelta != 0 ? (scrollDelta < 0 ? ScrollDirection.down : ScrollDirection.up) : ScrollDirection.stopped;
        if (direction != ScrollDirection.stopped) {
            for (GuideQuest guideQuest : this.guideQuests) {
                if (!guideQuest.is(mouseX, mouseY)) continue;
                if (guideQuest.isTextFields(mouseX, mouseY) && guideQuest.canScroll(direction)) {
                    guideQuest.scroll(direction);
                    return;
                }
                if (!guideQuest.isItems(mouseX, mouseY) || !guideQuest.canScrollItem(direction)) continue;
                guideQuest.scrollItem(direction);
                return;
            }
        }
        if (Mouse.isButtonDown((int)0)) {
            for (GuideQuest guideQuest : this.guideQuests) {
                if (!guideQuest.is(mouseX, mouseY)) continue;
                if (!this.isDragging1) {
                    this.isDragging1 = true;
                } else {
                    int dx = Mouse.getEventX() - guideQuest.getLastMouseX1();
                    int dy = Mouse.getEventY() - guideQuest.getLastMouseY1();
                    guideQuest.setOffsetX1(guideQuest.getOffsetX1() + dx / 4);
                    guideQuest.setOffsetY1(guideQuest.getOffsetY1() - dy / 4);
                }
                guideQuest.setLastMouseX1(Mouse.getEventX());
                guideQuest.setLastMouseY1(Mouse.getEventY());
                return;
            }
        } else {
            this.isDragging1 = false;
        }
        if (mouseX >= 8 && mouseY >= 9 && mouseX <= 246 && mouseY <= 185) {
            if (Mouse.isButtonDown((int)0)) {
                if (!this.isDragging) {
                    this.isDragging = true;
                } else {
                    int dx = Mouse.getEventX() - this.lastMouseX;
                    int dy = Mouse.getEventY() - this.lastMouseY;
                    this.offsetX += dx / 4;
                    this.offsetY -= dy / 4;
                }
                this.lastMouseX = Mouse.getEventX();
                this.lastMouseY = Mouse.getEventY();
            } else {
                this.isDragging = false;
            }
        }
    }

    @Override
    public void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146999_f = 255;
        this.field_147000_g = 195;
        if (this.map == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(sprites);
        if (!this.hoverDiscord) {
            this.func_73729_b(this.field_147003_i + 10, this.field_147009_r - 15, 202, 7, 27, 17);
        } else {
            this.func_73729_b(this.field_147003_i + 10, this.field_147009_r - 15 - 6, 229, 1, 27, 22);
        }
        if (!this.hoverGithub) {
            this.func_73729_b(this.field_147003_i + 50, this.field_147009_r - 15, 202, 29, 27, 17);
        } else {
            this.func_73729_b(this.field_147003_i + 50, this.field_147009_r - 15 - 6, 229, 23, 27, 22);
        }
        if (!this.hoverPU) {
            this.func_73729_b(this.field_147003_i + 150, this.field_147009_r - 15, 202, 51, 27, 17);
        } else {
            this.func_73729_b(this.field_147003_i + 150, this.field_147009_r - 15 - 6, 229, 45, 27, 22);
        }
        if (!this.hoverQG) {
            this.func_73729_b(this.field_147003_i + 180, this.field_147009_r - 15, 202, 73, 27, 17);
        } else {
            this.func_73729_b(this.field_147003_i + 180, this.field_147009_r - 15 - 6, 229, 67, 27, 22);
        }
        if (!this.hoverSQ) {
            this.func_73729_b(this.field_147003_i + 210, this.field_147009_r - 15, 202, 95, 27, 17);
        } else {
            this.func_73729_b(this.field_147003_i + 210, this.field_147009_r - 15 - 6, 229, 89, 27, 22);
        }
        int x1 = mouseX - this.field_147003_i;
        int y1 = mouseY - this.field_147009_r;
        int y = 5;
        int centerX = 116 + this.offsetX;
        int centerY = 73 + this.offsetY;
        List<GuideTab> guideTabs = GuideBookCore.instance.getGuideTabs();
        for (int i = 0; i < guideTabs.size(); ++i) {
            GuideTab guideTab = guideTabs.get(i);
            String tabKey = guideTab.getUnLocalized();
            List<String> quests = this.map.get(tabKey);
            boolean isSelectedTab = i == this.tab;
            boolean hasQuests = !quests.isEmpty();
            this.field_146297_k.func_110434_K().func_110577_a(sprites);
            if (isSelectedTab) {
                this.func_73729_b(this.field_147003_i - 33, this.field_147009_r + y, 0, hasQuests ? 0 : 56, 33, 27);
                new ItemImage(this, -24, y + 6, (Supplier<ItemStack>)((Supplier)() -> guideTab.icon)).drawBackground(this.field_147003_i, this.field_147009_r);
                this.enableScissor(this.field_147003_i + 8, this.field_147009_r + 9, 238, 176);
                for (Quest quest : GuideBookCore.instance.getQuests(i)) {
                    int texW;
                    this.field_146297_k.func_110434_K().func_110577_a(sprites);
                    boolean hasPrev = quest.hasPrev;
                    boolean isUnlocked = hasPrev ? quests.contains(quest.prevName) : quests.contains(quest.unLocalizedName);
                    int xOffset = this.field_147003_i + centerX + quest.x + (quest.shape == Shape.EPIC ? 2 : 3);
                    int yOffset = this.field_147009_r + centerY + quest.y + (quest.shape == Shape.EPIC ? 2 : 3);
                    int texX = 0;
                    int texY = 0;
                    int texH = texW = quest.shape == Shape.EPIC ? 26 : 24;
                    if (hasPrev) {
                        int n = texY = isUnlocked ? 28 : 1;
                        if (!quests.contains(quest.unLocalizedName)) {
                            texY = 57;
                        }
                    } else {
                        texY = isUnlocked ? 1 : 57;
                    }
                    switch (quest.shape) {
                        case DEFAULT: {
                            texX = 36;
                            break;
                        }
                        case UNIQUE: {
                            texX = 61;
                            break;
                        }
                        case EPIC: {
                            texX = 86;
                        }
                    }
                    this.func_73729_b(xOffset, yOffset, texX, texY, texW, texH);
                    if (hasPrev) {
                        this.field_146297_k.func_110434_K().func_110577_a(sprites_lines);
                        this.renderLines(quest, this.getLine(quest, quests, guideTab));
                    }
                    new ItemImage(this, centerX + quest.x + 7, centerY + quest.y + 7, (Supplier<ItemStack>)((Supplier)() -> quest.icon)).drawBackground(this.field_147003_i, this.field_147009_r);
                }
                this.disableScissor();
            } else {
                int dx = hasQuests ? -28 : -33;
                int u = hasQuests ? 5 : 0;
                int v = hasQuests ? 28 : 56;
                int w = hasQuests ? 28 : 33;
                this.func_73729_b(this.field_147003_i + dx, this.field_147009_r + y, u, v, w, 27);
                new ItemImage(this, dx + 8, y + 6, (Supplier<ItemStack>)((Supplier)() -> guideTab.icon)).drawBackground(this.field_147003_i, this.field_147009_r);
            }
            y += 27;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)250.0f);
        if (this.map != null) {
            GuideTab guideTab = guideTabs.get(this.tab);
            String tabKey = guideTab.getUnLocalized();
            List<String> quests = this.map.get(tabKey);
            for (GuideQuest guideQuest : this.guideQuests) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)250.0f);
                guideQuest.drawBackgroundLayer(this, this.field_147003_i, this.field_147009_r, !quests.contains(guideQuest.getQuest().unLocalizedName));
            }
        }
    }

    private Lines getLine(Quest quest, List<String> quests, GuideTab guideTab) {
        String PrevName = quest.prevName;
        if (!quests.contains(PrevName)) {
            return Lines.GOLD;
        }
        Quest quest1 = GuideBookCore.instance.getPrev(quest.prevName, guideTab);
        if (quest1.hasPrev) {
            if (quests.contains(quest1.prevName)) {
                return Lines.DARK;
            }
            return Lines.GRAY;
        }
        return Lines.GRAY;
    }

    private void enableScissor(int x, int y, int width, int height) {
        ScaledResolution scaledResolution = new ScaledResolution(this.field_146297_k);
        int scaleFactor = scaledResolution.func_78325_e();
        int scaledHeight = scaledResolution.func_78328_b();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * scaleFactor), (int)((scaledHeight - (y + height)) * scaleFactor), (int)(width * scaleFactor), (int)(height * scaleFactor));
    }

    private void disableScissor() {
        GL11.glDisable((int)3089);
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

