/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.book;

import com.denfop.Localization;
import com.denfop.api.gui.FluidItem;
import com.denfop.api.gui.ItemImage;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.api.gui.ScrollDirection;
import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.guidebook.Quest;
import com.denfop.items.book.GUIBook;
import com.denfop.network.packet.PacketUpdateCompleteQuest;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.lwjgl.opengl.GL11;

public class GuideQuest {
    private final Quest quest;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final EntityPlayer player;
    private boolean isUnlocked = false;
    private int offsetX1 = 0;
    private int offsetY1 = 0;
    private int maxPage = 1;
    private int page = 1;
    private int maxItemPage = 1;
    private int itemPage = 1;
    private int lastMouseX1;
    private int lastMouseY1;
    private boolean hover = false;
    private boolean hoverButton = false;
    List<ItemStack> stacks = new ArrayList<ItemStack>();

    public GuideQuest(Quest quest) {
        this.quest = quest;
        this.x = 25;
        this.y = 25;
        this.width = 208;
        this.height = 176;
        this.player = null;
    }

    public boolean isUnlocked() {
        return this.isUnlocked;
    }

    public boolean hasAllItems(EntityPlayer player, List<ItemStack> requiredItems) {
        for (FluidStack fluidStack : this.getQuest().fluidStacks) {
            int amount = fluidStack.amount;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                IFluidHandlerItem handler;
                ItemStack inInventory = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (FluidUtil.getFluidHandler((ItemStack)inInventory) == null || (handler = FluidUtil.getFluidHandler((ItemStack)inInventory)).getTankProperties()[0].getContents() == null || !handler.getTankProperties()[0].getContents().isFluidEqual(fluidStack)) continue;
                if (handler.getTankProperties()[0].getContents().amount < fluidStack.amount) {
                    amount -= handler.getTankProperties()[0].getContents().amount;
                    continue;
                }
                amount = 0;
                break;
            }
            if (amount == 0) continue;
            return false;
        }
        for (ItemStack required : requiredItems) {
            ItemStack inInventory;
            int neededCount = required.func_190916_E();
            int foundCount = 0;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size() && (!ItemStack.func_179545_c((ItemStack)(inInventory = (ItemStack)player.field_71071_by.field_70462_a.get(i)), (ItemStack)required) && ModUtils.matchesNBT(inInventory.func_77978_p(), required.func_77978_p()) || (foundCount += inInventory.func_190916_E()) < neededCount); ++i) {
            }
            if (foundCount >= neededCount) continue;
            return false;
        }
        return true;
    }

    public GuideQuest(Quest quest, EntityPlayer player, boolean isUnlocked) {
        this.quest = quest;
        this.x = 25;
        this.y = 25;
        this.width = 208;
        this.height = 176;
        this.isUnlocked = isUnlocked;
        for (ItemStack stack : quest.itemStacks) {
            boolean merged = false;
            for (ItemStack existing : this.stacks) {
                if (!ItemStack.func_77989_b((ItemStack)existing, (ItemStack)stack)) continue;
                existing.func_190917_f(stack.func_190916_E());
                merged = true;
                break;
            }
            if (merged) continue;
            this.stacks.add(stack.func_77946_l());
        }
        this.player = player;
    }

    public void drawForegroundLayer(GUIBook guiIU, int x, int y) {
        int startX = x;
        int startY = y;
        this.hover = startX >= this.x + this.offsetX1 + 191 && startX <= this.x + this.offsetX1 + 191 + 13 && startY >= this.y + this.offsetY1 + 4 && startY <= this.y + this.offsetY1 + 15;
        this.hoverButton = startX >= this.x + this.offsetX1 + 15 && startX <= this.x + this.offsetX1 + 34 && startY >= this.y + this.offsetY1 + 37 && startY <= this.y + this.offsetY1 + 55;
        int j = -1;
        int size = this.quest.itemStacks.size() + this.quest.fluidStacks.size();
        for (int i = (this.itemPage - 1) * 11; i < Math.min(this.itemPage * 11, size); ++i) {
            int finalI;
            ++j;
            if (i < this.quest.itemStacks.size()) {
                finalI = i;
                new ItemStackImage(guiIU, this.x + this.offsetX1 + 6 + j * 18, this.y + this.offsetY1 + 64, (Supplier<ItemStack>)((Supplier)() -> this.quest.itemStacks.get(finalI))).drawForeground(x, y);
                continue;
            }
            finalI = i - this.quest.itemStacks.size();
            new FluidItem(guiIU, this.x + this.offsetX1 + 6 + j * 18, this.y + this.offsetY1 + 64, this.quest.fluidStacks.get(finalI)).drawForeground(x, y);
        }
    }

    public boolean isRemove(int x, int y) {
        int startX = x;
        int startY = y;
        return startX >= this.x + this.offsetX1 + 191 && startX <= this.x + this.offsetX1 + 191 + 13 && startY >= this.y + this.offsetY1 + 4 && startY <= this.y + this.offsetY1 + 15;
    }

    public void setLastMouseX1(int lastMouseX1) {
        this.lastMouseX1 = lastMouseX1;
    }

    public void setLastMouseY1(int lastMouseY1) {
        this.lastMouseY1 = lastMouseY1;
    }

    public void setOffsetX1(int offsetX1) {
        this.offsetX1 = offsetX1;
    }

    public void setOffsetY1(int offsetY1) {
        this.offsetY1 = offsetY1;
    }

    public int getLastMouseX1() {
        return this.lastMouseX1;
    }

    public int getLastMouseY1() {
        return this.lastMouseY1;
    }

    public int getOffsetX1() {
        return this.offsetX1;
    }

    public int getOffsetY1() {
        return this.offsetY1;
    }

    public boolean is(int x, int y) {
        int tempX = this.x + this.offsetX1;
        int tempy = this.y + this.offsetY1;
        return tempX <= x && tempy <= y && y <= tempy + this.height && x <= tempX + this.width;
    }

    public void drawBackgroundLayer(GUIBook guiIU, int mouseX, int mouseY, boolean isComplete) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiIU.field_146297_k.func_110434_K().func_110577_a(GUIBook.background1);
        guiIU.func_73729_b(mouseX + this.x + this.offsetX1, mouseY + this.y + this.offsetY1, 0, 0, this.width, this.height);
        if (this.hover) {
            guiIU.func_73729_b(mouseX + this.x + this.offsetX1 + 191, mouseY + this.y + this.offsetY1 + 4, 243, 12, 13, 12);
        } else {
            guiIU.func_73729_b(mouseX + this.x + this.offsetX1 + 191, mouseY + this.y + this.offsetY1 + 4, 243, 0, 13, 12);
        }
        if (isComplete) {
            guiIU.func_73729_b(mouseX + this.x + this.offsetX1 + 15, mouseY + this.y + this.offsetY1 + 37, 236, 85, 20, 19);
        } else if (this.hasAllItems(this.player, this.stacks) && !this.isUnlocked()) {
            if (!this.hoverButton) {
                guiIU.func_73729_b(mouseX + this.x + this.offsetX1 + 15, mouseY + this.y + this.offsetY1 + 37, 236, 25, 20, 19);
            } else {
                guiIU.func_73729_b(mouseX + this.x + this.offsetX1 + 15, mouseY + this.y + this.offsetY1 + 37, 236, 45, 20, 19);
            }
        } else {
            guiIU.func_73729_b(mouseX + this.x + this.offsetX1 + 15, mouseY + this.y + this.offsetY1 + 37, 236, 65, 20, 19);
        }
        Minecraft.func_71410_x().field_71466_p.func_78276_b(this.quest.localizedName, mouseX + this.x + this.offsetX1 + 5 + this.width / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.quest.localizedName) / 2, mouseY + this.y + this.offsetY1 + 5, 0);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(ChatFormatting.GREEN + Localization.translate("iu.quest.task." + this.quest.typeQuest.name().toLowerCase()), mouseX + this.x + this.offsetX1 + 5 + this.width / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a("iu.quest.task." + this.quest.typeQuest.name().toLowerCase()) / 2, mouseY + this.y + this.offsetY1 + 25, 0);
        new ItemImage(guiIU, this.x + this.offsetX1 + 17, this.y + this.offsetY1 + 16, (Supplier<ItemStack>)((Supplier)() -> this.quest.icon)).drawBackground(mouseX, mouseY);
        List<String> lines = guiIU.splitTextToLines(this.quest.localizedDescription, this.width - 15, 1.0f, Minecraft.func_71410_x().field_71466_p);
        this.maxPage = Math.max(1, lines.size() - 6);
        this.maxItemPage = Math.max(1, 1 + (this.quest.fluidStacks.size() + this.quest.itemStacks.size()) / 11);
        this.enableScissor(mouseX + this.x + this.offsetX1 + 6, mouseY + this.y + this.offsetY1 + 90, this.width - 15, 70);
        guiIU.drawTextInCanvasWithScissor(this.quest.localizedDescription, this.x + this.offsetX1 + 6, this.y + this.offsetY1 + 90 - (this.page - 1) * 10, this.width - 15, 70, 1.0f);
        this.disableScissor();
        Minecraft.func_71410_x().field_71466_p.func_78276_b(this.page + "/" + this.maxPage, mouseX + this.x + this.offsetX1 + 5 + this.width / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.page + "/" + this.maxPage) / 2, mouseY + this.y + this.offsetY1 + 162, 0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiIU.field_146297_k.func_110434_K().func_110577_a(GUIBook.background1);
        int scroll = (int)Math.ceil(71.0 / (double)this.maxPage);
        guiIU.func_73729_b(mouseX + this.x + this.offsetX1 + 200, mouseY + this.y + this.offsetY1 + 94 + (this.page - 1) * 71 / this.maxPage, 232, 1, 3, scroll);
        scroll = (int)Math.ceil(11.0 / (double)this.maxItemPage);
        guiIU.func_73729_b(mouseX + this.x + this.offsetX1 + 200, mouseY + this.y + this.offsetY1 + 67 + (this.itemPage - 1) * 11 / this.maxItemPage, 232, 1, 3, scroll);
        int j = -1;
        int size = this.quest.itemStacks.size() + this.quest.fluidStacks.size();
        for (int i = (this.itemPage - 1) * 11; i < Math.min(this.itemPage * 11, size); ++i) {
            int finalI;
            ++j;
            if (i < this.quest.itemStacks.size()) {
                finalI = i;
                new ItemStackImage(guiIU, this.x + this.offsetX1 + 6 + j * 18, this.y + this.offsetY1 + 64, (Supplier<ItemStack>)((Supplier)() -> this.quest.itemStacks.get(finalI))).drawBackground(mouseX, mouseY);
                continue;
            }
            finalI = i - this.quest.itemStacks.size();
            new FluidItem(guiIU, this.x + this.offsetX1 + 6 + j * 18, this.y + this.offsetY1 + 64, this.quest.fluidStacks.get(finalI)).drawBackground(mouseX, mouseY);
        }
    }

    private void enableScissor(int x, int y, int width, int height) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int scaleFactor = scaledResolution.func_78325_e();
        int scaledHeight = scaledResolution.func_78328_b();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * scaleFactor), (int)((scaledHeight - (y + height)) * scaleFactor), (int)(width * scaleFactor), (int)(height * scaleFactor));
    }

    private void disableScissor() {
        GL11.glDisable((int)3089);
    }

    public boolean isTextFields(int x, int y) {
        int tempX = this.x + this.offsetX1 + 6;
        int tempy = this.y + this.offsetY1 + 90;
        return tempX <= x && tempy <= y && y <= tempy + 90 + 70 && x <= tempX + this.width;
    }

    public void scroll(ScrollDirection direction) {
        if (direction == ScrollDirection.down) {
            ++this.page;
            this.page = Math.min(this.page, this.maxPage);
        } else {
            --this.page;
            this.page = Math.max(1, this.page);
        }
    }

    public void scrollItem(ScrollDirection direction) {
        if (direction == ScrollDirection.down) {
            ++this.itemPage;
            this.itemPage = Math.min(this.itemPage, this.maxItemPage);
        } else {
            --this.itemPage;
            this.itemPage = Math.max(1, this.itemPage);
        }
    }

    public Quest getQuest() {
        return this.quest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Quest) {
            Quest that = (Quest)o;
            return Objects.equals(this.quest, that);
        }
        if (o instanceof GuideQuest) {
            GuideQuest that = (GuideQuest)o;
            return Objects.equals(this.quest, that.quest);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.quest);
    }

    public boolean isItems(int x, int y) {
        int tempX = this.x + this.offsetX1 + 6;
        int tempy = this.y + this.offsetY1 + 63;
        return tempX <= x && tempy <= y && y <= tempy + 20 && x <= tempX + this.width;
    }

    public boolean canScroll(ScrollDirection direction) {
        int page = this.page;
        if (direction == ScrollDirection.down) {
            ++page;
            page = Math.min(page, this.maxPage);
        } else {
            --page;
            page = Math.max(1, page);
        }
        return page != this.page;
    }

    public boolean canScrollItem(ScrollDirection direction) {
        int itemPage = this.itemPage;
        if (direction == ScrollDirection.down) {
            ++itemPage;
            itemPage = Math.min(itemPage, this.maxItemPage);
        } else {
            --itemPage;
            itemPage = Math.max(1, itemPage);
        }
        return itemPage != this.itemPage;
    }

    public boolean isComplete(EntityPlayer player, int tab) {
        if (this.hasAllItems(player, this.stacks) && this.hoverButton && !this.isUnlocked) {
            return GuideBookCore.uuidGuideMap.get(player.func_110124_au()).get(GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized).contains(this.quest.unLocalizedName);
        }
        return false;
    }

    public void complete(EntityPlayer player, int tab) {
        new PacketUpdateCompleteQuest(player, GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized, this.quest.unLocalizedName);
    }
}

