/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.crop;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.agriculture.CropNetwork;
import com.denfop.api.agriculture.ICrop;
import com.denfop.api.agriculture.ICropItem;
import com.denfop.api.agriculture.genetics.Genome;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistrySimple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemCrops
extends ItemSubTypes<Types>
implements IModelRegister,
ICropItem {
    protected static final String NAME = "crops";
    Map<Integer, ModelResourceLocation> modelResourceLocationMap = new HashMap<Integer, ModelResourceLocation>();

    public ItemCrops() {
        super(Types.class);
        this.func_77637_a(IUCore.CropsTab);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World p_77663_2_, @Nonnull Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!(p_77663_3_ instanceof EntityPlayer)) {
            return;
        }
    }

    private int getIndex(Item item, int meta) {
        return Item.func_150891_b((Item)item) << 16 | meta;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation("industrialupgrade:crops/" + Types.getFromID(meta).func_176610_l(), null)});
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            boolean hasKey = nbt.func_74764_b("crop_id");
            if (!hasKey) {
                return new ModelResourceLocation("industrialupgrade:crops/" + Types.getFromID(meta).func_176610_l(), null);
            }
            ICrop crop = CropNetwork.instance.getCrop(nbt.func_74762_e("crop_id"));
            ModelManager modelManager = Minecraft.func_71410_x().field_175617_aL;
            boolean isShiftPressed = Keyboard.isKeyDown((int)42);
            if (isShiftPressed && !crop.getDrops().isEmpty()) {
                ItemStack stack1 = crop.getDrops().get(0);
                ModelResourceLocation modelResourceLocation = this.modelResourceLocationMap.get(nbt.func_74762_e("crop_id"));
                if (modelResourceLocation == null) {
                    RegistrySimple registry = (RegistrySimple)modelManager.field_174958_a;
                    IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175597_ag().field_178112_h.func_184393_a(stack1, null, null);
                    for (Map.Entry entry : registry.field_82596_a.entrySet()) {
                        if (entry.getValue() != ibakedmodel) continue;
                        this.modelResourceLocationMap.put(nbt.func_74762_e("crop_id"), (ModelResourceLocation)entry.getKey());
                        return (ModelResourceLocation)entry.getKey();
                    }
                } else {
                    return modelResourceLocation;
                }
            }
            return new ModelResourceLocation("industrialupgrade:crops/" + Types.getFromID(meta).func_176610_l(), null);
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack p_77624_1_, @Nullable World p_77624_2_, List<String> p_77624_3_, ITooltipFlag p_77624_4_) {
        p_77624_3_.add(Localization.translate("iu.use_agriculture_analyzer") + Localization.translate(IUItem.agricultural_analyzer.func_77658_a()));
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        ICrop crop = this.getCrop(0, p_77624_1_);
        if (crop.getId() != 3) {
            ItemStack stack;
            ItemStack soil = crop.getSoil().getStack();
            if (!soil.func_190926_b()) {
                p_77624_3_.add(TextFormatting.YELLOW + Localization.translate("iu.crop.oneprobe.soil") + " " + soil.func_82833_r());
            }
            if (!crop.getDrops().isEmpty() && !(stack = crop.getDrops().get(0)).func_190926_b()) {
                p_77624_3_.add(TextFormatting.AQUA + Localization.translate("iu.crop.oneprobe.drop") + " " + stack.func_82833_r());
            }
            if (!crop.getCropCombine().isEmpty()) {
                p_77624_3_.add(TextFormatting.GREEN + Localization.translate("iu.crop.breeding"));
                for (ICrop crop1 : crop.getCropCombine()) {
                    p_77624_3_.add(Localization.translate("crop." + crop1.getName()));
                }
            }
        }
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        ICrop crop = CropNetwork.instance.getCrop(nbt.func_74762_e("crop_id"));
        return super.func_77653_i(stack) + ": " + Localization.translate("crop." + crop.getName());
    }

    @Override
    public ICrop getCrop(int meta, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        return CropNetwork.instance.getCrop(nbt.func_74762_e("crop_id"));
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            CropNetwork.instance.getCropMap().forEach((id, crop) -> {
                if (id != 3) {
                    ItemStack stack = new ItemStack((Item)this);
                    NBTTagCompound nbt = ModUtils.nbt(stack);
                    nbt.func_74768_a("crop_id", id.intValue());
                    new Genome(stack);
                    subItems.add((Object)stack);
                }
            });
        }
    }

    public static enum Types implements ISubEnum
    {
        seeds;

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID = this.ordinal();

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

