/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.energy.EntityAdvArrow;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.register.Register;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemEnergyBow
extends ItemBow
implements IEnergyItem,
IUpgradeItem,
IModelRegister {
    static final int[] CHARGE = new int[]{1500, 750, 2000, 5000, 1000};
    static final String[] MODE = new String[]{"normal", "rapidfire", "spread", "sniper", "flame"};
    private final float type;
    private final String name;
    private final double nanoBowBoost;
    private final int tier;
    private final int transferenergy;
    private final int maxenergy;

    public ItemEnergyBow(String name, double nanoBowBoost, int tier, int transferenergy, int maxenergy, float type) {
        this.func_77664_n();
        this.func_77637_a(IUCore.EnergyTab);
        this.name = name;
        this.nanoBowBoost = nanoBowBoost;
        this.tier = tier;
        this.transferenergy = transferenergy;
        this.maxenergy = maxenergy;
        this.type = type;
        this.func_77655_b(name);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @javax.annotation.Nullable World worldIn, @javax.annotation.Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BOW.list);
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.5f);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name) {
        String loc = "industrialupgrade:energy_tools/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.BOW.list;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World p_77624_2_, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag p_77624_4_) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        } else {
            tooltip.add(Localization.translate("iu.changemode_key") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.changemode.func_151463_i())) + Localization.translate("iu.changemode_rcm"));
        }
        switch (this.tier) {
            case 2: {
                tooltip.add(Localization.translate("iu.bow.maxdamage") + 47);
                break;
            }
            case 3: {
                tooltip.add(Localization.translate("iu.bow.maxdamage") + 56);
                break;
            }
            case 4: {
                tooltip.add(Localization.translate("iu.bow.maxdamage") + 71);
            }
        }
        ModUtils.mode(stack, tooltip);
        super.func_77624_a(stack, p_77624_2_, tooltip, p_77624_4_);
    }

    public void func_150895_a(@Nonnull CreativeTabs subs, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(subs)) {
            ItemStack stack = new ItemStack((Item)this, 1);
            NBTTagCompound nbt = ModUtils.nbt(stack);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            nbt.func_74768_a("ID_Item", Integer.MAX_VALUE);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((Item)this, 1);
            nbt = ModUtils.nbt(itemstack);
            nbt.func_74768_a("ID_Item", Integer.MAX_VALUE);
            items.add((Object)itemstack);
        }
    }

    public EntityAdvArrow createArrow(World worldIn, ItemStack stack, EntityLivingBase shooter) {
        EntityAdvArrow entitytippedarrow = new EntityAdvArrow(worldIn, shooter);
        entitytippedarrow.func_184555_a(stack);
        entitytippedarrow.setStack(stack);
        return entitytippedarrow;
    }

    public boolean isRepairable() {
        return false;
    }

    @Nonnull
    public EntityAdvArrow customizeArrow(@Nonnull EntityArrow arrow) {
        return (EntityAdvArrow)arrow;
    }

    public void func_77615_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase EntityLivingBase2, int timeLeft) {
        float f;
        if (!(EntityLivingBase2 instanceof EntityPlayer)) {
            super.func_77615_a(stack, world, EntityLivingBase2, timeLeft);
        }
        assert (EntityLivingBase2 instanceof EntityPlayer);
        EntityPlayer player = (EntityPlayer)EntityLivingBase2;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int mode = nbt.func_74762_e("bowMode");
        int charge = this.func_77626_a(stack) - timeLeft;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        charge = event.getCharge();
        if (mode == 3) {
            charge /= 2;
        }
        if (mode == 1) {
            charge *= 4;
        }
        if ((double)(f = ItemEnergyBow.getArrowVelocity(charge)) < 0.1) {
            return;
        }
        if (!world.field_72995_K) {
            int bowenergy;
            EntityAdvArrow arrow = this.createArrow(world, stack, (EntityLivingBase)player);
            arrow = this.customizeArrow((EntityArrow)arrow);
            arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
            if (f == 1.5f) {
                arrow.func_70243_d(true);
            }
            int bowdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWDAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWDAMAGE, (ItemStack)stack).number : 0;
            arrow.func_70239_b(arrow.func_70242_d() + (double)this.type * 2.5 + 0.5 + (double)this.type * 2.5 * 0.25 * (double)bowdamage);
            int j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            if (j > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (mode == 0 && arrow.func_70241_g()) {
                j += 3;
            } else if (mode == 1 && arrow.func_70241_g()) {
                ++j;
            } else if (mode == 3 && arrow.func_70241_g()) {
                j += 8;
            }
            if (j > 0) {
                arrow.func_70239_b(arrow.func_70242_d() + (double)j * 0.5 + 0.5);
            }
            if (this.nanoBowBoost > 0.0) {
                arrow.func_70239_b(arrow.func_70242_d() + this.nanoBowBoost * 0.5 + 0.5);
            }
            int k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack);
            if (mode == 0 && arrow.func_70241_g()) {
                ++k;
            } else if (mode == 3 && arrow.func_70241_g()) {
                k += 5;
            }
            if (k > 0) {
                arrow.func_70240_a(k);
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                arrow.func_70015_d(100);
            }
            if (mode == 4 && arrow.func_70241_g()) {
                arrow.func_70015_d(2000);
            }
            arrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
            int n = bowenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
            if (mode == 2) {
                if (ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
                    ElectricItem.manager.use(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy, (EntityLivingBase)player);
                    new PacketSoundPlayer(EnumSound.bow, player);
                    world.func_72838_d((Entity)arrow);
                    if (arrow.func_70241_g()) {
                        EntityAdvArrow arrow2 = this.createArrow(world, stack, (EntityLivingBase)player);
                        arrow2 = this.customizeArrow((EntityArrow)arrow2);
                        arrow2.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        arrow2.func_70239_b(f * 2.0f);
                        arrow2.func_70107_b(((EntityArrow)arrow2).field_70165_t + 0.25, ((EntityArrow)arrow2).field_70163_u, ((EntityArrow)arrow2).field_70161_v);
                        arrow2.func_70243_d(true);
                        ((EntityArrow)arrow2).field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        EntityAdvArrow arrow3 = this.createArrow(world, stack, (EntityLivingBase)player);
                        arrow3 = this.customizeArrow((EntityArrow)arrow3);
                        arrow3.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        arrow3.func_70239_b(f * 2.0f);
                        arrow3.func_70107_b(((EntityArrow)arrow3).field_70165_t, ((EntityArrow)arrow3).field_70163_u + 0.25, ((EntityArrow)arrow3).field_70161_v);
                        arrow3.func_70243_d(true);
                        ((EntityArrow)arrow3).field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        EntityAdvArrow arrow4 = this.createArrow(world, stack, (EntityLivingBase)player);
                        arrow4 = this.customizeArrow((EntityArrow)arrow4);
                        arrow4.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        arrow4.func_70239_b(f * 2.0f);
                        arrow4.func_70107_b(((EntityArrow)arrow4).field_70165_t - 0.25, ((EntityArrow)arrow4).field_70163_u, ((EntityArrow)arrow4).field_70161_v);
                        arrow4.func_70243_d(true);
                        ((EntityArrow)arrow4).field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        EntityAdvArrow arrow5 = this.createArrow(world, stack, (EntityLivingBase)player);
                        arrow5 = this.customizeArrow((EntityArrow)arrow5);
                        arrow5.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                        arrow5.func_70239_b(f * 2.0f);
                        arrow5.func_70107_b(((EntityArrow)arrow2).field_70165_t, ((EntityArrow)arrow2).field_70163_u - 0.25, ((EntityArrow)arrow2).field_70161_v);
                        arrow5.func_70243_d(true);
                        ((EntityArrow)arrow5).field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                        world.func_72838_d((Entity)arrow2);
                        world.func_72838_d((Entity)arrow3);
                        world.func_72838_d((Entity)arrow4);
                        world.func_72838_d((Entity)arrow5);
                    }
                }
            } else if (ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
                ElectricItem.manager.use(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy, (EntityLivingBase)player);
                new PacketSoundPlayer(EnumSound.bow, player);
                world.func_72838_d((Entity)arrow);
            }
        }
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        switch (nbt.func_74762_e("bowMode")) {
            case 3: 
            case 5: {
                return 144000;
            }
            case 1: {
                return 18000;
            }
        }
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, EntityPlayer player, @Nonnull EnumHand hand) {
        int bowenergy;
        ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int mode = nbt.func_74762_e("bowMode");
        int n = bowenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            if (!world.field_72995_K) {
                if (++mode >= CHARGE.length) {
                    mode = 0;
                }
                nbt.func_74768_a("bowMode", mode);
            }
            if (IUCore.proxy.isSimulating()) {
                IUCore.proxy.messagePlayer(player, Localization.translate("info.nanobow." + MODE[mode]), new Object[0]);
            }
        } else if (player.field_71075_bZ.field_75098_d || ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
            player.func_184598_c(hand);
        }
        ArrowNockEvent event = new ArrowNockEvent(player, stack, hand, world, false);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.getAction();
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SubscribeEvent
    void blindness(LivingHurtEvent event) {
        if (event.getEntityLiving().func_130014_f_().field_72995_K) {
            return;
        }
        if (!(event.getSource().func_76364_f() instanceof EntityAdvArrow)) {
            return;
        }
        try {
            EntityAdvArrow tippedArrow = (EntityAdvArrow)event.getSource().func_76364_f();
            ItemStack stack = tippedArrow.getStack();
            boolean blindness = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BLINDNESS, stack);
            if (!blindness) {
                return;
            }
            event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60));
            tippedArrow.func_70106_y();
        }
        catch (Exception e) {
            EntityAdvArrow tippedArrow = (EntityAdvArrow)event.getSource().func_76364_f();
            tippedArrow.func_70106_y();
        }
    }

    public void func_77663_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, int itemSlot, boolean isSelected) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (!UpgradeSystem.system.hasInMap(stack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, stack));
        }
    }

    public void onUsingTick(@Nonnull ItemStack stack, @Nonnull EntityLivingBase EntityLivingBase2, int i) {
        if (!(EntityLivingBase2 instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)EntityLivingBase2;
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int mode = nbt.func_74762_e("bowMode");
        if (mode == 1) {
            int bowenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
            int j = this.func_77626_a(stack) - i;
            if (j >= 10 && ElectricItem.manager.canUse(stack, (double)CHARGE[1] - (double)CHARGE[1] * 0.1 * (double)bowenergy)) {
                player.func_184597_cx();
            }
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack is) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxenergy;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferenergy;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            if (nbt.func_74779_i("mode").equals("")) {
                return ItemEnergyBow.getModelLocation1(name + nbt.func_74779_i("mode"));
            }
            return ItemEnergyBow.getModelLocation1(name + "_" + nbt.func_74779_i("mode"));
        });
        for (String s : mode = new String[]{"", "Zelen", "Demon", "Dark", "Cold", "Ender", "Ukraine", "Fire", "Snow", "Taiga", "Desert", "Emerald"}) {
            if (!s.isEmpty()) {
                ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemEnergyBow.getModelLocation1(name + "_" + s)});
                continue;
            }
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemEnergyBow.getModelLocation1(name + s)});
        }
    }
}

