/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.tile.IWrenchable;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.componets.AbstractComponent;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.energy.ItemTreetap;
import com.denfop.proxy.CommonProxy;
import com.denfop.register.Register;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemGraviTool
extends ItemTool
implements IEnergyItem,
IModelRegister,
IUpgradeItem {
    protected static final double ROTATE = 50.0;
    protected static final double HOE = 50.0;
    protected static final double TAP = 50.0;
    protected final String name;

    public ItemGraviTool(String name) {
        super(Item.ToolMaterial.IRON, Collections.emptySet());
        this.func_77656_e(27);
        this.func_77637_a(IUCore.EnergyTab);
        this.field_77864_a = 16.0f;
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
        this.name = name;
        UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.GRAVITOOL.list);
    }

    public static GraviToolMode readToolMode(ItemStack stack) {
        return GraviToolMode.getFromID(ModUtils.nbt(stack).func_74762_e("toolMode"));
    }

    public static GraviToolMode readNextToolMode(ItemStack stack) {
        return GraviToolMode.getFromID(ModUtils.nbt(stack).func_74762_e("toolMode") + 1);
    }

    public static void saveToolMode(ItemStack stack, GraviToolMode mode) {
        ModUtils.nbt(stack).func_74768_a("toolMode", mode.ordinal());
    }

    public static boolean hasNecessaryPower(ItemStack stack, double usage, EntityPlayer player) {
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
        return ElectricItem.manager.canUse(stack, usage * coef);
    }

    protected static boolean checkNecessaryPower(ItemStack stack, double usage, EntityPlayer player) {
        return ItemGraviTool.checkNecessaryPower(stack, usage, player, false);
    }

    protected static boolean checkNecessaryPower(ItemStack stack, double usage, EntityPlayer player, boolean supressSound) {
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
        if (ElectricItem.manager.use(stack, usage * coef, (EntityLivingBase)player)) {
            if (supressSound || player.field_70170_p.field_72995_K) {
                // empty if block
            }
            return true;
        }
        CommonProxy.sendPlayerMessage(player, Localization.translate("message.text.noenergy"));
        return false;
    }

    public static boolean hasToolMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        assert (stack.func_77978_p() != null);
        return stack.func_77978_p().func_150297_b("toolMode", 4);
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.GRAVITOOL.list;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            GraviToolMode mode = ItemGraviTool.readToolMode(stack);
            return mode.model;
        });
        for (GraviToolMode mode : GraviToolMode.VALUES) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{mode.model});
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return ItemGraviTool.hasToolMode(stack) ? Localization.translate("gravisuite.graviTool.set", Localization.translate(this.func_77667_c(stack)), Localization.translate(ItemGraviTool.readToolMode((ItemStack)stack).translationName)) : Localization.translate(this.func_77667_c(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack par1ItemStack, @Nullable World worldIn, @Nonnull List<String> par3List, @Nonnull ITooltipFlag flagIn) {
        GraviToolMode mode = ItemGraviTool.readToolMode(par1ItemStack);
        par3List.add(Localization.translate("message.text.mode") + ": " + mode.colour + Localization.translate(mode.translationName));
        if (!Keyboard.isKeyDown((int)42)) {
            par3List.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            par3List.add(Localization.translate("iu.changemode_key") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.changemode.func_151463_i())) + Localization.translate("iu.changemode_rcm"));
        }
        super.func_77624_a(par1ItemStack, worldIn, par3List, flagIn);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            ItemStack stack = ModUtils.get(player, hand);
            if (world.field_72995_K) {
                player.func_184185_a(EnumSound.toolchange.getSoundEvent(), 1.0f, 1.0f);
            } else {
                GraviToolMode mode = ItemGraviTool.readNextToolMode(stack);
                ItemGraviTool.saveToolMode(stack, mode);
                CommonProxy.sendPlayerMessage(player, mode.colour + Localization.translate(mode.translationName));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        switch (ItemGraviTool.readToolMode(stack)) {
            case WRENCH: {
                return this.onWrenchUse(stack, player, world, pos, side) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            case SCREWDRIVER: {
                return this.onScrewdriverUse(stack, player, world, pos) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack4 = ModUtils.get(player, hand);
        switch (ItemGraviTool.readToolMode(stack4)) {
            case HOE: {
                return this.onHoeUse(stack4, player, world, pos, facing) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            case TREETAP: {
                return this.onTreeTapUse(stack4, player, world, pos, facing) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            case PURIFIER: {
                EntityItem item;
                Object base;
                TileEntity tile = world.func_175625_s(pos);
                ItemStack itemstack = player.func_184586_b(hand);
                if (!(tile instanceof TileEntityInventory) && !(tile instanceof IManufacturerBlock)) {
                    return EnumActionResult.PASS;
                }
                double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, player.func_184586_b(hand)) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)player.func_184586_b((EnumHand)hand)).number * 0.25 : 0.0);
                if (tile instanceof TileEntityInventory) {
                    base = (TileEntityInventory)tile;
                    double energy = 10000.0;
                    if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PURIFIER, itemstack)) {
                        energy = 0.0;
                    }
                    if (!((TileEntityBlock)((Object)base)).canEntityDestroy((Entity)player)) {
                        return EnumActionResult.FAIL;
                    }
                    for (AbstractComponent component : ((TileEntityInventory)base).getComponentList()) {
                        if (!component.canUsePurifier(player) || !ElectricItem.manager.canUse(itemstack, energy * coef)) continue;
                        component.workPurifier();
                        return EnumActionResult.SUCCESS;
                    }
                }
                if (tile instanceof TileMultiMachine) {
                    if (!ElectricItem.manager.canUse(itemstack, 500.0 * coef)) {
                        return EnumActionResult.PASS;
                    }
                    if (!player.func_70093_af()) {
                        base = (TileMultiMachine)tile;
                        ItemStack stack_quickly = ItemStack.field_190927_a;
                        ItemStack stack_modulesize = ItemStack.field_190927_a;
                        ItemStack panel = ItemStack.field_190927_a;
                        ItemStack stack_modulestorage = ItemStack.field_190927_a;
                        ItemStack module_infinity_water = ItemStack.field_190927_a;
                        ItemStack module_separate = ItemStack.field_190927_a;
                        if (((TileMultiMachine)base).multi_process.quickly) {
                            stack_quickly = new ItemStack(IUItem.module_quickly);
                        }
                        if (((TileMultiMachine)base).multi_process.modulesize) {
                            stack_modulesize = new ItemStack(IUItem.module_stack);
                        }
                        if (((TileMultiMachine)base).solartype != null) {
                            panel = new ItemStack(IUItem.module6, 1, ((TileMultiMachine)base).solartype.meta);
                        }
                        if (((TileMultiMachine)base).multi_process.modulestorage) {
                            stack_modulestorage = new ItemStack(IUItem.module_storage);
                        }
                        if (((TileMultiMachine)base).multi_process.module_infinity_water) {
                            module_infinity_water = new ItemStack(IUItem.module_infinity_water);
                        }
                        if (((TileMultiMachine)base).multi_process.module_separate) {
                            module_separate = new ItemStack(IUItem.module_separate);
                        }
                        if (stack_quickly.func_190926_b() && stack_modulesize.func_190926_b() && panel.func_190926_b() && module_infinity_water.func_190926_b() && module_separate.func_190926_b()) break;
                        EntityItem item2 = new EntityItem(world);
                        if (!stack_quickly.func_190926_b()) {
                            item2.func_92058_a(stack_quickly);
                            ((TileMultiMachine)base).multi_process.shrinkModule(1);
                            ((TileMultiMachine)base).multi_process.setQuickly(false);
                        } else if (!stack_modulesize.func_190926_b()) {
                            item2.func_92058_a(stack_modulesize);
                            ((TileMultiMachine)base).multi_process.setModulesize(false);
                            ((TileMultiMachine)base).multi_process.shrinkModule(1);
                        } else if (!module_separate.func_190926_b()) {
                            item2.func_92058_a(module_separate);
                            ((TileMultiMachine)base).multi_process.module_separate = false;
                            ((TileMultiMachine)base).multi_process.shrinkModule(1);
                        } else if (!module_infinity_water.func_190926_b()) {
                            item2.func_92058_a(module_infinity_water);
                            ((TileMultiMachine)base).multi_process.module_infinity_water = false;
                            ((TileMultiMachine)base).multi_process.shrinkModule(1);
                        } else if (!panel.func_190926_b()) {
                            item2.func_92058_a(panel);
                            ((TileMultiMachine)base).solartype = null;
                        } else if (!stack_modulestorage.func_190926_b()) {
                            item2.func_92058_a(stack_modulestorage);
                            ((TileMultiMachine)base).multi_process.setModulestorage(false);
                            ((TileMultiMachine)base).multi_process.shrinkModule(1);
                        }
                        if (player.func_130014_f_().field_72995_K) break;
                        item2.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                        item2.func_174867_a(0);
                        world.func_72838_d((Entity)item2);
                        ElectricItem.manager.use(itemstack, 500.0 * coef, (EntityLivingBase)player);
                        if (IUCore.proxy.isRendering()) {
                            player.func_184185_a(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                        }
                        return EnumActionResult.SUCCESS;
                    }
                    base = (TileMultiMachine)tile;
                    ArrayList<ItemStack> stack_list = new ArrayList<ItemStack>();
                    if (((TileMultiMachine)base).multi_process.quickly) {
                        stack_list.add(new ItemStack(IUItem.module_quickly));
                        ((TileMultiMachine)base).multi_process.setQuickly(false);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((TileMultiMachine)base).multi_process.modulesize) {
                        stack_list.add(new ItemStack(IUItem.module_stack));
                        ((TileMultiMachine)base).multi_process.setModulesize(false);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((TileMultiMachine)base).multi_process.module_separate) {
                        stack_list.add(new ItemStack(IUItem.module_separate));
                        ((TileMultiMachine)base).multi_process.module_separate = false;
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((TileMultiMachine)base).solartype != null) {
                        stack_list.add(new ItemStack(IUItem.module6, 1, ((TileMultiMachine)base).solartype.meta));
                        ((TileMultiMachine)base).solartype = null;
                    }
                    if (((TileMultiMachine)base).multi_process.modulestorage) {
                        stack_list.add(new ItemStack(IUItem.module_storage));
                        ((TileMultiMachine)base).multi_process.setModulestorage(false);
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    if (((TileMultiMachine)base).multi_process.module_infinity_water) {
                        stack_list.add(new ItemStack(IUItem.module_infinity_water));
                        ((TileMultiMachine)base).multi_process.module_infinity_water = false;
                        ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    }
                    for (ItemStack stack : stack_list) {
                        EntityItem item3 = new EntityItem(world);
                        if (player.func_130014_f_().field_72995_K) continue;
                        item3.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                        item3.func_174867_a(0);
                        item3.func_92058_a(stack);
                        world.func_72838_d((Entity)item3);
                        if (!IUCore.proxy.isRendering()) continue;
                        player.func_184185_a(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                    }
                    ElectricItem.manager.use(itemstack, 500.0 * coef, (EntityLivingBase)player);
                    return EnumActionResult.SUCCESS;
                }
                if (!(tile instanceof IManufacturerBlock)) {
                    return EnumActionResult.FAIL;
                }
                base = (IManufacturerBlock)tile;
                if (player.func_70093_af()) {
                    int level = base.getLevel();
                    if (level == 0) {
                        return EnumActionResult.PASS;
                    }
                    ItemStack stack = new ItemStack((Item)IUItem.upgrade_speed_creation, level);
                    base.setLevel(0);
                    item = new EntityItem(world);
                    item.func_92058_a(stack);
                    if (player.func_130014_f_().field_72995_K) break;
                    item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                    item.func_174867_a(0);
                    world.func_72838_d((Entity)item);
                    ElectricItem.manager.use(itemstack, 500.0, (EntityLivingBase)player);
                    if (IUCore.proxy.isRendering()) {
                        player.func_184185_a(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                    }
                    return EnumActionResult.SUCCESS;
                }
                int level = base.getLevel();
                if (level == 0) {
                    return EnumActionResult.PASS;
                }
                ItemStack stack = new ItemStack((Item)IUItem.upgrade_speed_creation, 1);
                base.removeLevel(1);
                item = new EntityItem(world);
                item.func_92058_a(stack);
                if (player.func_130014_f_().field_72995_K) break;
                item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                item.func_174867_a(0);
                world.func_72838_d((Entity)item);
                ElectricItem.manager.use(itemstack, 500.0, (EntityLivingBase)player);
                if (IUCore.proxy.isRendering()) {
                    player.func_184185_a(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    protected boolean onHoeUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (player.func_175151_a(pos.func_177972_a(side), side, stack) && ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
            UseHoeEvent event = new UseHoeEvent(player, stack, world, pos);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            if (event.getResult() == Event.Result.ALLOW) {
                return ItemGraviTool.checkNecessaryPower(stack, 50.0, player, true);
            }
            IBlockState state = world.func_180495_p(pos);
            state = state.func_185899_b((IBlockAccess)world, pos);
            Block block = state.func_177230_c();
            IBlockState state1 = world.func_180495_p(pos.func_177984_a());
            state1 = state1.func_185899_b((IBlockAccess)world, pos.func_177984_a());
            if (side != EnumFacing.DOWN && state1.func_185904_a() == Material.field_151579_a) {
                if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                    return this.setHoedBlock(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                }
                if (block == Blocks.field_150346_d) {
                    switch ((BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                        case DIRT: {
                            return this.setHoedBlock(stack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                        }
                        case COARSE_DIRT: {
                            return this.setHoedBlock(stack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        }
                    }
                }
            }
            return false;
        }
        return false;
    }

    protected boolean setHoedBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        if (ItemGraviTool.checkNecessaryPower(stack, 50.0, player, true)) {
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(pos, state, 11);
            }
            return true;
        }
        return false;
    }

    protected boolean onTreeTapUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        state = state.func_185899_b((IBlockAccess)world, pos);
        return ItemGraviTool.hasNecessaryPower(stack, 50.0, player) && (state.func_177230_c() == IUItem.rubWood && ItemTreetap.attemptExtract(player, world, pos, side, state, null) || state.func_177230_c() == IUItem.swampRubWood && ItemTreetap.attemptSwampExtract(player, world, pos, side, state, null) || state.func_177230_c() == IUItem.tropicalRubWood && ItemTreetap.attemptTropicalExtract(player, world, pos, side, state, null)) && ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
    }

    protected boolean onWrenchUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        Block block = (state = state.func_185899_b((IBlockAccess)world, pos)).func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos)) {
            return false;
        }
        if (block instanceof IWrenchable) {
            EnumFacing newFacing;
            IWrenchable wrenchable = (IWrenchable)block;
            EnumFacing current = wrenchable.getFacing(world, pos);
            if (!IUCore.keyboard.isChangeKeyDown(player)) {
                newFacing = player.func_70093_af() ? side.func_176734_d() : side;
            } else {
                EnumFacing.Axis axis = side.func_176740_k();
                newFacing = !(!player.func_70093_af() && side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE || player.func_70093_af() && side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) ? current.func_176732_a(axis).func_176732_a(axis).func_176732_a(axis) : current.func_176732_a(axis);
            }
            if (current != newFacing) {
                if (!ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
                    return false;
                }
                if (wrenchable.setFacing(world, pos, newFacing, player)) {
                    player.func_184185_a(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
                    return ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
                }
            }
            if (wrenchable.wrenchCanRemove(world, pos, player)) {
                if (!ItemGraviTool.hasNecessaryPower(stack, 50.0, player)) {
                    return false;
                }
                player.func_184185_a(EnumSound.wrench.getSoundEvent(), 1.0f, 1.0f);
                if (!world.field_72995_K) {
                    int experience;
                    TileEntity te = world.func_175625_s(pos);
                    if (player instanceof EntityPlayerMP) {
                        experience = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos);
                        if (experience < 0) {
                            return false;
                        }
                    } else {
                        experience = 0;
                    }
                    block.func_176208_a(world, pos, state, player);
                    if (!block.removedByPlayer(state, world, pos, player, true)) {
                        return false;
                    }
                    block.func_176206_d(world, pos, state);
                    int fortune = player.func_130014_f_().field_73012_v.nextInt(100);
                    if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WRENCH, stack)) {
                        fortune = 100;
                    }
                    for (ItemStack drop : wrenchable.getWrenchDrops(world, pos, state, te, player, fortune)) {
                        ModUtils.dropAsEntity(world, pos, drop);
                    }
                    wrenchable.wrenchBreak(world, pos);
                    if (!player.field_71075_bZ.field_75098_d && experience > 0) {
                        block.func_180637_b(world, pos, experience);
                    }
                }
                return ItemGraviTool.checkNecessaryPower(stack, 50.0, player);
            }
        }
        return false;
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World p_77663_2_, @Nonnull Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(p_77663_2_, this, itemStack));
        }
    }

    protected boolean onScrewdriverUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = (state = state.func_185899_b((IBlockAccess)world, pos)).func_177230_c();
        if (!block.isAir(state, (IBlockAccess)world, pos) && block instanceof BlockHorizontal && ItemGraviTool.checkNecessaryPower(stack, 500.0, player)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
            facing = player.func_70093_af() ? facing.func_176735_f() : facing.func_176746_e();
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing));
            return true;
        }
        return false;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        return false;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entityLiving) {
        return true;
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack stack, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return false;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot slot) {
        return HashMultimap.create();
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            ElectricItemManager.addChargeVariants((Item)this, items);
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return 300000.0;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return 10000.0;
    }

    public static enum GraviToolMode {
        HOE(TextFormatting.GOLD),
        TREETAP(TextFormatting.LIGHT_PURPLE),
        WRENCH(TextFormatting.AQUA),
        SCREWDRIVER(TextFormatting.YELLOW),
        PURIFIER(TextFormatting.DARK_AQUA);

        private static final GraviToolMode[] VALUES;
        public final String translationName = "iu.graviTool.snap." + this.name().toLowerCase(Locale.ENGLISH);
        public final TextFormatting colour;
        private final ModelResourceLocation model = new ModelResourceLocation("industrialupgrade:" + "gravitool/gravitool".toLowerCase(Locale.ENGLISH) + this.name().toLowerCase(Locale.ENGLISH), null);

        private GraviToolMode(TextFormatting colour) {
            this.colour = colour;
        }

        public static GraviToolMode getFromID(int ID) {
            return VALUES[ID % VALUES.length];
        }

        static {
            VALUES = GraviToolMode.values();
        }
    }
}

