/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.energy.ContainerMagnet;
import com.denfop.items.energy.ItemStackMagnet;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemMagnet
extends BaseEnergyItem
implements IItemStackInventory,
IUpdatableItemStackEvent,
IModelRegister,
IUpgradeItem {
    private final int radius;

    public ItemMagnet(String name, double maxCharge, double transferLimit, int tier, int radius) {
        super(name, maxCharge, transferLimit, tier);
        this.func_77625_d(1);
        this.radius = radius;
        IUCore.proxy.addIModelRegister(this);
        this.name = name;
        UpgradeSystem.system.addRecipe(this, EnumUpgrades.MAGNET.list);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:energy/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemMagnet.getModelLocation(name));
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.MAGNET.list;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name) {
        ItemMagnet.registerModel(this, meta, name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name, String extraName) {
        ItemMagnet.registerModel(this, meta, name);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int mode = ModUtils.NBTGetInteger(stack, "mode");
        if (mode > 2 || mode < 0) {
            mode = 0;
        }
        tooltip.add(TextFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode));
        int radius1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SIZE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SIZE, (ItemStack)stack).number : 0;
        tooltip.add(Localization.translate("iu.magnet.info") + (this.radius + radius1) + "x" + (this.radius + radius1));
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.changemode_key") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.changemode.func_151463_i())) + Localization.translate("iu.changemode_rcm"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean canInsert(ItemStack itemStack1, ItemStack itemstack, ItemStackMagnet inventory) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack1);
        boolean white = nbt.func_74767_n("white");
        boolean can = false;
        if (white) {
            for (ItemStack stack1 : inventory.list) {
                if (stack1.func_190926_b() || !stack1.func_77969_a(itemstack)) continue;
                can = true;
                break;
            }
        } else {
            for (ItemStack stack1 : inventory.list) {
                if (!stack1.func_190926_b() && stack1.func_77969_a(itemstack)) {
                    can = false;
                    break;
                }
                can = true;
            }
        }
        return can;
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World p_77663_2_, @Nonnull Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        int mode;
        if (!(p_77663_3_ instanceof EntityPlayer)) {
            return;
        }
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        EntityPlayer player = (EntityPlayer)p_77663_3_;
        if (nbt.func_74767_n("open")) {
            int slot_id = nbt.func_74762_e("slot_inventory");
            if (slot_id != p_77663_4_ && !player.func_130014_f_().field_72995_K && !ModUtils.isEmpty(itemStack) && player.field_71070_bA instanceof ContainerMagnet) {
                ItemStackMagnet toolbox = (ItemStackMagnet)((ContainerMagnet)player.field_71070_bA).base;
                if (toolbox.isThisContainer(itemStack)) {
                    toolbox.saveAsThrown(itemStack);
                    player.func_71053_j();
                    nbt.func_74757_a("open", false);
                }
            } else if (!(player.field_71070_bA instanceof ContainerMagnet)) {
                nbt.func_74757_a("open", false);
            }
        }
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(p_77663_2_, this, itemStack));
        }
        if ((mode = ModUtils.NBTGetInteger(itemStack, "mode")) != 0) {
            int radius1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SIZE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SIZE, (ItemStack)itemStack).number : 0;
            double energy = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, itemStack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)itemStack).number * 0.25 : 0.0);
            int radius = this.radius + radius1;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(p_77663_3_.field_70165_t - (double)radius, p_77663_3_.field_70163_u - (double)radius, p_77663_3_.field_70161_v - (double)radius, p_77663_3_.field_70165_t + (double)radius, p_77663_3_.field_70163_u + (double)radius, p_77663_3_.field_70161_v + (double)radius);
            List list = p_77663_2_.func_72839_b(p_77663_3_, axisalignedbb);
            if (!list.isEmpty() && !player.func_130014_f_().field_72995_K) {
                ItemStackMagnet inventory = this.getInventory(player, itemStack);
                for (Entity entityinlist : list) {
                    boolean zcoord;
                    if (!(entityinlist instanceof EntityItem)) continue;
                    EntityItem item = (EntityItem)entityinlist;
                    if (!ElectricItem.manager.canUse(itemStack, 200.0 * energy) || !this.canInsert(itemStack, ((EntityItem)entityinlist).func_92059_d(), inventory)) continue;
                    if (mode == 1) {
                        item.func_70012_b(p_77663_3_.field_70165_t, p_77663_3_.field_70163_u, p_77663_3_.field_70161_v, 0.0f, 0.0f);
                        if (!player.field_70170_p.field_72995_K) {
                            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
                        }
                        item.func_174867_a(0);
                        ElectricItem.manager.use(itemStack, 200.0 * energy, (EntityLivingBase)player);
                        continue;
                    }
                    if (mode != 2) continue;
                    boolean xcoord = item.field_70165_t + 2.0 >= p_77663_3_.field_70165_t && item.field_70165_t - 2.0 <= p_77663_3_.field_70165_t;
                    boolean bl = zcoord = item.field_70161_v + 2.0 >= p_77663_3_.field_70161_v && item.field_70161_v - 2.0 <= p_77663_3_.field_70161_v;
                    if (xcoord || zcoord) continue;
                    item.func_70107_b(p_77663_3_.field_70165_t, p_77663_3_.field_70163_u - 1.0, p_77663_3_.field_70161_v);
                    item.func_174867_a(10);
                }
            }
        }
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        if (IUCore.keyboard.isChangeKeyDown(player) && IUCore.proxy.isSimulating()) {
            int mode = ModUtils.NBTGetInteger(player.func_184586_b(hand), "mode");
            if (++mode > 2 || mode < 0) {
                mode = 0;
            }
            ModUtils.NBTSetInteger(player.func_184586_b(hand), "mode", mode);
            IUCore.proxy.messagePlayer(player, TextFormatting.GREEN + Localization.translate("message.text.mode") + ": " + Localization.translate("message.magnet.mode." + mode), new Object[0]);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (IUCore.proxy.isSimulating()) {
            this.save(player.func_184586_b(hand), player);
            player.openGui((Object)IUCore.instance, 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public void save(ItemStack stack, EntityPlayer player) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74757_a("open", true);
        nbt.func_74768_a("slot_inventory", player.field_71071_by.field_70461_c);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, EntityPlayer player) {
        ItemStackMagnet toolbox;
        if (!player.func_130014_f_().field_72995_K && !ModUtils.isEmpty(stack) && player.field_71070_bA instanceof ContainerMagnet && (toolbox = (ItemStackMagnet)((ContainerMagnet)player.field_71070_bA).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.func_71053_j();
        }
        return true;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        NBTTagCompound nbt;
        nbt.func_74757_a("white", !(nbt = ModUtils.nbt(stack)).func_74767_n("white"));
    }

    public boolean canInsert(EntityPlayer player, ItemStack stack, ItemStack stack1) {
        ItemStackMagnet box = this.getInventory(player, stack);
        return box.canAdd(stack1);
    }

    public void insert(EntityPlayer player, ItemStack stack, ItemStack stack1) {
        ItemStackMagnet box = this.getInventory(player, stack);
        box.add(stack1);
        box.func_70296_d();
    }

    public void insertWithoutSave(EntityPlayer player, ItemStack stack, ItemStack stack1) {
        ItemStackMagnet box = this.getInventory(player, stack);
        box.addWithoutSave(stack1);
    }

    @Override
    public ItemStackMagnet getInventory(EntityPlayer player, ItemStack stack) {
        return new ItemStackMagnet(player, stack, 0);
    }
}

