/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.audio.SoundHandler;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.armour.special.ItemSpecialArmor;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.network.packet.PacketStopSoundPlayer;
import com.denfop.register.Register;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;

public class ItemNanoSaber
extends ItemTool
implements IEnergyItem,
IUpgradeItem,
IModelRegister {
    public static int ticker = 0;
    public final int maxCharge;
    public final int transferLimit;
    public final int tier;
    private final String name;
    private final int damage1;
    public int activedamage;
    private int soundTicker = 0;
    private boolean wasEquipped;

    public ItemNanoSaber(String name, int maxCharge, int transferLimit, int tier, int activedamage1, int damage) {
        super(0.0f, 2.0f, Item.ToolMaterial.DIAMOND, Collections.emptySet());
        this.setHarvestLevel("sword", 0);
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.name = name;
        this.func_77656_e(0);
        this.activedamage = activedamage1;
        this.damage1 = damage;
        this.field_77864_a = 1.0f;
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77655_b(name);
        this.func_77637_a(IUCore.EnergyTab);
        Register.registerItem(this, IUCore.getIdentifier(name)).func_77655_b(name);
        IUCore.proxy.addIModelRegister(this);
        UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SABERS.list);
    }

    private static boolean isActive(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        return ItemNanoSaber.isActive(nbt);
    }

    private static boolean isActive(NBTTagCompound nbt) {
        return nbt.func_74767_n("active");
    }

    private static void setActive(NBTTagCompound nbt, boolean active) {
        nbt.func_74757_a("active", active);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation1(String name, String extraName) {
        String loc = "industrialupgrade:energy_tools/" + name + extraName;
        return new ModelResourceLocation(loc, null);
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.SABERS.list;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @javax.annotation.Nullable EntityPlayer player, @javax.annotation.Nullable IBlockState blockState) {
        int level = super.getHarvestLevel(stack, toolClass, player, blockState);
        if (level == -1 && toolClass.equals("sword")) {
            return this.field_77862_b.func_77996_d();
        }
        return level;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0);
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    public void func_150895_a(@Nonnull CreativeTabs subs, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(subs)) {
            ItemStack stack = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((Item)this, 1, 27);
            items.add((Object)itemstack);
        }
    }

    public boolean canHarvestBlock(IBlockState state, @Nonnull ItemStack itemStack) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public void drainSaber(ItemStack itemStack, double amount, EntityLivingBase entity) {
        int saberenergy;
        int n = saberenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABERENERGY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABERENERGY, (ItemStack)itemStack).number : 0;
        if (!ElectricItem.manager.use(itemStack, amount - amount * 0.15 * (double)saberenergy, entity)) {
            NBTTagCompound nbtData = ModUtils.nbt(itemStack);
            nbtData.func_74757_a("active", false);
        }
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack item, @Nonnull EntityPlayer player) {
        this.removeAudioSource();
        return true;
    }

    public float func_150893_a(@Nonnull ItemStack itemStack, @Nonnull IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot p_getAttributeModifiers_1_, @Nonnull ItemStack stack) {
        NBTTagCompound nbtData;
        if (p_getAttributeModifiers_1_ != EntityEquipmentSlot.MAINHAND) {
            return super.getAttributeModifiers(p_getAttributeModifiers_1_, stack);
        }
        int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
        int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
        if (ElectricItem.manager.canUse(stack, 400.0) && (nbtData = ModUtils.nbt(stack)).func_74767_n("active")) {
            dmg = (int)((double)this.activedamage + (double)this.activedamage * 0.15 * (double)saberdamage);
        }
        HashMultimap hashMultimap = HashMultimap.create();
        hashMultimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
        hashMultimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(Item.field_111210_e, "Tool modifier", (double)dmg, 0));
        return hashMultimap;
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase target, @Nonnull EntityLivingBase source) {
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        if (!nbtData.func_74767_n("active")) {
            return true;
        }
        if (IUCore.proxy.isSimulating()) {
            this.drainSaber(stack, 400.0, source);
            int vampires = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.VAMPIRES, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.VAMPIRES, (ItemStack)stack).number : 0;
            boolean wither = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WITHER, stack);
            boolean poison = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.POISON, stack);
            if (vampires != 0) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 40, vampires));
            }
            if (wither) {
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60));
            }
            if (poison) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.HUNGRY, stack)) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60));
            }
            if (source instanceof EntityPlayerMP) {
                new PacketSoundPlayer(this.getRandomSwingSound(), (EntityPlayer)source);
            }
            int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
            int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
            int attackMode = nbtData.func_74762_e("attackMode");
            if (ElectricItem.manager.canUse(stack, 400.0)) {
                NBTTagCompound nbtData1 = ModUtils.nbt(stack);
                if (nbtData1.func_74767_n("active")) {
                    dmg = (int)((double)this.activedamage + (double)this.activedamage * 0.15 * (double)saberdamage);
                }
                if (attackMode != 0) {
                    this.areaAttack(stack, target, source, 2, dmg);
                }
            }
            if (!(source instanceof EntityPlayerMP) || !(target instanceof EntityPlayer) || ((EntityPlayerMP)source).func_96122_a((EntityPlayer)target)) {
                Iterator var4 = Arrays.stream(EntityEquipmentSlot.values()).filter(slot -> slot != EntityEquipmentSlot.MAINHAND && slot != EntityEquipmentSlot.OFFHAND).iterator();
                while (var4.hasNext()) {
                    EntityEquipmentSlot slot2 = (EntityEquipmentSlot)var4.next();
                    if (!ElectricItem.manager.canUse(stack, 2000.0)) break;
                    ItemStack armor = target.func_184582_a(slot2);
                    if (!armor.func_190926_b()) continue;
                    double amount = 0.0;
                    if (armor.func_77973_b() instanceof ItemSpecialArmor) {
                        amount = ((ItemSpecialArmor)armor.func_77973_b()).getArmor().getDamageEnergy();
                    }
                    if (!(amount > 0.0)) continue;
                    ElectricItem.manager.discharge(armor, amount, this.tier, true, false, false);
                    if (!ElectricItem.manager.canUse(armor, 1.0)) {
                        target.func_184201_a(slot2, ItemStack.field_190927_a);
                    }
                    this.drainSaber(stack, 2000.0, source);
                }
            }
        }
        return true;
    }

    private void areaAttack(ItemStack stack, EntityLivingBase target, EntityLivingBase source, int radius, double damage) {
        List entities = source.field_70170_p.func_72872_a(EntityLivingBase.class, source.func_174813_aQ().func_186662_g((double)radius));
        for (EntityLivingBase entity : entities) {
            if (entity == source || entity == target) continue;
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)source)), (float)damage);
        }
    }

    public String getRandomSwingSound() {
        switch (IUCore.random.nextInt(3)) {
            default: {
                return "nanosabreswing1";
            }
            case 1: {
                return "nanosabreswing2";
            }
            case 2: 
        }
        return "nanosabreswing3";
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        if (ItemNanoSaber.isActive(stack)) {
            this.drainSaber(stack, 80.0, (EntityLivingBase)player);
        }
        return false;
    }

    public boolean func_77662_d() {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (!IUCore.keyboard.isChangeKeyDown(player)) {
            if (ItemNanoSaber.isActive(nbt)) {
                ItemNanoSaber.setActive(nbt, false);
                new PacketStopSoundPlayer(EnumSound.NanosabreIdle, player);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (ElectricItem.manager.canUse(stack, 16.0)) {
                ItemNanoSaber.setActive(nbt, true);
                new PacketSoundPlayer(this.getStartSound(), player);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            return super.func_77659_a(world, player, hand);
        }
        int mode = nbt.func_74762_e("attackMode");
        if (mode == 0) {
            nbt.func_74768_a("attackMode", 1);
        } else {
            nbt.func_74768_a("attackMode", 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate("iu.changemode_key") + Keyboard.getKeyName((int)Math.abs(KeyboardClient.changemode.func_151463_i())) + Localization.translate("iu.changemode_rcm"));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    protected String getIdleSound() {
        return "NanosabreIdle".toLowerCase();
    }

    protected String getStartSound() {
        return "NanosabrePowerup".toLowerCase();
    }

    protected void removeAudioSource() {
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean par5) {
        NBTTagCompound nbtData;
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
        if (IUCore.proxy.isRendering() && ItemNanoSaber.isActive(itemStack) && world.field_73011_w.getWorldTime() % 20L == 0L) {
            SoundHandler.playSound(IUCore.proxy.getPlayerInstance(), this.getIdleSound());
        }
        if (!(nbtData = ModUtils.nbt(itemStack)).func_74767_n("active")) {
            return;
        }
        if (ticker % 16 == 0 && entity instanceof EntityPlayerMP) {
            if (slot < 9) {
                this.drainSaber(itemStack, 64.0, (EntityLivingBase)entity);
            } else if (ticker % 64 == 0) {
                this.drainSaber(itemStack, 16.0, (EntityLivingBase)entity);
            }
        }
    }

    @Nonnull
    public String func_77658_a() {
        return "iu" + super.func_77658_a().substring(4);
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack itemStack) {
        return this.func_77658_a();
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack itemStack) {
        return Localization.translate(this.func_77667_c(itemStack));
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        String[] mode;
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            NBTTagCompound nbt = ModUtils.nbt(stack);
            return ItemNanoSaber.getModelLocation1(name, nbt.func_74767_n("active") ? "_active" : "_off");
        });
        for (String s : mode = new String[]{"_off", "_active"}) {
            ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ItemNanoSaber.getModelLocation1(name, s)});
        }
    }
}

