/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.IModelRegister;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.componets.AbstractComponent;
import com.denfop.items.BaseEnergyItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.tiles.base.IManufacturerBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileMultiMachine;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPurifier
extends BaseEnergyItem
implements IModelRegister,
IUpgradeItem {
    public ItemPurifier(String name, double maxCharge, double transferLimit, int tier) {
        super(name, maxCharge, transferLimit, tier);
        this.func_77625_d(1);
        IUCore.proxy.addIModelRegister(this);
        UpgradeSystem.system.addRecipe(this, EnumUpgrades.PURIFIER.list);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:energy/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemPurifier.getModelLocation(name));
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.PURIFIER.list;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name) {
        ItemPurifier.registerModel(this, meta, name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name, String extraName) {
        ItemPurifier.registerModel(this, meta, name);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World p_77663_2_, @Nonnull Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(p_77663_2_, this, itemStack));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        EntityItem item;
        Object base;
        TileEntity tile = world.func_175625_s(pos);
        ItemStack itemstack = player.func_184586_b(hand);
        if (!(tile instanceof TileEntityInventory) && !(tile instanceof IManufacturerBlock)) {
            return EnumActionResult.PASS;
        }
        double coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, player.func_184586_b(hand)) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)player.func_184586_b((EnumHand)hand)).number * 0.25 : 0.0);
        if (tile instanceof TileEntityBlock) {
            base = (TileEntityBlock)tile;
            double energy = 10000.0;
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.PURIFIER, itemstack)) {
                energy = 0.0;
            }
            if (!((TileEntityBlock)((Object)base)).canEntityDestroy((Entity)player)) {
                return EnumActionResult.FAIL;
            }
            for (AbstractComponent component : ((TileEntityBlock)((Object)base)).getComponentList()) {
                if (!component.canUsePurifier(player) || !ElectricItem.manager.canUse(itemstack, energy * coef)) continue;
                component.workPurifier();
                return EnumActionResult.SUCCESS;
            }
        }
        if (tile instanceof TileMultiMachine) {
            if (!ElectricItem.manager.canUse(itemstack, 500.0 * coef)) {
                return EnumActionResult.PASS;
            }
            if (!player.func_70093_af()) {
                base = (TileMultiMachine)tile;
                ItemStack stack_quickly = ItemStack.field_190927_a;
                ItemStack stack_modulesize = ItemStack.field_190927_a;
                ItemStack stack_modulestorage = ItemStack.field_190927_a;
                ItemStack panel = ItemStack.field_190927_a;
                ItemStack module_infinity_water = ItemStack.field_190927_a;
                ItemStack module_separate = ItemStack.field_190927_a;
                if (((TileMultiMachine)base).multi_process.quickly) {
                    stack_quickly = new ItemStack(IUItem.module_quickly);
                }
                if (((TileMultiMachine)base).multi_process.modulesize) {
                    stack_modulesize = new ItemStack(IUItem.module_stack);
                }
                if (((TileMultiMachine)base).multi_process.modulestorage) {
                    stack_modulestorage = new ItemStack(IUItem.module_storage);
                }
                if (((TileMultiMachine)base).multi_process.modulestorage) {
                    module_infinity_water = new ItemStack(IUItem.module_infinity_water);
                }
                if (((TileMultiMachine)base).multi_process.module_separate) {
                    module_separate = new ItemStack(IUItem.module_separate);
                }
                if (((TileMultiMachine)base).solartype != null) {
                    panel = new ItemStack(IUItem.module6, 1, ((TileMultiMachine)base).solartype.meta);
                }
                if (stack_quickly.func_190926_b() && stack_modulesize.func_190926_b() && panel.func_190926_b() && module_infinity_water.func_190926_b() && module_separate.func_190926_b()) return EnumActionResult.PASS;
                EntityItem item2 = new EntityItem(world);
                if (!stack_quickly.func_190926_b()) {
                    item2.func_92058_a(stack_quickly);
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                    ((TileMultiMachine)base).multi_process.setQuickly(false);
                } else if (!stack_modulesize.func_190926_b()) {
                    item2.func_92058_a(stack_modulesize);
                    ((TileMultiMachine)base).multi_process.setModulesize(false);
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                } else if (!module_infinity_water.func_190926_b()) {
                    item2.func_92058_a(module_infinity_water);
                    ((TileMultiMachine)base).multi_process.module_infinity_water = false;
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                } else if (!module_separate.func_190926_b()) {
                    item2.func_92058_a(module_separate);
                    ((TileMultiMachine)base).multi_process.module_separate = false;
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                } else if (!panel.func_190926_b()) {
                    item2.func_92058_a(panel);
                    ((TileMultiMachine)base).solartype = null;
                } else if (!stack_modulestorage.func_190926_b()) {
                    item2.func_92058_a(stack_modulestorage);
                    ((TileMultiMachine)base).multi_process.setModulestorage(false);
                    ((TileMultiMachine)base).multi_process.shrinkModule(1);
                }
                if (player.func_130014_f_().field_72995_K) return EnumActionResult.PASS;
                item2.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                item2.func_174867_a(0);
                world.func_72838_d((Entity)item2);
                ElectricItem.manager.use(itemstack, 500.0 * coef, (EntityLivingBase)player);
                if (!IUCore.proxy.isRendering()) return EnumActionResult.SUCCESS;
                player.func_184185_a(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
                return EnumActionResult.SUCCESS;
            }
            base = (TileMultiMachine)tile;
            ArrayList<ItemStack> stack_list = new ArrayList<ItemStack>();
            if (((TileMultiMachine)base).multi_process.quickly) {
                stack_list.add(new ItemStack(IUItem.module_quickly));
                ((TileMultiMachine)base).multi_process.setQuickly(false);
                ((TileMultiMachine)base).multi_process.shrinkModule(1);
            }
            if (((TileMultiMachine)base).multi_process.modulesize) {
                stack_list.add(new ItemStack(IUItem.module_stack));
                ((TileMultiMachine)base).multi_process.setModulesize(false);
                ((TileMultiMachine)base).multi_process.shrinkModule(1);
            }
            if (((TileMultiMachine)base).solartype != null) {
                stack_list.add(new ItemStack(IUItem.module6, 1, ((TileMultiMachine)base).solartype.meta));
                ((TileMultiMachine)base).solartype = null;
            }
            if (((TileMultiMachine)base).multi_process.modulestorage) {
                stack_list.add(new ItemStack(IUItem.module_storage));
                ((TileMultiMachine)base).multi_process.setModulestorage(false);
                ((TileMultiMachine)base).multi_process.shrinkModule(1);
            }
            if (((TileMultiMachine)base).multi_process.module_infinity_water) {
                stack_list.add(new ItemStack(IUItem.module_infinity_water));
                ((TileMultiMachine)base).multi_process.module_infinity_water = false;
                ((TileMultiMachine)base).multi_process.shrinkModule(1);
            }
            if (((TileMultiMachine)base).multi_process.module_separate) {
                stack_list.add(new ItemStack(IUItem.module_separate));
                ((TileMultiMachine)base).multi_process.module_separate = false;
                ((TileMultiMachine)base).multi_process.shrinkModule(1);
            }
            for (ItemStack stack : stack_list) {
                EntityItem item3 = new EntityItem(world);
                if (!player.func_130014_f_().field_72995_K) {
                    item3.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                    item3.func_174867_a(0);
                    item3.func_92058_a(stack);
                    world.func_72838_d((Entity)item3);
                }
                if (!IUCore.proxy.isRendering()) continue;
                player.func_184185_a(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
            }
            ElectricItem.manager.use(itemstack, 500.0 * coef, (EntityLivingBase)player);
            return EnumActionResult.SUCCESS;
        }
        if (!(tile instanceof IManufacturerBlock)) return EnumActionResult.PASS;
        base = (IManufacturerBlock)tile;
        if (player.func_70093_af()) {
            int level = base.getLevel();
            if (level == 0) {
                return EnumActionResult.PASS;
            }
            ItemStack stack = new ItemStack((Item)IUItem.upgrade_speed_creation, level);
            base.setLevel(0);
            item = new EntityItem(world);
            item.func_92058_a(stack);
            if (player.func_130014_f_().field_72995_K) return EnumActionResult.PASS;
            item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
            item.func_174867_a(0);
            world.func_72838_d((Entity)item);
            ElectricItem.manager.use(itemstack, 500.0, (EntityLivingBase)player);
            if (!IUCore.proxy.isRendering()) return EnumActionResult.SUCCESS;
            player.func_184185_a(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        int level = base.getLevel();
        if (level == 0) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = new ItemStack((Item)IUItem.upgrade_speed_creation, 1);
        base.removeLevel(1);
        item = new EntityItem(world);
        item.func_92058_a(stack);
        if (player.func_130014_f_().field_72995_K) return EnumActionResult.PASS;
        item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
        item.func_174867_a(0);
        world.func_72838_d((Entity)item);
        ElectricItem.manager.use(itemstack, 500.0, (EntityLivingBase)player);
        if (!IUCore.proxy.isRendering()) return EnumActionResult.SUCCESS;
        player.func_184185_a(EnumSound.purifier.getSoundEvent(), 1.0f, 1.0f);
        return EnumActionResult.SUCCESS;
    }
}

