/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.BlockFoam;
import com.denfop.blocks.FluidName;
import com.denfop.items.ItemFluidContainer;
import com.denfop.utils.ModUtils;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSprayer
extends ItemFluidContainer {
    public ItemSprayer() {
        super("foam_sprayer", 8000);
        this.func_77625_d(1);
    }

    private static boolean canPlaceFoam(World world, BlockPos pos, Target target) {
        if (Objects.requireNonNull(target) == Target.Any) {
            return IUItem.foam.func_176198_a(world, pos, EnumFacing.DOWN);
        }
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("item.", "iu.").replace(".name", ""));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            subItems.add((Object)this.getItemStack(FluidName.fluidconstruction_foam));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:tools/foam_sprayer", null));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (IUCore.proxy.isSimulating() && IUCore.keyboard.isChangeKeyDown(player)) {
            ItemStack stack = ModUtils.get(player, hand);
            NBTTagCompound nbtData = ModUtils.nbt(stack);
            int mode = nbtData.func_74762_e("mode");
            mode = mode == 0 ? 1 : 0;
            nbtData.func_74768_a("mode", mode);
            String sMode = mode == 0 ? "iu.tooltip.mode.normal" : "iu.tooltip.mode.single";
            IUCore.proxy.messagePlayer(player, "iu.tooltip.mode", sMode);
        }
        return super.func_77659_a(world, player, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        Target target;
        if (!IUCore.proxy.isSimulating()) {
            return EnumActionResult.SUCCESS;
        }
        int maxFoamBlocks = 0;
        ItemStack stack = ModUtils.get(player, hand);
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid != null && fluid.amount > 0) {
            maxFoamBlocks += fluid.amount / this.getFluidPerFoam();
        }
        if (maxFoamBlocks == 0) {
            return EnumActionResult.FAIL;
        }
        maxFoamBlocks = Math.min(maxFoamBlocks, this.getMaxFoamBlocks(stack));
        if (ItemSprayer.canPlaceFoam(world, pos, Target.Scaffold)) {
            target = Target.Scaffold;
        } else {
            pos = pos.func_177972_a(side);
            target = Target.Any;
        }
        Vec3d viewVec = player.func_70040_Z();
        EnumFacing playerViewFacing = EnumFacing.func_176737_a((float)((float)viewVec.field_72450_a), (float)((float)viewVec.field_72448_b), (float)((float)viewVec.field_72449_c));
        int amount = this.sprayFoam(world, pos, playerViewFacing.func_176734_d(), target, maxFoamBlocks);
        if ((amount *= this.getFluidPerFoam()) > 0) {
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
            assert (handler != null);
            handler.drain(amount, true);
            player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)handler.getContainer());
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public int sprayFoam(World world, BlockPos pos, EnumFacing excludedDir, Target target, int maxFoamBlocks) {
        BlockPos cPos;
        if (!ItemSprayer.canPlaceFoam(world, pos, target)) {
            return 0;
        }
        ArrayDeque<BlockPos> toCheck = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        toCheck.add(pos);
        while ((cPos = (BlockPos)toCheck.poll()) != null && positions.size() < maxFoamBlocks) {
            EnumFacing[] var9;
            if (!ItemSprayer.canPlaceFoam(world, cPos, target) || !positions.add(cPos)) continue;
            for (EnumFacing dir : var9 = EnumFacing.field_82609_l) {
                if (dir == excludedDir) continue;
                toCheck.add(cPos.func_177972_a(dir));
            }
        }
        toCheck.clear();
        int failedPlacements = 0;
        for (BlockPos targetPos : positions) {
            if (world.func_175656_a(targetPos, IUItem.foam.getState(BlockFoam.FoamType.reinforced))) continue;
            ++failedPlacements;
        }
        return positions.size() - failedPlacements;
    }

    protected int getMaxFoamBlocks(ItemStack stack) {
        NBTTagCompound nbtData = ModUtils.nbt(stack);
        return nbtData.func_74762_e("mode") == 0 ? 10 : 1;
    }

    protected int getFluidPerFoam() {
        return 100;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return fluid == FluidName.fluidconstruction_foam.getInstance();
    }

    private static enum Target {
        Any,
        Scaffold;

    }
}

