/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.container.ContainerBase;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.energy.ContainerMagnet;
import com.denfop.items.energy.GuiMagnet;
import com.denfop.items.energy.ItemMagnet;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStackMagnet
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    public final ItemStack[] list;

    public ItemStackMagnet(EntityPlayer player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        this.inventorySize = inventorySize;
        this.list = new ItemStack[9];
        Arrays.fill(this.list, ItemStack.field_190927_a);
        if (IUCore.proxy.isSimulating()) {
            NBTTagCompound nbt = ModUtils.nbt(this.containerStack);
            NBTTagList contentList = nbt.func_150295_c("Items1", 10);
            for (int i = 0; i < contentList.func_74745_c(); ++i) {
                NBTTagCompound slotNbt = contentList.func_150305_b(i);
                byte slot = slotNbt.func_74771_c("Slot");
                if (slot < 0 || slot >= this.list.length) continue;
                this.list[slot] = new ItemStack(slotNbt);
            }
        }
        this.itemStack1 = stack;
        this.updatelist();
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return slot >= this.inventorySize ? this.list[slot - this.inventorySize] : this.inventory[slot];
    }

    @Override
    public ItemStack func_70298_a(int index, int amount) {
        ItemStack stack;
        if (index < this.inventory.length) {
            ItemStack stack2;
            if (index >= 0 && !ModUtils.isEmpty(stack2 = this.inventory[index])) {
                ItemStack ret;
                if (amount >= ModUtils.getSize(stack2)) {
                    ret = stack2;
                    this.inventory[index] = ModUtils.emptyStack;
                } else {
                    ret = ModUtils.setSize(stack2, amount);
                    this.inventory[index] = ModUtils.decSize(stack2, amount);
                }
                this.save();
                return ret;
            }
            return ModUtils.emptyStack;
        }
        if (index - this.inventory.length < this.list.length && !ModUtils.isEmpty(stack = this.list[index - this.inventory.length])) {
            ItemStack ret;
            if (amount >= ModUtils.getSize(stack)) {
                ret = stack;
                this.list[index - this.inventory.length] = ModUtils.emptyStack;
            } else {
                ret = ModUtils.setSize(stack, amount);
                this.list[index - this.inventory.length] = ModUtils.decSize(stack, amount);
            }
            this.save();
            return ret;
        }
        return ModUtils.emptyStack;
    }

    @Override
    protected void save() {
        super.save();
        if (IUCore.proxy.isSimulating() && !this.cleared) {
            int idx;
            boolean dropItself = false;
            for (int i = 0; i < this.list.length; ++i) {
                if (!this.isThisContainer(this.list[i])) continue;
                this.list[i] = null;
                dropItself = true;
            }
            NBTTagList contentList = new NBTTagList();
            for (idx = 0; idx < this.list.length; ++idx) {
                if (ModUtils.isEmpty(this.list[idx])) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74774_a("Slot", (byte)idx);
                this.list[idx].func_77955_b(nbt);
                contentList.func_74742_a((NBTBase)nbt);
            }
            ModUtils.nbt(this.containerStack).func_74782_a("Items1", (NBTBase)contentList);
            this.containerStack = ModUtils.setSize(this.containerStack, 1);
            if (dropItself) {
                ModUtils.dropAsEntity(this.player.func_130014_f_(), this.player.func_180425_c(), this.containerStack);
                this.func_174888_l();
            } else {
                idx = this.getPlayerInventoryIndex();
                if (idx < -1) {
                    this.func_174888_l();
                } else if (idx == -1) {
                    this.player.field_71071_by.func_70437_b(this.containerStack);
                } else {
                    this.player.field_71071_by.func_70299_a(idx, this.containerStack);
                }
            }
        }
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public ContainerBase<ItemStackMagnet> getGuiContainer(EntityPlayer player) {
        return new ContainerMagnet(player, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return new GuiMagnet(new ContainerMagnet(player, this), this.itemStack1);
    }

    public TileEntityInventory getParent() {
        return null;
    }

    @Override
    public void addInventorySlot(InvSlot var1) {
    }

    @Override
    public int getBaseIndex(InvSlot var1) {
        return 0;
    }

    @Nonnull
    public String func_70005_c_() {
        return "toolbox";
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < this.inventory.length) {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.func_70297_j_()) {
                stack = ModUtils.setSize(stack, this.func_70297_j_());
            }
            this.inventory[slot] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        } else {
            if (!ModUtils.isEmpty(stack) && ModUtils.getSize(stack) > this.func_70297_j_()) {
                stack = ModUtils.setSize(stack, this.func_70297_j_());
            }
            this.list[slot - this.inventory.length] = ModUtils.isEmpty(stack) ? ModUtils.emptyStack : stack;
        }
        this.updatelist();
        this.save();
    }

    private void updatelist() {
    }

    public ItemStack get(int index) {
        return this.inventory[index];
    }

    public ItemStack[] getAll() {
        return this.inventory;
    }

    public void put(ItemStack content) {
        this.put(0, content);
    }

    public void put(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
        this.save();
    }

    public void putWithoutSave(int index, ItemStack content) {
        if (ModUtils.isEmpty(content)) {
            content = ModUtils.emptyStack;
        }
        this.inventory[index] = content;
    }

    private boolean add(List<ItemStack> stacks, boolean simulate) {
        NBTTagCompound nbt = ModUtils.nbt(this.itemStack1);
        boolean white = nbt.func_74767_n("white");
        if (stacks != null && !stacks.isEmpty()) {
            for (ItemStack stack : stacks) {
                boolean can = false;
                if (white) {
                    for (ItemStack stack1 : this.list) {
                        if (stack1.func_190926_b() || !stack1.func_77969_a(stack)) continue;
                        can = true;
                        break;
                    }
                } else {
                    for (ItemStack stack1 : this.list) {
                        if (!stack1.func_190926_b() && stack1.func_77969_a(stack)) {
                            can = false;
                            break;
                        }
                        can = true;
                    }
                }
                if (!can) {
                    return false;
                }
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.get(i) == null || this.get(i).func_190926_b()) {
                        if (!simulate) {
                            this.put(i, stack.func_77946_l());
                            stack.func_190920_e(0);
                        }
                        return true;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                            stack.func_190920_e(0);
                        }
                        return true;
                    }
                    if (stack.func_77978_p() == null || !stack.func_77978_p().equals((Object)this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                        stack.func_190920_e(0);
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean addWithoutSave(List<ItemStack> stacks, boolean simulate) {
        if (stacks != null && !stacks.isEmpty()) {
            NBTTagCompound nbt = ModUtils.nbt(this.itemStack1);
            boolean white = nbt.func_74767_n("white");
            for (ItemStack stack : stacks) {
                boolean can = false;
                if (white) {
                    for (ItemStack stack1 : this.list) {
                        if (stack1.func_190926_b() || !stack1.func_77969_a(stack)) continue;
                        can = true;
                        break;
                    }
                } else {
                    for (ItemStack stack1 : this.list) {
                        if (!stack1.func_190926_b() && stack1.func_77969_a(stack)) {
                            can = false;
                            break;
                        }
                        can = true;
                    }
                }
                if (!can) {
                    return false;
                }
                for (int i = 0; i < this.inventory.length; ++i) {
                    if (this.get(i) == null || this.get(i).func_190926_b()) {
                        if (!simulate) {
                            this.putWithoutSave(i, stack.func_77946_l());
                            stack.func_190920_e(0);
                        }
                        return true;
                    }
                    if (!this.get(i).func_77969_a(stack) || this.get(i).func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                    if (stack.func_77978_p() == null && this.get(i).func_77978_p() == null) {
                        if (!simulate) {
                            this.get(i).func_190917_f(stack.func_190916_E());
                            stack.func_190920_e(0);
                        }
                        return true;
                    }
                    if (stack.func_77978_p() == null || !stack.func_77978_p().equals((Object)this.get(i).func_77978_p())) continue;
                    if (!simulate) {
                        this.get(i).func_190917_f(stack.func_190916_E());
                        stack.func_190920_e(0);
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean add(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), false);
    }

    public boolean addWithoutSave(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.addWithoutSave(Collections.singletonList(stack), false);
    }

    public boolean canAdd(ItemStack stack) {
        if (stack == null) {
            throw new NullPointerException("null ItemStack");
        }
        return this.add(Collections.singletonList(stack), true);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack.func_77973_b() instanceof ItemMagnet) {
            return false;
        }
        return !itemstack.func_190926_b();
    }
}

