/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.items.energy.ItemToolIU;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.ModUtils;
import com.denfop.utils.RetraceDiggingUtils;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemSteelHammer
extends ItemToolIU {
    private final HashSet<IBlockState> blocks;

    public ItemSteelHammer() {
        super("steel_hammer", 2.0f, 8.0f, new HashSet<Block>());
        this.field_77864_a = 8.0f;
        this.setHarvestLevel("pickaxe", 3);
        this.func_77656_e(Item.ToolMaterial.IRON.func_77997_a() * 3);
        this.blocks = Sets.newHashSet((Object[])new IBlockState[]{Blocks.field_150347_e.func_176223_P(), Blocks.field_150334_T.func_176223_P(), Blocks.field_150333_U.func_176223_P(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150322_A.func_176223_P(), Blocks.field_150341_Y.func_176223_P(), Blocks.field_150366_p.func_176223_P(), Blocks.field_150339_S.func_176223_P(), Blocks.field_150365_q.func_176223_P(), Blocks.field_150340_R.func_176223_P(), Blocks.field_150352_o.func_176223_P(), Blocks.field_150482_ag.func_176223_P(), Blocks.field_150484_ah.func_176223_P(), Blocks.field_150432_aD.func_176223_P(), Blocks.field_150424_aL.func_176223_P(), Blocks.field_150369_x.func_176223_P(), Blocks.field_150368_y.func_176223_P(), Blocks.field_150450_ax.func_176223_P(), Blocks.field_150439_ay.func_176223_P(), Blocks.field_150448_aq.func_176223_P(), Blocks.field_150319_E.func_176223_P(), Blocks.field_150318_D.func_176223_P(), Blocks.field_150408_cc.func_176223_P(), Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150351_n.func_176223_P(), Blocks.field_150431_aC.func_176223_P(), Blocks.field_150433_aE.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), Blocks.field_150391_bh.func_176223_P()});
    }

    public boolean onBlockStartBreak(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        World world = player.func_130014_f_();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        RayTraceResult mop = RetraceDiggingUtils.retrace(player);
        if (block.equals(Blocks.field_150350_a)) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        byte aoe = 0;
        if (player.func_70093_af() && !mop.field_72313_a.equals((Object)RayTraceResult.Type.MISS)) {
            return this.break_block(world, block, mop, aoe, player, pos, stack);
        }
        return this.break_block(world, block, mop, (byte)(1 + aoe), player, pos, stack);
    }

    private int getExperience(IBlockState state, World world, BlockPos pos_block, int fortune, ItemStack stack, Block localBlock) {
        int col = localBlock.getExpDrop(state, (IBlockAccess)world, pos_block, fortune);
        return col;
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        Block block = state.func_177230_c();
        if (block.equals(Blocks.field_150350_a)) {
            return false;
        }
        if (state.func_185904_a() instanceof MaterialLiquid || state.func_185887_b(world, pos) == -1.0f && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!world.field_72995_K) {
            if (ForgeHooks.onBlockBreakEvent((World)world, (GameType)world.func_72912_H().func_76077_q(), (EntityPlayerMP)((EntityPlayerMP)entity), (BlockPos)pos) == -1) {
                return false;
            }
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)((EntityPlayerMP)entity), true)) {
                block.func_176206_d(world, pos, state);
                block.func_180657_a(world, (EntityPlayer)((EntityPlayerMP)entity), pos, state, null, stack);
                NBTTagCompound nbt = ModUtils.nbt(stack);
                List items = entity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)));
                ((EntityPlayerMP)entity).func_71020_j(-0.025f);
                if (ModUtils.getore(block, block.func_176201_c(state))) {
                    for (EntityItem item : items) {
                        if (entity.func_130014_f_().field_72995_K) continue;
                        ItemStack stack1 = item.func_92059_d();
                        item.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0f, 0.0f);
                        item.func_174867_a(0);
                        ((EntityPlayerMP)entity).field_71135_a.func_147359_a((Packet)new SPacketEntityTeleport((Entity)item));
                    }
                } else if (nbt.func_74767_n("black")) {
                    for (EntityItem item : items) {
                        if (entity.func_130014_f_().field_72995_K) continue;
                        item.func_70106_y();
                    }
                }
            }
            EntityPlayerMP mpPlayer = (EntityPlayerMP)entity;
            mpPlayer.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, (EntityPlayer)entity, true)) {
                block.func_176206_d(world, pos, state);
            }
            Objects.requireNonNull(Minecraft.func_71410_x().func_147114_u()).func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }

    boolean break_block(World world, Block block, RayTraceResult mop, byte mode_item, EntityPlayer player, BlockPos pos, ItemStack stack) {
        byte xRange = mode_item;
        byte yRange = mode_item;
        byte zRange = mode_item;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        byte dig_depth = 0;
        switch (mop.field_178784_b.ordinal()) {
            case 0: 
            case 1: {
                yRange = dig_depth;
                break;
            }
            case 2: 
            case 3: {
                zRange = dig_depth;
                break;
            }
            case 4: 
            case 5: {
                xRange = dig_depth;
            }
        }
        boolean silktouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        fortune = Math.min(3, fortune);
        int Yy = yRange > 0 ? yRange - 1 : 0;
        stack.func_77972_a(1, (EntityLivingBase)player);
        if (!player.field_71075_bZ.field_75098_d) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                for (int yPos = y - yRange + Yy; yPos <= y + yRange + Yy; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange && stack.func_77952_i() > 0; ++zPos) {
                        BlockPos pos_block = new BlockPos(xPos, yPos, zPos);
                        IBlockState state = world.func_180495_p(pos_block);
                        Block localBlock = state.func_177230_c();
                        if (localBlock.equals(Blocks.field_150350_a) || !this.canHarvestBlock(state, stack) || !(state.func_185887_b(world, pos_block) >= 0.0f)) continue;
                        if (state.func_185887_b(world, pos_block) > 0.0f) {
                            this.func_179218_a(stack, world, state, pos_block, (EntityLivingBase)player);
                        }
                        if (silktouch) continue;
                        ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, fortune, stack, localBlock));
                    }
                }
            }
        } else if (stack.func_77952_i() > 0) {
            IBlockState state = world.func_180495_p(pos);
            Block localBlock = state.func_177230_c();
            if (!localBlock.equals(Blocks.field_150350_a) && this.canHarvestBlock(state, stack) && state.func_185887_b(world, pos) >= 0.0f || block == Blocks.field_150418_aU) {
                if (state.func_185887_b(world, pos) >= 0.0f) {
                    this.func_179218_a(stack, world, state, pos, (EntityLivingBase)player);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, fortune, stack, localBlock));
                }
            } else if (state.func_185887_b(world, pos) >= 0.0f) {
                return this.func_179218_a(stack, world, state, pos, (EntityLivingBase)player);
            }
        }
        return true;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return this.field_77864_a;
        }
        return this.blocks.contains(state) ? this.field_77864_a : 1.0f;
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }
}

