/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.IModelRegister;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockRubWood;
import com.denfop.blocks.BlockSwampRubWood;
import com.denfop.blocks.BlockTropicalRubWood;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.energy.ItemGraviTool;
import com.denfop.register.Register;
import com.denfop.utils.DamageHandler;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTreetap
extends Item
implements IModelRegister {
    private final String name;

    public ItemTreetap() {
        this.func_77625_d(1);
        this.func_77656_e(16);
        this.func_77637_a(IUCore.EnergyTab);
        this.name = "treetap";
        IUCore.proxy.addIModelRegister(this);
        Register.registerItem(this, IUCore.getIdentifier(this.name)).func_77655_b(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:tools/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemTreetap.getModelLocation(name));
    }

    public static boolean attemptExtract(EntityPlayer player, World world, BlockPos pos, EnumFacing side, IBlockState state, List<ItemStack> stacks) {
        BlockRubWood.RubberWoodState rwState;
        assert (state.func_177230_c() == IUItem.rubWood);
        boolean max = false;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_77973_b() instanceof ItemGraviTool) {
            max = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.LATEX, stack);
        }
        if (!(rwState = (BlockRubWood.RubberWoodState)((Object)state.func_177229_b(BlockRubWood.stateProperty))).isPlain() && rwState.facing == side) {
            if (rwState.wet) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, state.func_177226_a(BlockRubWood.stateProperty, (Comparable)((Object)rwState.getDry())));
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, !max ? world.field_73012_v.nextInt(3) + 1 : 4);
                    }
                }
                if (world.field_72995_K && player != null) {
                    player.func_184185_a(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.field_72995_K && world.field_73012_v.nextInt(5) == 0) {
                world.func_175656_a(pos, state.func_177226_a(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)));
            }
            if (world.field_73012_v.nextInt(5) == 0) {
                if (!world.field_72995_K) {
                    ItemTreetap.ejectResin(world, pos, side, 1);
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, 1);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean attemptSwampExtract(EntityPlayer player, World world, BlockPos pos, EnumFacing side, IBlockState state, List<ItemStack> stacks) {
        assert (state.func_177230_c() == IUItem.swampRubWood);
        BlockSwampRubWood.RubberWoodState rwState = (BlockSwampRubWood.RubberWoodState)((Object)state.func_177229_b(BlockSwampRubWood.stateProperty));
        boolean max = false;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_77973_b() instanceof ItemGraviTool) {
            max = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.LATEX, stack);
        }
        if (!rwState.isPlain() && rwState.facing == side) {
            if (rwState.wet) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, state.func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)rwState.getDry())));
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, !max ? world.field_73012_v.nextInt(3) + 1 : 4);
                    }
                }
                if (world.field_72995_K && player != null) {
                    player.func_184185_a(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.field_72995_K && world.field_73012_v.nextInt(5) == 0) {
                world.func_175656_a(pos, state.func_177226_a(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)));
            }
            if (world.field_73012_v.nextInt(5) == 0) {
                if (!world.field_72995_K) {
                    ItemTreetap.ejectResin(world, pos, side, 1);
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, 1);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean attemptTropicalExtract(EntityPlayer player, World world, BlockPos pos, EnumFacing side, IBlockState state, List<ItemStack> stacks) {
        BlockTropicalRubWood.RubberWoodState rwState;
        assert (state.func_177230_c() == IUItem.tropicalRubWood);
        boolean max = false;
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_77973_b() instanceof ItemGraviTool) {
            max = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.LATEX, stack);
        }
        if (!(rwState = (BlockTropicalRubWood.RubberWoodState)((Object)state.func_177229_b(BlockTropicalRubWood.stateProperty))).isPlain() && rwState.facing == side) {
            if (rwState.wet) {
                if (!world.field_72995_K) {
                    world.func_175656_a(pos, state.func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rwState.getDry())));
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, !max ? world.field_73012_v.nextInt(3) + 1 : 4);
                    }
                }
                if (world.field_72995_K && player != null) {
                    player.func_184185_a(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.field_72995_K && world.field_73012_v.nextInt(5) == 0) {
                world.func_175656_a(pos, state.func_177226_a(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.plain_y)));
            }
            if (world.field_73012_v.nextInt(5) == 0) {
                if (!world.field_72995_K) {
                    ItemTreetap.ejectResin(world, pos, side, 1);
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, 1);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static void ejectResin(World world, BlockPos pos, EnumFacing side, int quantity) {
        double ejectX = (double)pos.func_177958_n() + 0.5 + (double)side.func_82601_c() * 0.3;
        double ejectY = (double)pos.func_177956_o() + 0.5 + (double)side.func_96559_d() * 0.3;
        double ejectZ = (double)pos.func_177952_p() + 0.5 + (double)side.func_82599_e() * 0.3;
        EntityItem entityitem = new EntityItem(world, ejectX, ejectY, ejectZ, new ItemStack((Item)IUItem.rawLatex));
        entityitem.func_174869_p();
        entityitem.func_92059_d().func_190920_e(quantity);
        world.func_72838_d((Entity)entityitem);
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("item.", "iu."));
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name) {
        ItemTreetap.registerModel(this, meta, name);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == IUItem.rubWood) {
            if (ItemTreetap.attemptExtract(player, world, pos, side, state, null)) {
                if (!world.field_72995_K) {
                    DamageHandler.damage(player.func_184586_b(hand), 1, (EntityLivingBase)player);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        if (block == IUItem.swampRubWood) {
            if (ItemTreetap.attemptSwampExtract(player, world, pos, side, state, null)) {
                if (!world.field_72995_K) {
                    DamageHandler.damage(player.func_184586_b(hand), 1, (EntityLivingBase)player);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        if (block == IUItem.tropicalRubWood) {
            if (ItemTreetap.attemptTropicalExtract(player, world, pos, side, state, null)) {
                if (!world.field_72995_K) {
                    DamageHandler.damage(player.func_184586_b(hand), 1, (EntityLivingBase)player);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }
}

