/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.modules;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.reactors.IReactorModule;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.register.Register;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReactorModules
extends ItemSubTypes<CraftingTypes>
implements IModelRegister,
IReactorModule {
    protected static final String NAME = "reactormodules";

    public ItemReactorModules() {
        super(CraftingTypes.class);
        this.func_77637_a(IUCore.ModuleTab);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:reactor_module/" + CraftingTypes.getFromID(meta).func_176610_l(), null));
    }

    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World worldIn, @Nonnull List<String> info, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(itemStack, worldIn, info, flagIn);
        CraftingTypes craftingTypes = CraftingTypes.getFromID(itemStack.func_77952_i());
        double generation = craftingTypes.generation - 1.0;
        double radiation = craftingTypes.radiation - 1.0;
        double stableHeat = craftingTypes.stableHeat - 1.0;
        double capacitor = craftingTypes.capacitor - 1.0;
        double exchanger = craftingTypes.exchanger - 1.0;
        double vent = craftingTypes.vent - 1.0;
        double componentVent = craftingTypes.componentVent - 1.0;
        if (generation > 0.0) {
            info.add(Localization.translate("reactor.generation_plus") + ((int)(craftingTypes.generation * 100.0) - 100) + "%");
        } else if (generation < 0.0) {
            info.add(Localization.translate("reactor.generation_minus") + (100 - (int)(craftingTypes.generation * 100.0)) + "%");
        }
        if (radiation > 0.0) {
            info.add(Localization.translate("reactor.radiation_plus") + ((int)(craftingTypes.radiation * 100.0) - 100) + "%");
        } else if (radiation < 0.0) {
            info.add(Localization.translate("reactor.radiation_minus") + (100 - (int)(craftingTypes.radiation * 100.0)) + "%");
        }
        if (vent > 0.0) {
            info.add(Localization.translate("reactor.vent_plus") + ((int)(craftingTypes.vent * 100.0) - 100) + "%");
        } else if (vent < 0.0) {
            info.add(Localization.translate("reactor.vent_minus") + (100 - (int)(craftingTypes.vent * 100.0)) + "%");
        }
        if (stableHeat > 0.0) {
            info.add(Localization.translate("reactor.stableheat_plus") + ((int)(craftingTypes.stableHeat * 100.0) - 100) + "%");
        } else if (stableHeat < 0.0) {
            info.add(Localization.translate("reactor.stableheat_minus") + (100 - (int)(craftingTypes.stableHeat * 100.0)) + "%");
        }
        if (capacitor > 0.0) {
            info.add(Localization.translate("reactor.capacitor_plus") + ((int)(craftingTypes.capacitor * 100.0) - 100) + "%");
        } else if (capacitor < 0.0) {
            info.add(Localization.translate("reactor.capacitor_minus") + (100 - (int)(craftingTypes.capacitor * 100.0)) + "%");
        }
        if (componentVent > 0.0) {
            info.add(Localization.translate("reactor.componentvent_plus") + ((int)(craftingTypes.componentVent * 100.0) - 100) + "%");
        } else if (componentVent < 0.0) {
            info.add(Localization.translate("reactor.componentvent_minus") + (100 - (int)(craftingTypes.componentVent * 100.0)) + "%");
        }
        if (exchanger > 0.0) {
            info.add(Localization.translate("reactor.exchanger_plus") + ((int)(craftingTypes.exchanger * 100.0) - 100) + "%");
        } else if (exchanger < 0.0) {
            info.add(Localization.translate("reactor.exchanger_minus") + (100 - (int)(craftingTypes.exchanger * 100.0)) + "%");
        }
    }

    public String func_77658_a() {
        return "iu." + super.func_77658_a().substring(3);
    }

    @Override
    public double getStableHeat(ItemStack stack) {
        CraftingTypes craftingTypes = CraftingTypes.getFromID(stack.func_77952_i());
        return craftingTypes.getStableHeat();
    }

    @Override
    public double getRadiation(ItemStack stack) {
        CraftingTypes craftingTypes = CraftingTypes.getFromID(stack.func_77952_i());
        return craftingTypes.getRadiation();
    }

    @Override
    public double getGeneration(ItemStack stack) {
        CraftingTypes craftingTypes = CraftingTypes.getFromID(stack.func_77952_i());
        return craftingTypes.getGeneration();
    }

    @Override
    public double getComponentVent(ItemStack stack) {
        CraftingTypes craftingTypes = CraftingTypes.getFromID(stack.func_77952_i());
        return craftingTypes.getComponentVent();
    }

    @Override
    public double getVent(ItemStack stack) {
        CraftingTypes craftingTypes = CraftingTypes.getFromID(stack.func_77952_i());
        return craftingTypes.getVent();
    }

    @Override
    public double getExchanger(ItemStack stack) {
        CraftingTypes craftingTypes = CraftingTypes.getFromID(stack.func_77952_i());
        return craftingTypes.getExchanger();
    }

    @Override
    public double getCapacitor(ItemStack stack) {
        CraftingTypes craftingTypes = CraftingTypes.getFromID(stack.func_77952_i());
        return craftingTypes.getCapacitor();
    }

    public static enum CraftingTypes implements ISubEnum
    {
        generation0(0.98, 1.0, 1.05, 1.0, 1.0, 1.0, 1.0),
        generation1(0.95, 1.0, 1.1, 1.0, 1.0, 1.0, 1.0),
        generation2(0.92, 1.0, 1.15, 1.0, 1.0, 1.0, 1.0),
        generation3(0.9, 1.0, 1.2, 1.0, 1.0, 1.0, 1.0),
        radiation0(1.02, 1.25, 1.0, 1.0, 1.0, 1.0, 1.0),
        radiation1(1.04, 2.5, 1.0, 1.0, 1.0, 1.0, 1.0),
        radiation2(1.06, 3.0, 1.0, 1.0, 1.0, 1.0, 1.0),
        radiation3(1.08, 4.0, 1.0, 1.0, 1.0, 1.0, 1.0),
        stableheat0(1.05, 1.25, 0.98, 1.0, 1.0, 1.0, 1.0),
        stableheat1(1.1, 1.5, 0.95, 1.0, 1.0, 1.0, 1.0),
        stableheat2(1.15, 1.75, 0.9, 1.0, 1.0, 1.0, 1.0),
        stableheat3(1.2, 2.0, 0.85, 1.0, 1.0, 1.0, 1.0),
        vent0(1.0, 1.0, 1.0, 1.0, 1.05, 0.95, 1.0),
        vent1(1.0, 1.0, 1.0, 1.0, 1.1, 0.9, 1.0),
        vent2(1.0, 1.0, 1.0, 0.8, 1.15, 0.9, 1.0),
        vent3(1.0, 1.0, 1.0, 0.75, 1.2, 0.85, 1.0),
        componentvent0(1.0, 1.0, 1.0, 1.25, 0.95, 0.95, 1.0),
        componentvent1(1.0, 1.0, 1.0, 1.5, 0.925, 0.925, 1.0),
        componentvent2(1.0, 1.0, 1.0, 1.75, 0.9, 0.9, 1.0),
        componentvent3(1.0, 1.0, 1.0, 2.0, 0.88, 0.88, 1.0),
        exchanger0(0.98, 1.0, 1.0, 1.1, 0.9, 1.05, 1.0),
        exchanger1(0.95, 1.0, 1.0, 1.25, 0.875, 1.1, 1.0),
        exchanger2(0.925, 1.0, 1.0, 1.25, 0.85, 1.2, 1.0),
        exchanger3(0.9, 1.0, 1.0, 1.25, 0.825, 1.3, 1.0),
        capacitor0(1.0, 1.0, 0.975, 1.1, 1.0, 1.0, 1.25),
        capacitor1(1.0, 1.0, 0.95, 1.2, 1.0, 1.0, 1.5),
        capacitor2(1.0, 1.0, 0.925, 1.4, 1.0, 1.0, 2.0),
        capacitor3(1.0, 1.0, 0.9, 1.8, 1.0, 1.0, 2.5);

        private final String name = this.name().toLowerCase(Locale.US);
        private double stableHeat;
        private double radiation;
        private double generation;
        private double componentVent;
        private double vent;
        private double exchanger;
        private double capacitor;

        private CraftingTypes(double stableHeat, double radiation, double generation, double componentVent, double vent, double exchanger, double capacitor) {
            this.stableHeat = stableHeat;
            this.radiation = radiation;
            this.generation = generation;
            this.vent = vent;
            this.componentVent = componentVent;
            this.exchanger = exchanger;
            this.capacitor = capacitor;
        }

        public static CraftingTypes getFromID(int ID) {
            return CraftingTypes.values()[ID % CraftingTypes.values().length];
        }

        public double getCapacitor() {
            return this.capacitor;
        }

        public double getComponentVent() {
            return this.componentVent;
        }

        public double getExchanger() {
            return this.exchanger;
        }

        public double getGeneration() {
            return this.generation;
        }

        public double getRadiation() {
            return this.radiation;
        }

        public double getStableHeat() {
            return this.stableHeat;
        }

        public double getVent() {
            return this.vent;
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getId() {
            return this.ordinal();
        }
    }
}

