/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.IUCore;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IDamageItem;
import com.denfop.register.Register;
import com.denfop.utils.ModUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDamage
extends Item
implements IDamageItem,
IModelRegister {
    private final int maxDamage;
    private final String name;

    public ItemDamage(String name, int maxDamage) {
        this.setNoRepair();
        this.maxDamage = maxDamage;
        this.name = name;
        this.func_77637_a(IUCore.ReactorsTab);
        if (name != null) {
            this.func_77655_b(name);
            Register.registerItem(this, IUCore.getIdentifier(name));
            IUCore.proxy.addIModelRegister(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:" + name;
        return new ModelResourceLocation(loc, null);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemDamage.getModelLocation(name));
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name) {
        this.registerModel(this, meta, name);
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name, String extraName) {
        this.registerModel(this, meta, name);
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return (double)this.getCustomDamage(stack) / (double)this.getMaxCustomDamage(stack);
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isDamaged(@Nonnull ItemStack stack) {
        return this.getCustomDamage(stack) > 0;
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        assert (stack.func_77978_p() != null);
        return stack.func_77978_p().func_74762_e("damage");
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return this.maxDamage;
    }

    public void setDamage(@Nonnull ItemStack stack, int damage) {
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        if (damage > this.maxDamage) {
            damage = this.maxDamage;
        }
        nbt.func_74768_a("damage", damage);
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, EntityLivingBase src) {
        int damage1 = this.getCustomDamage(stack) - damage;
        if (damage1 <= 0) {
            damage1 = 0;
        }
        this.setCustomDamage(stack, damage1);
        return this.getMaxCustomDamage(stack) - damage1 == 0;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this);
            subItems.add((Object)stack);
        }
    }
}

