/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.register.Register;
import com.denfop.tiles.reactors.graphite.IExchangerItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemExchanger
extends ItemDamage
implements IModelRegister,
IExchangerItem {
    private final double percent;
    private final int level;
    private final String name;

    public ItemExchanger(String name, int level, double percent, int damage) {
        super(null, damage);
        this.percent = percent;
        this.level = level;
        this.setNoRepair();
        this.name = name;
        this.func_77625_d(1);
        this.func_77637_a(IUCore.ReactorsTab);
        this.func_77655_b("item_" + name);
        Register.registerItem(this, IUCore.getIdentifier("item_" + name));
        IUCore.proxy.addIModelRegister(this);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:exchanger/" + name;
        return new ModelResourceLocation(loc, null);
    }

    @Override
    public double getPercent() {
        return this.percent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean damageItem(ItemStack stack, int damage) {
        return this.applyCustomDamage(stack, damage, null);
    }

    @Override
    public void registerModels() {
        this.registerModels(this.name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(String name) {
        this.registerModel(0, name, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name) {
        this.registerModel(this, meta, name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void registerModel(int meta, String name, String extraName) {
        this.registerModel(this, meta, name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemExchanger.getModelLocation(name));
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("item", "iu").replace(".name", ""));
    }

    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        tooltip.add(Localization.translate("iu.reactoritem.durability") + " " + (this.getMaxCustomDamage(stack) - this.getCustomDamage(stack)) + "/" + this.getMaxCustomDamage(stack));
        tooltip.add(Localization.translate("reactor.component_level") + (this.level + 1));
        tooltip.add(Localization.translate("reactor.component_level1"));
    }
}

