/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.Localization;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.items.reactors.ItemDamage;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemReactorPlate
extends ItemDamage
implements IReactorItem {
    private final int level;
    private final double percent;

    public ItemReactorPlate(String name, int level, double percent) {
        super(name, 0);
        this.level = level;
        this.percent = percent;
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public static ModelResourceLocation getModelLocation(String name) {
        String loc = "industrialupgrade:reactors/" + name;
        return new ModelResourceLocation(loc, null);
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("item", "iu").replace(".name", ""));
    }

    @Override
    public boolean needClear(ItemStack stack) {
        return this.getMaxCustomDamage(stack) - this.getCustomDamage(stack) == 0;
    }

    @Override
    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)ItemReactorPlate.getModelLocation(name));
    }

    @Override
    public EnumTypeComponent getType() {
        return EnumTypeComponent.PLATE;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getAutoRepair(IAdvReactor reactor) {
        return 0;
    }

    @Override
    public int getRepairOther(IAdvReactor reactor) {
        return 0;
    }

    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        tooltip.add(Localization.translate("reactor.component_level") + this.level);
        tooltip.add(Localization.translate("reactor.component_level1"));
    }

    @Override
    public int getDamageCFromHeat(int heat, IAdvReactor reactor) {
        return 1;
    }

    @Override
    public int getHeat(IAdvReactor reactor) {
        return 0;
    }

    @Override
    public double getHeatRemovePercent(IAdvReactor reactor) {
        return this.percent;
    }

    @Override
    public void damageItem(ItemStack stack, int damage) {
    }

    @Override
    public boolean updatableItem() {
        return false;
    }

    @Override
    public boolean caneExtractHeat() {
        return false;
    }

    @Override
    public double getEnergyProduction(IAdvReactor reactor) {
        return 0.0;
    }
}

