/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.resource;

import com.denfop.api.IModelRegister;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.block.ISubItem;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSubTypes<T extends Enum<T>>
extends Item
implements ISubItem<T>,
IModelRegister {
    protected final PropertyEnum<T> typeProperty;
    private List<T> list;

    private ItemSubTypes(PropertyEnum<T> typeProperty) {
        this.typeProperty = typeProperty;
        this.func_77627_a(true);
    }

    protected ItemSubTypes(Class<T> typeClass) {
        this(PropertyEnum.func_177707_a((String)"type", typeClass, Arrays.asList(typeClass.getEnumConstants())));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (Enum element : this.typeProperty.func_177700_c()) {
            this.registerModel(this, ((ISubEnum)((Object)element)).getId(), ((IStringSerializable)element).func_176610_l());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:items/" + extraName, null));
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack));
    }

    public String func_77667_c(ItemStack stack) {
        T type = this.getType(stack);
        return type == null ? super.func_77667_c(stack).replace("item", "iu").replace(".name", "") : super.func_77667_c(stack).replace("item", "iu") + "." + ((IStringSerializable)type).func_176610_l();
    }

    @Override
    public ItemStack getItemStack(T type) {
        return this.getItemStackUnchecked(type);
    }

    protected ItemStack getItemStackUnchecked(T type) {
        return new ItemStack((Item)this, 1, ((ISubEnum)type).getId());
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (Enum type : this.typeProperty.func_177700_c()) {
                subItems.add((Object)this.getItemStackUnchecked(type));
            }
        }
    }

    public Set<T> getAllTypes() {
        return EnumSet.allOf(this.typeProperty.func_177699_b());
    }

    public final T getType(ItemStack stack) {
        for (Enum element : this.typeProperty.func_177700_c()) {
            if (((ISubEnum)((Object)element)).getId() != stack.func_77960_j()) continue;
            return (T)element;
        }
        return null;
    }
}

