/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.space;

import com.denfop.ElectricItem;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.rovers.enums.EnumRoversLevel;
import com.denfop.api.space.rovers.enums.EnumRoversLevelFluid;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import com.denfop.api.space.upgrades.event.EventItemLoad;
import com.denfop.blocks.FluidName;
import com.denfop.items.ItemFluidContainer;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRover
extends ItemFluidContainer
implements IModelRegister,
IRoversItem,
IEnergyItem {
    protected static final String NAME = "rover";
    private final EnumRoversLevel enumRoversLevel;
    private final EnumTypeRovers typeRovers;
    private final String name;
    private final double maxEnergy;
    private final double transferEnergy;
    private final int tier;
    private final EnumRoversLevelFluid fluids;
    private final double progress;
    public List<EnumTypeUpgrade> upgrades = Arrays.asList(EnumTypeUpgrade.values());

    public ItemRover(String name, int capacity, EnumRoversLevel enumRoversLevel, EnumTypeRovers typeRovers, int tier, double maxEnergy, double transferEnergy, EnumRoversLevelFluid fluids, double progress) {
        super(name, capacity);
        this.name = name;
        this.maxEnergy = maxEnergy;
        this.fluids = fluids;
        this.transferEnergy = transferEnergy;
        this.tier = tier;
        this.func_77625_d(1);
        this.progress = progress;
        this.enumRoversLevel = enumRoversLevel;
        this.typeRovers = typeRovers;
        this.func_77637_a(IUCore.SpaceTab);
        SpaceUpgradeSystem.system.addRecipe(this, EnumTypeUpgrade.values());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        tooltip.add(Localization.translate("iu.rover.info_temperature"));
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)this.func_77667_c(stack).replace("item.", "iu.").replace(".name", ""));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            ItemStack stack1 = new ItemStack((Item)this);
            ElectricItem.manager.charge(stack1, 2.147483647E9, Integer.MAX_VALUE, true, false);
            subItems.add((Object)stack1);
            for (FluidName fluidName : this.fluids.getLevelsList()) {
                ItemStack stack = new ItemStack((Item)this);
                ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
                subItems.add((Object)this.getItemStack(stack, fluidName.getInstance()));
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EnumTypeRovers getType() {
        return this.typeRovers;
    }

    @Override
    public IFluidHandlerItem getFluidHandler(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack);
    }

    @Override
    public EnumRoversLevel getLevel() {
        return this.enumRoversLevel;
    }

    @Override
    public double getAddProgress() {
        return this.progress;
    }

    @Override
    public List<EnumTypeUpgrade> getUpgradeModules() {
        return this.upgrades;
    }

    @Override
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:rover/" + this.name, null));
    }

    @Override
    public boolean canProvideEnergy(ItemStack var1) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack var1) {
        return this.maxEnergy;
    }

    @Override
    public short getTierItem(ItemStack var1) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack var1) {
        return this.transferEnergy;
    }

    public void func_77663_a(@Nonnull ItemStack itemStack, @Nonnull World world, @Nonnull Entity entity, int slot, boolean par5) {
        NBTTagCompound nbt = ModUtils.nbt(itemStack);
        if (!SpaceUpgradeSystem.system.hasInMap(itemStack)) {
            nbt.func_74757_a("hasID", false);
            MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
    }

    @Override
    public boolean canfill(Fluid var1) {
        for (FluidName fluidName : this.fluids.getLevelsList()) {
            if (fluidName.getInstance() != var1) continue;
            return true;
        }
        return false;
    }
}

