/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.upgradekit;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.IModelRegister;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.resource.ItemSubTypes;
import com.denfop.register.Register;
import com.denfop.tiles.base.TileElectricBlock;
import com.denfop.tiles.wiring.EnumElectricBlock;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public class ItemUpgradeKit
extends ItemSubTypes<Types>
implements IModelRegister {
    protected static final String NAME = "upgradekitstorage";

    public ItemUpgradeKit() {
        super(Types.class);
        this.func_77637_a(IUCore.UpgradeTab);
        Register.registerItem(this, IUCore.getIdentifier(NAME)).func_77655_b(NAME);
        IUCore.proxy.addIModelRegister(this);
    }

    public void func_77624_a(@Nonnull ItemStack p_77624_1_, @Nullable World p_77624_2_, List<String> p_77624_3_, @Nonnull ITooltipFlag p_77624_4_) {
        p_77624_3_.add(Localization.translate("waring_kit"));
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        if (IUCore.proxy.isSimulating()) {
            EnumActionResult hooks = ForgeHooks.onItemRightClick((EntityPlayer)player, (EnumHand)hand);
            if (hooks == EnumActionResult.FAIL) {
                return hooks;
            }
            ItemStack stack = player.func_184586_b(hand);
            int meta = stack.func_77952_i();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileElectricBlock) {
                TileElectricBlock tile = (TileElectricBlock)tileEntity;
                EnumElectricBlock enumblock = tile.getElectricBlock();
                if (enumblock != null && enumblock.kit_meta == meta) {
                    ItemStack stack1 = tile.getElectricBlock().chargepad ? new ItemStack((Block)IUItem.chargepadelectricblock, 1, tile.getElectricBlock().meta) : new ItemStack((Block)IUItem.electricblock, 1, tile.getElectricBlock().meta);
                    NBTTagCompound nbt = ModUtils.nbt(stack1);
                    nbt.func_74780_a("energy", tile.energy.getEnergy());
                    IBlockState state = world.func_180495_p(pos);
                    state.func_177230_c().removedByPlayer(state, world, pos, (EntityPlayer)((EntityPlayerMP)player), true);
                    state.func_177230_c().func_176206_d(world, pos, state);
                    state.func_177230_c().func_180657_a(world, (EntityPlayer)((EntityPlayerMP)player), pos, state, null, stack);
                    List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)(pos.func_177958_n() - 1), (double)(pos.func_177956_o() - 1), (double)(pos.func_177952_p() - 1), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)));
                    for (EntityItem item : items) {
                        item.func_70106_y();
                    }
                    EntityItem item = new EntityItem(world);
                    item.func_92058_a(stack1);
                    if (!player.func_130014_f_().field_72995_K) {
                        item.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                        item.func_174867_a(0);
                        world.func_72838_d((Entity)item);
                    }
                    List<ItemStack> list = tile.getDrop();
                    EntityItem[] item1 = new EntityItem[list.size()];
                    for (ItemStack stack2 : list) {
                        item1[list.indexOf((Object)stack2)] = new EntityItem(world);
                        item1[list.indexOf(stack2)].func_92058_a(stack2);
                        if (player.func_130014_f_().field_72995_K) continue;
                        item1[list.indexOf(stack2)].func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
                        item1[list.indexOf(stack2)].func_174867_a(0);
                        world.func_72838_d((Entity)item1[list.indexOf(stack2)]);
                    }
                    stack.func_190920_e(stack.func_190916_E() - 1);
                }
                return EnumActionResult.PASS;
            }
        }
        return EnumActionResult.PASS;
    }

    public String func_77658_a() {
        return "iu." + super.func_77658_a().substring(3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, int meta, String extraName) {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation("industrialupgrade:upgradekitstorage/" + Types.getFromID(meta).func_176610_l(), null));
    }

    public static enum Types implements ISubEnum
    {
        upgradekit(0),
        upgradekit1(1),
        upgradekit2(2),
        upgradekit3(3),
        upgradekit4(4),
        upgradekit5(5),
        upgradekit6(6),
        upgradekit7(7),
        upgradekit8(8);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

