/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.radiationsystem.Radiation;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.tesseract.Channel;
import com.denfop.api.vein.Vein;
import com.denfop.invslot.InvSlot;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EncodedType;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.tiles.base.DataOre;
import com.denfop.utils.ModUtils;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class DecoderHandler {
    private static final Map<Class<?>, EncodedType> classToTypeCache = Collections.synchronizedMap(new IdentityHashMap());

    public static Object decode(CustomPacketBuffer is) throws IOException {
        try {
            return DecoderHandler.decode(is, DecoderHandler.typeFromId(is.readUnsignedByte()));
        }
        catch (IllegalArgumentException var3) {
            return null;
        }
    }

    public static <T> T decode(CustomPacketBuffer is, Class<T> clazz) throws IOException {
        EncodedType type = DecoderHandler.typeFromClass(clazz);
        if (type.threadSafe) {
            return (T)DecoderHandler.decode(is, type);
        }
        throw new IllegalArgumentException("requesting decode for non thread safe type");
    }

    public static Object decodeDeferred(CustomPacketBuffer is, Class<?> clazz) throws IOException {
        EncodedType type = DecoderHandler.typeFromClass(clazz);
        return DecoderHandler.decode(is, type);
    }

    private static EncodedType typeFromId(int id) {
        if (id >= 0 && id < EncodedType.types.length) {
            return EncodedType.types[id];
        }
        throw new IllegalArgumentException("invalid type id: " + id);
    }

    private static Class<?> box(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz == Character.TYPE ? Character.class : clazz;
    }

    private static Class<?> unbox(Class<?> clazz) {
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        return clazz == Character.class ? Character.TYPE : clazz;
    }

    private static EncodedType typeFromClass(Class<?> cls) {
        EncodedType[] var3;
        EncodedType ret;
        if (cls == null) {
            return EncodedType.Null;
        }
        if (cls.isArray()) {
            return EncodedType.Array;
        }
        if (cls.isPrimitive()) {
            cls = DecoderHandler.box(cls);
        }
        if ((ret = EncodedType.classToTypeMap.get(cls)) != null) {
            return ret;
        }
        ret = classToTypeCache.get(cls);
        if (ret != null) {
            return ret;
        }
        for (EncodedType type : var3 = EncodedType.types) {
            if (type.cls == null || !type.cls.isAssignableFrom(cls)) continue;
            classToTypeCache.put(cls, type);
            return type;
        }
        throw new IllegalStateException("unmatched " + cls);
    }

    private static Class<?> getClass(String type) {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException var2) {
            throw new RuntimeException("Missing type from the class path expected by network: " + type, var2);
        }
    }

    public static Block getBlock(ResourceLocation loc) {
        Block ret = (Block)Block.field_149771_c.func_82594_a((Object)loc);
        if (ret != Blocks.field_150350_a) {
            return ret;
        }
        return loc.func_110624_b().equals("minecraft") && loc.func_110623_a().equals("air") ? ret : null;
    }

    public static Object decode(CustomPacketBuffer is, EncodedType type) throws IOException {
        switch (type) {
            case Array: {
                int i;
                Class<?> component;
                EncodedType componentType = DecoderHandler.typeFromId(is.readUnsignedByte());
                boolean primitive = is.readBoolean();
                boolean isEnum = componentType == EncodedType.Enum;
                Class<?> clazz = component = primitive ? DecoderHandler.unbox(componentType.cls) : componentType.cls;
                if (component == null || isEnum) {
                    assert (isEnum);
                    component = DecoderHandler.getClass(is.readString());
                }
                Class<?> componentClass = component;
                int len = is.func_150792_a();
                boolean anyTypeMismatch = is.readBoolean();
                boolean needsResolving = !componentType.threadSafe;
                Object array = new Object[len];
                array = !needsResolving ? Array.newInstance(component, len) : new Object[len];
                if (!anyTypeMismatch) {
                    if (isEnum) {
                        ?[] constants = component.getEnumConstants();
                        assert (constants != null);
                        for (int k = 0; k < len; ++k) {
                            Array.set(array, k, constants[(Integer)DecoderHandler.decode(is, componentType)]);
                        }
                    } else {
                        for (i = 0; i < len; ++i) {
                            Array.set(array, i, DecoderHandler.decode(is, componentType));
                        }
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        EncodedType cType = DecoderHandler.typeFromId(is.readUnsignedByte());
                        if (!cType.threadSafe && !needsResolving) {
                            needsResolving = true;
                            if (componentClass != Object.class) {
                                Object[] newArray = new Object[len];
                                System.arraycopy(array, 0, newArray, 0, i);
                                array = newArray;
                            }
                        }
                        Array.set(array, i, DecoderHandler.decode(is, cType));
                    }
                }
                if (!needsResolving) {
                    return array;
                }
                Object finalArray = array;
                Object ret_array = Array.newInstance(componentClass, len);
                for (int i1 = 0; i1 < len; ++i1) {
                    Array.set(ret_array, i1, DecoderHandler.getValue(Array.get(finalArray, i1)));
                }
                return ret_array;
            }
            case Block: {
                return DecoderHandler.getBlock((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case BlockPos: {
                return is.func_179259_c();
            }
            case Boolean: {
                return is.readBoolean();
            }
            case Byte: {
                return is.readByte();
            }
            case network_object: {
                return is;
            }
            case Character: {
                return Character.valueOf(is.readChar());
            }
            case ChunkPos: {
                return new ChunkPos(is.readInt(), is.readInt());
            }
            case Collection: {
                Object ret = DecoderHandler.decode(is, EncodedType.Array);
                return Arrays.asList((Object[])ret);
            }
            case Component: {
                return is;
            }
            case Double: {
                return is.readDouble();
            }
            case Enchantment: {
                return Enchantment.field_185264_b.func_82594_a((Object)((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation)));
            }
            case Enum: {
                return is.func_150792_a();
            }
            case Float: {
                return Float.valueOf(is.readFloat());
            }
            case Fluid: {
                return FluidRegistry.getFluid((String)is.readString());
            }
            case FluidStack: {
                FluidStack ret2 = new FluidStack((Fluid)DecoderHandler.decode(is, EncodedType.Fluid), is.readInt());
                ret2.tag = (NBTTagCompound)DecoderHandler.decode(is);
                return ret2;
            }
            case FluidTank: {
                return new FluidTank((FluidStack)DecoderHandler.decode(is), is.readInt());
            }
            case GameProfile: {
                return new GameProfile((UUID)DecoderHandler.decode(is), is.readString());
            }
            case Integer: {
                return is.readInt();
            }
            case InvSlot: {
                ItemStack[] contents = (ItemStack[])DecoderHandler.decode(is, EncodedType.Array);
                InvSlot ret3 = new InvSlot(contents.length);
                for (int i = 0; i < contents.length; ++i) {
                    ret3.put(i, contents[i]);
                }
                return ret3;
            }
            case Item: {
                return ModUtils.getItem((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case ItemStack: {
                byte size = is.readByte();
                if (size == 0) {
                    return ModUtils.emptyStack;
                }
                Item item = DecoderHandler.decode(is, Item.class);
                short meta = is.readShort();
                NBTTagCompound nbt = (NBTTagCompound)DecoderHandler.decode(is);
                ItemStack ret1 = new ItemStack(item, (int)size, (int)meta);
                ret1.func_77982_d(nbt);
                return ret1;
            }
            case Long: {
                return is.readLong();
            }
            case NBTTagCompound: {
                return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)is), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            }
            case Input: {
                return Recipes.inputFactory.getInput(DecoderHandler.decode(is));
            }
            case MachineRecipe: {
                List itemStackList = (List)DecoderHandler.decode(is);
                NBTTagCompound tagCompound = (NBTTagCompound)DecoderHandler.decode(is);
                List list = (List)DecoderHandler.decode(is);
                return new BaseMachineRecipe(new Input(list), new RecipeOutput(tagCompound, itemStackList));
            }
            case Null: {
                return null;
            }
            case channel: {
                return new Channel(is);
            }
            case Object: {
                return new Object();
            }
            case Potion: {
                return Potion.field_188414_b.func_82594_a((Object)((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation)));
            }
            case ResourceLocation: {
                return new ResourceLocation(is.readString(), is.readString());
            }
            case Short: {
                return is.readShort();
            }
            case String: {
                return is.readString();
            }
            case TileEntity: {
                World deferredWorld = (World)DecoderHandler.decode(is, EncodedType.World);
                BlockPos pos = (BlockPos)DecoderHandler.decode(is, EncodedType.BlockPos);
                return deferredWorld.func_175625_s(pos);
            }
            case UUID: {
                return new UUID(is.readLong(), is.readLong());
            }
            case Vec3: {
                return new Vec3d(is.readDouble(), is.readDouble(), is.readDouble());
            }
            case DataOre: {
                return new DataOre(is);
            }
            case Vein: {
                return new Vein(is);
            }
            case RecipeInfo: {
                return new RecipeInfo(is);
            }
            case PlayerStreakInfo: {
                return new PlayerStreakInfo((NBTTagCompound)DecoderHandler.decode(is));
            }
            case Radiation: {
                return new Radiation(is);
            }
            case FAKE_PLANET: {
                return new FakePlanet((NBTTagCompound)DecoderHandler.decode(is));
            }
            case World: {
                int inputAmount = is.readInt();
                return IUCore.proxy.getWorld(inputAmount);
            }
        }
        throw new IllegalArgumentException("unhandled type: " + (Object)((Object)type));
    }

    public static <T> T getValue(Object decoded) {
        return (T)decoded;
    }
}

