/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.Config;
import com.denfop.network.EncoderHandler;
import com.denfop.network.NetworkManager;
import com.denfop.network.WorldData;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldContainerItemStack;
import com.denfop.network.packet.PacketUpdateFieldContainerTile;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateOvertimeTile;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.tiles.base.TileEntityBlock;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class UpdateTileEntityPacket {
    UpdateTileEntityPacket() {
    }

    public static void send(WorldData worldData) throws IOException {
        CustomPacketBuffer playerBuffer;
        Object commonBuffer;
        if (!Config.optimization_network) {
            if (!worldData.listUpdateTile.isEmpty()) {
                for (TileEntityBlock tileEntityBlock : new ArrayList<TileEntityBlock>(worldData.listUpdateTile)) {
                    List playersInRange = NetworkManager.getPlayersInRange(tileEntityBlock.func_145831_w(), tileEntityBlock.func_174877_v(), new ArrayList());
                    for (EntityPlayerMP player : playersInRange) {
                        commonBuffer = new CustomPacketBuffer();
                        commonBuffer.writeByte(0);
                        commonBuffer.writeInt(player.func_130014_f_().field_73011_w.getDimension());
                        EncoderHandler.encode(commonBuffer, tileEntityBlock.func_174877_v(), false);
                        commonBuffer.writeBytes((ByteBuf)tileEntityBlock.writePacket());
                        new PacketUpdateTile((CustomPacketBuffer)((Object)commonBuffer), player);
                    }
                }
            }
            worldData.listUpdateTile.clear();
        } else {
            Iterator<TileEntityBlock> iterator = worldData.listUpdateTile.iterator();
            int n = Config.optimization_network_col;
            int index = 0;
            try {
                while (iterator.hasNext() && index < n) {
                    ++index;
                    TileEntityBlock te = iterator.next();
                    List playersInRange = NetworkManager.getPlayersInRange(te.func_145831_w(), te.func_174877_v(), new ArrayList());
                    for (EntityPlayerMP player : playersInRange) {
                        CustomPacketBuffer commonBuffer2 = new CustomPacketBuffer();
                        commonBuffer2.writeByte(0);
                        commonBuffer2.writeInt(player.func_130014_f_().field_73011_w.getDimension());
                        EncoderHandler.encode(commonBuffer2, te.func_174877_v(), false);
                        commonBuffer2.writeBytes((ByteBuf)te.writePacket());
                        new PacketUpdateTile(commonBuffer2, player);
                    }
                    iterator.remove();
                }
            }
            catch (Exception te) {
                // empty catch block
            }
        }
        if (worldData.getWorld().field_73011_w.getWorldTime() % 80L == 0L) {
            for (TileEntityBlock tileEntityBlock : worldData.mapUpdateOvertimeField.values()) {
                List playersInRange = NetworkManager.getPlayersInRange(tileEntityBlock.func_145831_w(), tileEntityBlock.func_174877_v(), new ArrayList());
                for (EntityPlayerMP player : playersInRange) {
                    commonBuffer = new CustomPacketBuffer();
                    commonBuffer.writeByte(25);
                    commonBuffer.writeInt(player.func_130014_f_().field_73011_w.getDimension());
                    EncoderHandler.encode(commonBuffer, tileEntityBlock.func_174877_v(), false);
                    commonBuffer.writeBytes((ByteBuf)tileEntityBlock.writeUpdatePacket());
                    new PacketUpdateOvertimeTile((CustomPacketBuffer)((Object)commonBuffer), player);
                }
            }
        }
        for (Map.Entry entry : worldData.mapUpdateContainer.entrySet()) {
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                playerBuffer = new CustomPacketBuffer();
                playerBuffer.writeByte(8);
                playerBuffer.writeInt(((EntityPlayer)entry1.getKey()).func_130014_f_().field_73011_w.getDimension());
                EncoderHandler.encode(playerBuffer, ((TileEntityBlock)((Object)entry.getKey())).func_174877_v(), false);
                playerBuffer.writeBytes((ByteBuf)entry1.getValue());
                new PacketUpdateFieldContainerTile(playerBuffer, (EntityPlayerMP)entry1.getKey());
            }
        }
        for (Map.Entry entry : worldData.mapUpdateItemStackContainer.entrySet()) {
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                playerBuffer = new CustomPacketBuffer();
                playerBuffer.writeByte(133);
                playerBuffer.writeInt(((EntityPlayer)entry1.getKey()).func_130014_f_().field_73011_w.getDimension());
                EncoderHandler.encode(playerBuffer, ((EntityPlayer)entry1.getKey()).func_70005_c_(), false);
                playerBuffer.writeBytes((ByteBuf)entry1.getValue());
                new PacketUpdateFieldContainerItemStack(playerBuffer, (EntityPlayerMP)entry1.getKey());
            }
        }
        for (Map.Entry entry : worldData.mapUpdateField.entrySet()) {
            TileEntityBlock te = (TileEntityBlock)((Object)entry.getKey());
            List playersInRange = NetworkManager.getPlayersInRange(te.func_145831_w(), te.func_174877_v(), new ArrayList());
            for (CustomPacketBuffer buffer : (List)entry.getValue()) {
                byte[] bytes = new byte[buffer.writerIndex() - buffer.readerIndex()];
                buffer.readBytes(bytes);
                for (EntityPlayerMP player : playersInRange) {
                    CustomPacketBuffer playerBuffer2 = new CustomPacketBuffer();
                    playerBuffer2.writeByte(12);
                    playerBuffer2.writeInt(player.func_130014_f_().field_73011_w.getDimension());
                    EncoderHandler.encode(playerBuffer2, te.func_174877_v(), false);
                    playerBuffer2.writeBytes(bytes);
                    new PacketUpdateFieldTile(playerBuffer2, player);
                }
            }
        }
        worldData.mapUpdateField.clear();
        worldData.mapUpdateContainer.clear();
        worldData.mapUpdateItemStackContainer.clear();
    }
}

