/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.componets.AbstractComponent;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.base.TileEntityBlock;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketAbstractComponent
implements IPacket {
    public PacketAbstractComponent() {
    }

    public PacketAbstractComponent(TileEntityBlock te, String componentName, EntityPlayerMP player, CustomPacketBuffer data) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(64);
        try {
            buffer.writeByte(this.getId());
            EncoderHandler.encode(buffer, te.func_174877_v(), false);
            buffer.writeString(componentName);
            buffer.writeBytes((ByteBuf)data);
        }
        catch (IOException var7) {
            throw new RuntimeException(var7);
        }
        buffer.flip();
        IUCore.network.getServer().sendPacket(buffer, player);
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readPacket(CustomPacketBuffer is, EntityPlayer entityPlayer) {
        BlockPos pos1;
        try {
            pos1 = DecoderHandler.decode(is, BlockPos.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String componentName = is.readString();
        byte[] data = new byte[is.writerIndex() - is.readerIndex()];
        is.readBytes(data);
        IUCore.proxy.requestTick(false, () -> {
            TileEntityBlock tile;
            Object component;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            TileEntity teRaw = world.func_175625_s(pos1);
            if (teRaw instanceof TileEntityBlock && (component = (tile = (TileEntityBlock)teRaw).getComp(componentName)) != null) {
                try {
                    ((AbstractComponent)component).onNetworkUpdate(new CustomPacketBuffer(data));
                }
                catch (IOException var6) {
                    throw new RuntimeException(var6);
                }
            }
        });
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

