/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.api.space.rovers.Rovers;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.mechanism.TileEntityResearchTableSpace;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketSendRoversToPlanet
implements IPacket {
    public PacketSendRoversToPlanet() {
    }

    public PacketSendRoversToPlanet(TileEntityResearchTableSpace base, EntityPlayer player, IBody iBody) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, base.func_145831_w());
            EncoderHandler.encode(customPacketBuffer, base.func_174877_v());
            EncoderHandler.encode(customPacketBuffer, player.func_110124_au());
            customPacketBuffer.writeBoolean(iBody != null);
            if (iBody != null) {
                customPacketBuffer.writeString(iBody.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IUCore.network.getClient().sendPacket(customPacketBuffer);
    }

    @Override
    public byte getId() {
        return 42;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, EntityPlayer entityPlayer) {
        try {
            boolean hasBody;
            World world = (World)DecoderHandler.decode(customPacketBuffer);
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.func_110124_au().equals(uuid) && (hasBody = customPacketBuffer.readBoolean())) {
                IRocketLaunchPad rocketLaunchPad;
                TileEntityResearchTableSpace tileEntityResearchTableSpace;
                String body = customPacketBuffer.readString();
                IBody body1 = SpaceNet.instance.getBodyFromName(body);
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityResearchTableSpace && (tileEntityResearchTableSpace = (TileEntityResearchTableSpace)tile).getPlayer().equals(uuid) && (rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(uuid)) != null && rocketLaunchPad.getRover() != null) {
                    SpaceNet.instance.getResearchSystem().sendingOperation(new Rovers(rocketLaunchPad.getRover(), rocketLaunchPad.getRoverStack()), body1, tileEntityResearchTableSpace);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

