/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.mechanism.TileEntityResearchTableSpace;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketUpdateFakeBody
implements IPacket {
    public PacketUpdateFakeBody() {
    }

    public PacketUpdateFakeBody(TileEntityResearchTableSpace tileEntityResearchTableSpace, IFakeBody fakeBody) {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(packetBuffer, tileEntityResearchTableSpace.func_145831_w());
            EncoderHandler.encode(packetBuffer, tileEntityResearchTableSpace.func_174877_v());
            if (fakeBody instanceof IFakePlanet) {
                packetBuffer.writeByte(0);
            }
            if (fakeBody instanceof IFakeSatellite) {
                packetBuffer.writeByte(1);
            }
            if (fakeBody instanceof IFakeAsteroid) {
                packetBuffer.writeByte(2);
            }
            if (fakeBody == null) {
                packetBuffer.writeByte(3);
            }
            if (fakeBody != null) {
                EncoderHandler.encode(packetBuffer, fakeBody.writeNBTTagCompound(new NBTTagCompound()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IUCore.network.getServer().sendPacket(packetBuffer);
    }

    @Override
    public byte getId() {
        return 41;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, EntityPlayer entityPlayer) {
        try {
            TileEntity tile;
            World world = (World)DecoderHandler.decode(customPacketBuffer);
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            byte id = customPacketBuffer.readByte();
            assert (world != null);
            if (entityPlayer.func_130014_f_().field_73011_w.getDimension() == world.field_73011_w.getDimension() && (tile = world.func_175625_s(pos)) instanceof TileEntityResearchTableSpace) {
                IFakeBody fakePlanet;
                NBTTagCompound nbt;
                if (id == 0) {
                    nbt = (NBTTagCompound)DecoderHandler.decode(customPacketBuffer);
                    fakePlanet = new FakePlanet(nbt);
                    ((TileEntityResearchTableSpace)tile).fakeBody = fakePlanet;
                }
                if (id == 1) {
                    nbt = (NBTTagCompound)DecoderHandler.decode(customPacketBuffer);
                    fakePlanet = new FakeSatellite(nbt);
                    ((TileEntityResearchTableSpace)tile).fakeBody = fakePlanet;
                }
                if (id == 2) {
                    nbt = (NBTTagCompound)DecoderHandler.decode(customPacketBuffer);
                    fakePlanet = new FakeAsteroid(nbt);
                    ((TileEntityResearchTableSpace)tile).fakeBody = fakePlanet;
                }
                if (id == 3) {
                    ((TileEntityResearchTableSpace)tile).fakeBody = null;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

