/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.network.packet.PacketFixedClient;
import com.denfop.tiles.base.TileEntityBlock;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketUpdateFieldTile
implements IPacket {
    public PacketUpdateFieldTile() {
    }

    public PacketUpdateFieldTile(TileEntityBlock te, String field, Object o) {
        CustomPacketBuffer packet = new CustomPacketBuffer();
        packet.writeString(field);
        try {
            EncoderHandler.encode(packet, o);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        IUCore.network.getServer().addTileFieldToUpdate(te, packet);
    }

    public PacketUpdateFieldTile(CustomPacketBuffer customPacketBuffer, EntityPlayerMP entityPlayer) {
        IUCore.network.getServer().sendPacket(customPacketBuffer, entityPlayer);
    }

    public static void apply(BlockPos pos, World world, byte[] is) {
        TileEntity te = world.func_175625_s(pos);
        CustomPacketBuffer buf = new CustomPacketBuffer();
        buf.writeBytes(is);
        if (te != null) {
            ((TileEntityBlock)te).updateField(buf.readString().trim(), buf);
        } else {
            new PacketFixedClient(world, pos);
        }
    }

    @Override
    public byte getId() {
        return 12;
    }

    @Override
    public void readPacket(CustomPacketBuffer is, EntityPlayer entityPlayer) {
        BlockPos pos;
        int dimensionId = is.readInt();
        try {
            pos = DecoderHandler.decode(is, BlockPos.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
        is.readBytes(bytes);
        if (is.readerIndex() >= is.writerIndex()) {
            IUCore.proxy.requestTick(false, () -> {
                World world = IUCore.proxy.getPlayerWorld();
                if (world != null && world.field_73011_w.getDimension() == dimensionId) {
                    PacketUpdateFieldTile.apply(pos, world, bytes);
                }
            });
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

