/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.tiles.base.TileEntityBlock;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketUpdateOvertimeTile
implements IPacket {
    public PacketUpdateOvertimeTile() {
    }

    public PacketUpdateOvertimeTile(CustomPacketBuffer data, EntityPlayerMP player) {
        IUCore.network.getServer().sendPacket(data, player);
    }

    public static void apply(BlockPos pos, World world, byte[] is) {
        if (world.func_175668_a(pos, false)) {
            TileEntity te = world.func_175625_s(pos);
            CustomPacketBuffer buf = new CustomPacketBuffer();
            buf.writeBytes(is);
            if (te != null) {
                ((TileEntityBlock)te).readUpdatePacket(buf);
            }
        }
    }

    @Override
    public byte getId() {
        return 25;
    }

    @Override
    public void readPacket(CustomPacketBuffer is, EntityPlayer entityPlayer) {
        BlockPos pos;
        int dimensionId = is.readInt();
        try {
            pos = DecoderHandler.decode(is, BlockPos.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
        is.readBytes(bytes);
        if (is.readerIndex() >= is.writerIndex()) {
            IUCore.proxy.requestTick(false, () -> {
                World world = IUCore.proxy.getPlayerWorld();
                if (world != null && world.field_73011_w.getDimension() == dimensionId) {
                    PacketUpdateOvertimeTile.apply(pos, world, bytes);
                }
            });
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

