/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.blocks.TileBlockCreator;
import com.denfop.network.DecoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.network.packet.PacketUpdateTe;
import com.denfop.tiles.base.TileEntityBlock;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class PacketUpdateTile
implements IPacket {
    public PacketUpdateTile() {
    }

    public PacketUpdateTile(TileEntityBlock te) {
        Chunk chunk = te.func_145831_w().func_175726_f(te.func_174877_v());
        ExtendedBlockStorage extendedblockstorage = chunk.field_76652_q[te.func_174877_v().func_177956_o() >> 4];
        int i = te.func_174877_v().func_177958_n() & 0xF;
        int j = te.func_174877_v().func_177956_o();
        int k = te.func_174877_v().func_177952_p() & 0xF;
        extendedblockstorage.func_177484_a(i, j & 0xF, k, te.getBlockState());
        IUCore.network.getServer().addTileToUpdate(te);
    }

    public PacketUpdateTile(CustomPacketBuffer data, EntityPlayerMP player) {
        IUCore.network.getServer().sendPacket(data, player);
    }

    private static void apply(BlockPos pos, Class<? extends TileEntityBlock> teClass, World world, byte[] is) {
        if (world.func_175668_a(pos, false)) {
            TileEntity te = world.func_175625_s(pos);
            if (teClass != null && (te == null || te.getClass() != teClass || te.func_145837_r() || te.func_145831_w() != world)) {
                te = TileEntityBlock.instantiate(teClass);
                world.func_175690_a(pos, te);
                assert (!te.func_145837_r());
                assert (te.func_145831_w() == world);
            } else {
                if (te == null) {
                    return;
                }
                new PacketUpdateTe(world, pos);
                if (te.func_145837_r() || te.func_145831_w() != world) {
                    return;
                }
            }
            CustomPacketBuffer buf = new CustomPacketBuffer();
            buf.writeBytes(is);
            ((TileEntityBlock)te).readPacket(buf);
        }
    }

    @Override
    public byte getId() {
        return 0;
    }

    @Override
    public void readPacket(CustomPacketBuffer is, EntityPlayer entityPlayer) {
        BlockPos pos;
        int dimensionId = is.readInt();
        try {
            pos = DecoderHandler.decode(is, BlockPos.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        short firstPart = is.readShort();
        short secondPart = is.readShort();
        Class<? extends TileEntityBlock> teClass = TileBlockCreator.instance.get((int)firstPart).teInfo.getListBlock().get(secondPart).getTeClass();
        byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
        is.readBytes(bytes);
        if (is.readerIndex() >= is.writerIndex()) {
            IUCore.proxy.requestTick(false, () -> {
                World world = IUCore.proxy.getPlayerWorld();
                if (world != null && world.field_73011_w.getDimension() == dimensionId) {
                    PacketUpdateTile.apply(pos, teClass, world, bytes);
                }
            });
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

