/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.pressure;

import com.denfop.api.pressure.event.PressureTileLoadEvent;
import com.denfop.api.pressure.event.PressureTileUnloadEvent;
import com.denfop.pressure.PressureNetGlobal;
import com.denfop.pressure.PressureNetLocal;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileLoad(PressureTileLoadEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        PressureNetLocal local = PressureNetGlobal.getForWorld(event.getWorld());
        if (local != null) {
            local.addTile(event.tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileUnload(PressureTileUnloadEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        PressureNetLocal local = PressureNetGlobal.getForWorld(event.getWorld());
        if (local != null) {
            local.removeTile(event.tile);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            PressureNetGlobal.onTickEnd(event.world);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        PressureNetGlobal.onWorldUnload(event.getWorld());
    }
}

