/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.pressure;

import com.denfop.api.pressure.IPressureNet;
import com.denfop.api.pressure.IPressureTile;
import com.denfop.pressure.EventHandler;
import com.denfop.pressure.PressureNetLocal;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PressureNetGlobal
implements IPressureNet {
    private static Map<World, PressureNetLocal> worldToEnergyNetMap = new WeakHashMap<World, PressureNetLocal>();

    public static PressureNetGlobal initialize() {
        new EventHandler();
        return new PressureNetGlobal();
    }

    public static void onWorldUnload(World world) {
        PressureNetLocal local = worldToEnergyNetMap.remove(world);
        if (local != null) {
            local.onUnload();
        }
    }

    public static PressureNetLocal getForWorld(World world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new PressureNetLocal());
        }
        return worldToEnergyNetMap.get(world);
    }

    public static void onTickEnd(World world) {
        PressureNetLocal energyNet = PressureNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public IPressureTile getSubTile(World var1, BlockPos var2) {
        PressureNetLocal local = PressureNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getTileEntity(var2);
        }
        return null;
    }
}

