/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.pressure;

import com.denfop.api.energy.SystemTick;
import com.denfop.api.pressure.IPressureAcceptor;
import com.denfop.api.pressure.IPressureConductor;
import com.denfop.api.pressure.IPressureEmitter;
import com.denfop.api.pressure.IPressureSink;
import com.denfop.api.pressure.IPressureSource;
import com.denfop.api.pressure.IPressureTile;
import com.denfop.api.sytem.InfoTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class PressureNetLocal {
    final List<SystemTick<IPressureSource, PressurePath>> senderPath = new ArrayList<SystemTick<IPressureSource, PressurePath>>();
    final List<IPressureSource> sourceToUpdateList = new ArrayList<IPressureSource>();
    private final Map<BlockPos, IPressureTile> chunkCoordinatesIPressureTileMap = new HashMap<BlockPos, IPressureTile>();

    PressureNetLocal() {
    }

    public void addTile(IPressureTile tile1) {
        this.addTileEntity(this.getTileFromIPressure(tile1).func_174877_v(), tile1);
    }

    public void addTile(IPressureTile tile, TileEntity tileentity) {
        BlockPos coords = tileentity.func_174877_v();
        if (this.chunkCoordinatesIPressureTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesIPressureTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof IPressureAcceptor) {
            this.onTileEntityAdded((IPressureAcceptor)tile);
        }
        if (tile instanceof IPressureSource) {
            this.senderPath.add(new SystemTick((IPressureSource)tile, null));
        }
    }

    public List<PressurePath> getPaths(IPressureAcceptor par1) {
        ArrayList<PressurePath> paths = new ArrayList<PressurePath>();
        List<SystemTick<IPressureSource, PressurePath>> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (SystemTick<IPressureSource, PressurePath> source : sources_list) {
            if (!this.containsKey(source)) continue;
            paths.addAll(source.getList());
        }
        return paths;
    }

    public BlockPos getPos(IPressureTile tile) {
        if (tile == null) {
            return null;
        }
        return tile.getBlockPos();
    }

    public void addTileEntity(BlockPos coords, IPressureTile tile) {
        if (this.chunkCoordinatesIPressureTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesIPressureTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof IPressureAcceptor) {
            this.onTileEntityAdded((IPressureAcceptor)tile);
        }
        if (tile instanceof IPressureSource) {
            this.senderPath.add(new SystemTick((IPressureSource)tile, null));
        }
    }

    public void removeTile(IPressureTile tile1) {
        this.removeTileEntity(tile1);
    }

    public void removeTileEntity(IPressureTile tile) {
        if (!this.chunkCoordinatesIPressureTileMap.containsKey(tile.getBlockPos())) {
            return;
        }
        BlockPos coord = tile.getBlockPos();
        this.chunkCoordinatesIPressureTileMap.remove(coord, tile);
        this.update(coord);
        if (tile instanceof IPressureAcceptor) {
            this.removeAll(this.getSources((IPressureAcceptor)tile));
            this.onTileEntityRemoved((IPressureAcceptor)tile);
        }
        if (tile instanceof IPressureSource) {
            this.remove((IPressureSource)tile);
        }
    }

    public void emitPressureFrom(IPressureSource PressureSource, double amount, SystemTick<IPressureSource, PressurePath> tick) {
        List<PressurePath> PressurePaths = tick.getList();
        if (PressurePaths == null) {
            PressurePaths = this.discover(PressureSource);
            tick.setList(PressurePaths);
        }
        boolean allow = false;
        if (amount > 0.0) {
            block0: for (PressurePath PressurePath2 : PressurePaths) {
                double adding;
                IPressureSink PressureSink = PressurePath2.target;
                double demandedPressure = PressureSink.getDemandedPressure();
                if (demandedPressure <= 0.0 || demandedPressure != amount || (adding = Math.min(amount, demandedPressure)) <= 0.0) continue;
                allow = allow || PressureSink.needTemperature();
                PressureSink.receivedPressure(adding);
                if (!(adding > PressurePath2.min)) continue;
                for (IPressureConductor PressureConductor : PressurePath2.conductors) {
                    if (!(2.147483647E9 < adding)) continue block0;
                    PressureConductor.removeConductor();
                }
            }
        }
        if (!allow) {
            PressureSource.setAllowed(false);
        }
    }

    public TileEntity getTileFromIPressure(IPressureTile tile) {
        if (tile == null) {
            return null;
        }
        return tile.getTile();
    }

    public List<PressurePath> discover(IPressureSource emitter) {
        HashMap<IPressureConductor, EnumFacing> reachedTileEntities = new HashMap<IPressureConductor, EnumFacing>();
        ArrayList<IPressureSource> tileEntitiesToCheck = new ArrayList<IPressureSource>();
        ArrayList<PressurePath> PressurePaths = new ArrayList<PressurePath>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            IPressureTile currentTileEntity = (IPressureTile)tileEntitiesToCheck.remove(0);
            List<InfoTile<IPressureTile>> validReceivers = this.getValidReceivers(currentTileEntity, false);
            for (InfoTile<IPressureTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                if (validReceiver.tileEntity instanceof IPressureSink) {
                    PressurePaths.add(new PressurePath((IPressureSink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (reachedTileEntities.containsKey((IPressureConductor)validReceiver.tileEntity)) continue;
                reachedTileEntities.put((IPressureConductor)validReceiver.tileEntity, validReceiver.direction);
                tileEntitiesToCheck.add((IPressureSource)validReceiver.tileEntity);
            }
        }
        block2: for (PressurePath PressurePath2 : PressurePaths) {
            IPressureTile tileEntity = PressurePath2.target;
            EnumFacing PressureBlockLink = PressurePath2.targetDirection;
            BlockPos te = tileEntity.getBlockPos();
            if (emitter == null) continue;
            while (tileEntity != emitter) {
                if (PressureBlockLink != null && te != null) {
                    tileEntity = this.getTileEntity(te.func_177972_a(PressureBlockLink));
                    te = te.func_177972_a(PressureBlockLink);
                }
                if (!(tileEntity instanceof IPressureConductor)) continue block2;
                IPressureConductor PressureConductor = (IPressureConductor)tileEntity;
                PressurePath2.conductors.add(PressureConductor);
                PressurePath2.setMin(2.147483647E9);
                PressureBlockLink = (EnumFacing)reachedTileEntities.get(tileEntity);
                if (PressureBlockLink == null) continue;
            }
        }
        return PressurePaths;
    }

    public IPressureTile getNeighbor(IPressureTile tile, EnumFacing dir) {
        if (tile == null) {
            return null;
        }
        return this.getTileEntity(tile.getBlockPos().func_177972_a(dir));
    }

    private List<InfoTile<IPressureTile>> getValidReceivers(IPressureTile emitter, boolean reverse) {
        LinkedList<InfoTile<IPressureTile>> validReceivers = new LinkedList<InfoTile<IPressureTile>>();
        for (EnumFacing direction : EnumFacing.values()) {
            IPressureAcceptor receiver2;
            IPressureEmitter sender2;
            IPressureTile target2 = this.getNeighbor(emitter, direction);
            if (target2 == null) continue;
            EnumFacing inverseDirection2 = direction.func_176734_d();
            if (reverse) {
                if (!(emitter instanceof IPressureAcceptor) || !(target2 instanceof IPressureEmitter) || !(sender2 = (IPressureEmitter)target2).emitsPressureTo(receiver2 = (IPressureAcceptor)emitter, inverseDirection2) || !receiver2.acceptsPressureFrom(sender2, direction)) continue;
                validReceivers.add(new InfoTile<IPressureTile>(target2, inverseDirection2));
                continue;
            }
            if (!(emitter instanceof IPressureEmitter) || !(target2 instanceof IPressureAcceptor) || !(sender2 = (IPressureEmitter)emitter).emitsPressureTo(receiver2 = (IPressureAcceptor)target2, direction) || !receiver2.acceptsPressureFrom(sender2, inverseDirection2)) continue;
            validReceivers.add(new InfoTile<IPressureTile>(target2, inverseDirection2));
        }
        return validReceivers;
    }

    public void onTickEnd() {
        if (!this.sourceToUpdateList.isEmpty()) {
            for (IPressureSource iPressureSource : this.sourceToUpdateList) {
                this.remove1(iPressureSource);
            }
            this.sourceToUpdateList.clear();
        }
        try {
            for (SystemTick systemTick : this.senderPath) {
                IPressureSource entry = (IPressureSource)systemTick.getSource();
                if (entry == null) continue;
                double offered = entry.getOfferedPressure();
                this.emitPressureFrom(entry, offered, systemTick);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void emitPressureFromNotAllowed(IPressureSource PressureSource, double amount, SystemTick<IPressureSource, PressurePath> tick) {
        List<PressurePath> PressurePaths = tick.getList();
        if (PressurePaths == null) {
            PressurePaths = this.discover(PressureSource);
            tick.setList(PressurePaths);
        }
        block0: for (PressurePath PressurePath2 : PressurePaths) {
            double adding;
            IPressureSink PressureSink = PressurePath2.target;
            double demandedPressure = PressureSink.getDemandedPressure();
            if (PressureSink.needTemperature()) {
                PressureSource.setAllowed(true);
            }
            if (demandedPressure <= 0.0 || demandedPressure != amount || (adding = Math.min(amount, demandedPressure)) <= 0.0) continue;
            PressureSink.receivedPressure(adding);
            if (!(adding > PressurePath2.min)) continue;
            for (IPressureConductor PressureConductor : PressurePath2.conductors) {
                if (!(2.147483647E9 < adding)) continue block0;
                PressureConductor.removeConductor();
            }
        }
    }

    public IPressureTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesIPressureTileMap.get(pos);
    }

    public void update(BlockPos pos) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos pos1 = pos.func_177972_a(dir);
            IPressureTile tile = this.chunkCoordinatesIPressureTileMap.get(pos1);
            if (tile == null || !(tile instanceof IPressureConductor)) continue;
            ((IPressureConductor)tile).update_render();
        }
    }

    public void put(IPressureSource par1, List<PressurePath> par2) {
        this.senderPath.add(new SystemTick<IPressureSource, PressurePath>(par1, par2));
    }

    public boolean containsKey(SystemTick<IPressureSource, PressurePath> par1) {
        return this.senderPath.contains(par1);
    }

    public boolean containsKey(IPressureSource par1) {
        return this.senderPath.contains(new SystemTick(par1, null));
    }

    public void remove1(IPressureSource par1) {
        for (SystemTick<IPressureSource, PressurePath> ticks : this.senderPath) {
            if (ticks.getSource() != par1) continue;
            ticks.setList(null);
            break;
        }
    }

    public void remove(IPressureSource par1) {
        this.senderPath.remove(new SystemTick(par1, null));
    }

    public void remove(SystemTick<IPressureSource, PressurePath> par1) {
        this.senderPath.remove(par1);
    }

    public void removeAll(List<SystemTick<IPressureSource, PressurePath>> par1) {
        if (par1 == null) {
            return;
        }
        for (SystemTick<IPressureSource, PressurePath> iPressureSource : par1) {
            iPressureSource.setList(null);
        }
    }

    public List<SystemTick<IPressureSource, PressurePath>> getSources(IPressureAcceptor par1) {
        ArrayList<SystemTick<IPressureSource, PressurePath>> source = new ArrayList<SystemTick<IPressureSource, PressurePath>>();
        block0: for (SystemTick<IPressureSource, PressurePath> entry : this.senderPath) {
            if (entry.getList() == null) continue;
            for (PressurePath path : entry.getList()) {
                if (!(par1 instanceof IPressureConductor && path.conductors.contains(par1) || par1 instanceof IPressureSink && path.target == par1)) continue;
                source.add(entry);
                continue block0;
            }
        }
        return source;
    }

    public SystemTick<IPressureSource, PressurePath> get(IPressureSource tileEntity) {
        for (SystemTick<IPressureSource, PressurePath> entry : this.senderPath) {
            if (entry.getSource() != tileEntity) continue;
            return entry;
        }
        return null;
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesIPressureTileMap.clear();
    }

    public void onTileEntityAdded(IPressureAcceptor tile) {
        ArrayList<IPressureTile> tileEntitiesToCheck = new ArrayList<IPressureTile>();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        blockPosList.add(tile.getBlockPos());
        tileEntitiesToCheck.add(tile);
        while (!tileEntitiesToCheck.isEmpty()) {
            IPressureTile currentTileEntity = (IPressureTile)tileEntitiesToCheck.remove(0);
            for (EnumFacing direction : EnumFacing.values()) {
                IPressureTile target2 = this.getTileEntity(currentTileEntity.getBlockPos().func_177972_a(direction));
                if (target2 == null || blockPosList.contains(target2.getBlockPos())) continue;
                blockPosList.add(target2.getBlockPos());
                if (target2 instanceof IPressureSource) {
                    if (this.sourceToUpdateList.contains((IPressureSource)target2)) continue;
                    this.sourceToUpdateList.add((IPressureSource)target2);
                    continue;
                }
                if (!(target2 instanceof IPressureConductor)) continue;
                tileEntitiesToCheck.add(target2);
            }
        }
    }

    public void onTileEntityRemoved(IPressureAcceptor par1) {
        this.onTileEntityAdded(par1);
    }

    public static class PressurePath {
        final List<IPressureConductor> conductors;
        final IPressureSink target;
        final EnumFacing targetDirection;
        double min = Double.MAX_VALUE;

        PressurePath(IPressureSink sink, EnumFacing facing) {
            this.target = sink;
            this.conductors = new ArrayList<IPressureConductor>();
            this.targetDirection = facing;
        }

        public List<IPressureConductor> getConductors() {
            return this.conductors;
        }

        public double getMin() {
            return this.min;
        }

        public void setMin(double min) {
            this.min = min;
        }
    }
}

