/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.crafting.BaseRecipe;
import com.denfop.api.crafting.BaseShapelessRecipe;
import com.denfop.api.crafting.PartRecipe;
import com.denfop.api.crafting.RecipeGrid;
import com.denfop.recipe.IInputItemStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CraftingManager {
    public BaseRecipe addRecipe(String output, Object ... input) {
        return this.addRecipe((ItemStack)OreDictionary.getOres((String)output).get(0), input);
    }

    public BaseRecipe addRecipe(Item output, Object ... input) {
        return this.addRecipe(new ItemStack(output), input);
    }

    public BaseRecipe addRecipe(ItemStack output, Object ... input) {
        int i;
        List<Object> objects = Arrays.asList(input);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<PartRecipe> objectMap = new ArrayList<PartRecipe>();
        for (i = 0; i < 3 && objects.get(i) instanceof String; ++i) {
            list.add((String)objects.get(i));
        }
        RecipeGrid grid = new RecipeGrid(list);
        while (i < objects.size()) {
            Character character = (Character)objects.get(i);
            Object object = objects.get(i + 1);
            IInputItemStack recipeInput = this.getRecipeInput(object);
            objectMap.add(new PartRecipe(character.toString(), recipeInput));
            i += 2;
        }
        return new BaseRecipe(output, grid, objectMap);
    }

    public BaseShapelessRecipe addShapelessRecipe(ItemStack output, Object ... input) {
        ArrayList<IInputItemStack> recipeInputList = new ArrayList<IInputItemStack>();
        for (Object object : input) {
            IInputItemStack recipeInput = this.getRecipeInput(object);
            recipeInputList.add(recipeInput);
        }
        return new BaseShapelessRecipe(output, recipeInputList);
    }

    public BaseShapelessRecipe addShapelessRecipe(Item output, Object ... input) {
        return this.addShapelessRecipe(new ItemStack(output), input);
    }

    public BaseShapelessRecipe addShapelessRecipe(Block output, Object ... input) {
        return this.addShapelessRecipe(new ItemStack(output), input);
    }

    private IInputItemStack getRecipeInput(Object o) {
        if (o == null) {
            throw new NullPointerException("Null recipe input object.");
        }
        if (o instanceof IInputItemStack) {
            return (IInputItemStack)o;
        }
        if (o instanceof ItemStack) {
            return Recipes.inputFactory.getInput((ItemStack)o);
        }
        if (o instanceof Block) {
            return Recipes.inputFactory.getInput(new ItemStack((Block)o));
        }
        if (o instanceof Item) {
            return Recipes.inputFactory.getInput(new ItemStack((Item)o));
        }
        if (o instanceof String) {
            return Recipes.inputFactory.getInput((String)o);
        }
        if (o instanceof Fluid) {
            return Recipes.inputFactory.getInput((Fluid)o);
        }
        if (o instanceof FluidStack) {
            return Recipes.inputFactory.getInput(((FluidStack)o).getFluid(), ((FluidStack)o).amount);
        }
        throw new RuntimeException();
    }
}

