/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.recipe.IInputItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class InputFluidStack
implements IInputItemStack {
    private static volatile FluidHandlerInfo fluidHandlerInfo = new FluidHandlerInfo(Collections.emptyList(), LoaderState.PREINITIALIZATION);
    private final Fluid fluid;
    private final int amount;

    InputFluidStack(Fluid fluid) {
        this(fluid, 1000);
    }

    InputFluidStack(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public static List<ItemStack> getFluidContainer(Fluid fluid) {
        ItemStack container;
        IFluidHandlerItem handler;
        ArrayList<ItemStack> ret;
        FluidHandlerInfo info = fluidHandlerInfo;
        if (info.loaderState != LoaderState.AVAILABLE && info.loaderState != Loader.instance().getLoaderState()) {
            ret = new ArrayList();
            for (Item item : ForgeRegistries.ITEMS) {
                ItemStack stack = new ItemStack(item);
                handler = FluidUtil.getFluidHandler((ItemStack)stack);
                if (handler == null) continue;
                handler.drain(Integer.MAX_VALUE, true);
                container = handler.getContainer();
                if (FluidUtil.getFluidContained((ItemStack)container) != null) continue;
                ret.add(stack);
            }
            LoaderState state = Loader.instance().hasReachedState(LoaderState.AVAILABLE) ? LoaderState.AVAILABLE : Loader.instance().getLoaderState();
            fluidHandlerInfo = info = new FluidHandlerInfo(Collections.unmodifiableList(ret), state);
        }
        if (fluid == null) {
            return info.items;
        }
        ret = new ArrayList<ItemStack>();
        for (ItemStack stack : info.items) {
            handler = FluidUtil.getFluidHandler((ItemStack)stack.func_77946_l());
            if (handler == null || handler.fill(new FluidStack(fluid, Integer.MAX_VALUE), true) <= 0 || FluidUtil.getFluidContained((ItemStack)(container = handler.getContainer())) == null) continue;
            ret.add(container);
        }
        return ret;
    }

    @Override
    public boolean matches(ItemStack subject) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)subject);
        return fs == null && this.fluid == null || fs != null && fs.getFluid() == this.fluid && fs.amount >= this.amount;
    }

    @Override
    public int getAmount() {
        return 1;
    }

    @Override
    public void growAmount(int col) {
    }

    @Override
    public List<ItemStack> getInputs() {
        return InputFluidStack.getFluidContainer(this.fluid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (this.getClass() != obj.getClass()) return false;
        InputFluidStack other = (InputFluidStack)obj;
        if (other.fluid != this.fluid) return false;
        if (other.amount != this.amount) return false;
        return true;
    }

    private static class FluidHandlerInfo {
        final List<ItemStack> items;
        final LoaderState loaderState;

        FluidHandlerInfo(List<ItemStack> items, LoaderState loaderState) {
            this.items = items;
            this.loaderState = loaderState;
        }
    }
}

