/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.api.item.IEnergyItem;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class InputItemStack
implements IInputItemStack {
    public final ItemStack input;
    public int amount;

    public InputItemStack(ItemStack input) {
        this(input, ModUtils.getSize(input));
    }

    InputItemStack(ItemStack input, int amount) {
        this.input = input.func_77946_l();
        this.amount = amount;
    }

    @Override
    public boolean matches(ItemStack subject) {
        boolean energy = this.input.func_77973_b() instanceof IEnergyItem && subject.func_77973_b() instanceof IEnergyItem;
        return !(subject.func_77973_b() != this.input.func_77973_b() || subject.func_77960_j() != this.input.func_77960_j() && this.input.func_77960_j() != Short.MAX_VALUE && !energy || this.input.func_77960_j() != Short.MAX_VALUE && !energy && !ModUtils.matchesNBT(subject.func_77978_p(), this.input.func_77978_p()));
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public void growAmount(int col) {
        ++this.amount;
        this.input.func_190920_e(this.amount);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.singletonList(ModUtils.setSize(this.input, this.getAmount()));
    }

    public String toString() {
        return "RInputItemStack<" + ModUtils.setSize(this.input, this.amount) + ">";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (this.getClass() != obj.getClass()) return false;
        InputItemStack other = (InputItemStack)obj;
        if (!ModUtils.checkItemEqualityStrict(other.input, this.input)) return false;
        if (other.amount != this.amount) return false;
        return true;
    }
}

